/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.pyi;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PyiRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public static final Icon ICON = AllIcons.Gutter.Unique;

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            PyiRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PyiRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PyFunction || element instanceof PyTargetExpression || element instanceof PyClass) {
            PsiElement identifier;
            PsiElement originalElement;
            PsiElement identifier2;
            PsiElement pythonStub = PyiUtil.getPythonStub((PyElement)element);
            if (pythonStub != null && (identifier2 = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
                result.add(PyiRelatedItemLineMarkerProvider.createLineMarkerInfo(identifier2, pythonStub, "Has stub item"));
            }
            if ((originalElement = PyiUtil.getOriginalElement((PyElement)element)) != null && (identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
                result.add(PyiRelatedItemLineMarkerProvider.createLineMarkerInfo(identifier, originalElement, "Stub for item"));
            }
        }
    }

    @NotNull
    private static RelatedItemLineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element, @NotNull PsiElement relatedElement, @NotNull String itemTitle) {
        if (element == null) {
            PyiRelatedItemLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (relatedElement == null) {
            PyiRelatedItemLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (itemTitle == null) {
            PyiRelatedItemLineMarkerProvider.$$$reportNull$$$0(4);
        }
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)element.getProject());
        SmartPsiElementPointer relatedElementPointer = pointerManager.createSmartPsiElementPointer(relatedElement);
        String stubFileName = relatedElement.getContainingFile().getName();
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = new RelatedItemLineMarkerInfo(element, element.getTextRange(), ICON, 11, element1 -> {
            if (itemTitle == null) {
                PyiRelatedItemLineMarkerProvider.$$$reportNull$$$0(6);
            }
            return itemTitle + " in " + stubFileName;
        }, (e, elt) -> {
            PsiElement restoredRelatedElement = relatedElementPointer.getElement();
            if (restoredRelatedElement == null) {
                return;
            }
            int offset = restoredRelatedElement instanceof PsiFile ? -1 : restoredRelatedElement.getTextOffset();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)restoredRelatedElement);
            if (virtualFile != null && virtualFile.isValid()) {
                PsiNavigationSupport.getInstance().createNavigatable(restoredRelatedElement.getProject(), virtualFile, offset).navigate(true);
            }
        }, GutterIconRenderer.Alignment.RIGHT, (Collection)GotoRelatedItem.createItems(Collections.singletonList(relatedElement)));
        if (relatedItemLineMarkerInfo == null) {
            PyiRelatedItemLineMarkerProvider.$$$reportNull$$$0(5);
        }
        return relatedItemLineMarkerInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedElement";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTitle";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/pyi/PyiRelatedItemLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/pyi/PyiRelatedItemLineMarkerProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineMarkerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarkerInfo";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLineMarkerInfo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

