/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Preconditions;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPsiUtils {
    private static final Logger LOG = Logger.getInstance((String)PyPsiUtils.class.getName());

    private PyPsiUtils() {
    }

    @NotNull
    protected static <T extends PyElement> T[] nodesToPsi(ASTNode[] nodes, T[] array) {
        PyElement[] psiElements = (PyElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = (PyElement)nodes[i].getPsi();
        }
        if (psiElements == null) {
            PyPsiUtils.$$$reportNull$$$0(0);
        }
        return psiElements;
    }

    @Nullable
    public static PsiElement getPrevComma(@NotNull PsiElement element) {
        PsiElement prevNode;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(1);
        }
        return (prevNode = PyPsiUtils.getPrevNonWhitespaceSibling(element)) != null && prevNode.getNode().getElementType() == PyTokenTypes.COMMA ? prevNode : null;
    }

    @Nullable
    public static PsiElement getPrevNonWhitespaceSibling(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
    }

    @Nullable
    public static ASTNode getPrevNonWhitespaceSibling(@NotNull ASTNode node) {
        if (node == null) {
            PyPsiUtils.$$$reportNull$$$0(2);
        }
        return PyPsiUtils.skipSiblingsBackward(node, TokenSet.WHITE_SPACE);
    }

    @Nullable
    public static PsiElement getPrevNonCommentSibling(@Nullable PsiElement start, boolean strict) {
        if (!(strict || start instanceof PsiWhiteSpace || start instanceof PsiComment)) {
            return start;
        }
        return PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)start);
    }

    @Nullable
    public static PsiElement getNextComma(@NotNull PsiElement element) {
        PsiElement nextNode;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(3);
        }
        return (nextNode = PyPsiUtils.getNextNonWhitespaceSibling(element)) != null && nextNode.getNode().getElementType() == PyTokenTypes.COMMA ? nextNode : null;
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceSibling(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceSiblingOnSameLine(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(4);
        }
        for (PsiElement cur = element.getNextSibling(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof PsiWhiteSpace)) {
                return cur;
            }
            if (cur.textContains('\n')) break;
        }
        return null;
    }

    @Nullable
    public static ASTNode getNextNonWhitespaceSibling(@NotNull ASTNode after) {
        if (after == null) {
            PyPsiUtils.$$$reportNull$$$0(5);
        }
        return PyPsiUtils.skipSiblingsForward(after, TokenSet.WHITE_SPACE);
    }

    @Nullable
    public static PsiElement getNextNonCommentSibling(@Nullable PsiElement start, boolean strict) {
        if (!(strict || start instanceof PsiWhiteSpace || start instanceof PsiComment)) {
            return start;
        }
        return PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)start);
    }

    @Nullable
    public static PsiElement getNextSignificantLeaf(@Nullable PsiElement element, boolean ignoreComments) {
        while (element != null && StringUtil.isEmptyOrSpaces((String)element.getText()) || ignoreComments && element instanceof PsiComment) {
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return element;
    }

    @Nullable
    public static PsiElement getPrevSignificantLeaf(@Nullable PsiElement element, boolean ignoreComments) {
        while (element != null && StringUtil.isEmptyOrSpaces((String)element.getText()) || ignoreComments && element instanceof PsiComment) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        return element;
    }

    @Nullable
    public static PsiElement getAdjacentComma(@NotNull PsiElement element) {
        PsiElement nextComma;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(6);
        }
        return (nextComma = PyPsiUtils.getNextComma(element)) != null ? nextComma : PyPsiUtils.getPrevComma(element);
    }

    @Nullable
    public static ASTNode skipSiblingsForward(@Nullable ASTNode node, @NotNull TokenSet types) {
        if (types == null) {
            PyPsiUtils.$$$reportNull$$$0(7);
        }
        if (node == null) {
            return null;
        }
        for (ASTNode next = node.getTreeNext(); next != null; next = next.getTreeNext()) {
            if (types.contains(next.getElementType())) continue;
            return next;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipSiblingsBackward(@Nullable ASTNode node, @NotNull TokenSet types) {
        if (types == null) {
            PyPsiUtils.$$$reportNull$$$0(8);
        }
        if (node == null) {
            return null;
        }
        for (ASTNode prev = node.getTreePrev(); prev != null; prev = prev.getTreePrev()) {
            if (types.contains(prev.getElementType())) continue;
            return prev;
        }
        return null;
    }

    @Nullable
    public static PsiElement getFirstChildOfType(@NotNull PsiElement element, @NotNull PyElementType type) {
        ASTNode child;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(9);
        }
        if (type == null) {
            PyPsiUtils.$$$reportNull$$$0(10);
        }
        return (child = element.getNode().findChildByType((IElementType)type)) != null ? child.getPsi() : null;
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, @NotNull TokenSet filter, int number) {
        ASTNode node;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(11);
        }
        if (filter == null) {
            PyPsiUtils.$$$reportNull$$$0(12);
        }
        if ((node = element.getNode()) != null) {
            ASTNode[] children = node.getChildren(filter);
            return 0 <= number && number < children.length ? children[number].getPsi() : null;
        }
        return null;
    }

    public static void addBeforeInParent(@NotNull PsiElement anchor, PsiElement ... newElements) {
        ASTNode anchorNode;
        if (anchor == null) {
            PyPsiUtils.$$$reportNull$$$0(13);
        }
        if (newElements == null) {
            PyPsiUtils.$$$reportNull$$$0(14);
        }
        LOG.assertTrue((anchorNode = anchor.getNode()) != null);
        for (PsiElement newElement : newElements) {
            anchorNode.getTreeParent().addChild(newElement.getNode(), anchorNode);
        }
    }

    public static void removeElements(PsiElement ... elements) {
        ASTNode parentNode;
        if (elements == null) {
            PyPsiUtils.$$$reportNull$$$0(15);
        }
        LOG.assertTrue((parentNode = elements[0].getParent().getNode()) != null);
        for (PsiElement element : elements) {
            parentNode.removeChild(element.getNode());
        }
    }

    @Nullable
    public static PsiElement getStatement(@NotNull PsiElement element) {
        PyElement compStatement;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(16);
        }
        if ((compStatement = PyPsiUtils.getStatementList(element)) == null) {
            return null;
        }
        return PyPsiUtils.getParentRightBefore(element, (PsiElement)compStatement);
    }

    public static PyElement getStatementList(PsiElement element) {
        return element instanceof PyFile || element instanceof PyStatementList ? (PyElement)element : (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFile.class, PyStatementList.class});
    }

    @Nullable
    public static PsiElement getParentRightBefore(@NotNull PsiElement element, @NotNull PsiElement superParent) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(17);
        }
        if (superParent == null) {
            PyPsiUtils.$$$reportNull$$$0(18);
        }
        return PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, element1 -> {
            if (superParent == null) {
                PyPsiUtils.$$$reportNull$$$0(52);
            }
            return element1.getParent() == superParent;
        });
    }

    public static int getElementIndentation(PsiElement element) {
        PyElement compStatement = PyPsiUtils.getStatementList(element);
        PsiElement statement = PyPsiUtils.getParentRightBefore(element, (PsiElement)compStatement);
        if (statement == null) {
            return 0;
        }
        PsiElement sibling = statement.getPrevSibling();
        if (sibling == null) {
            sibling = compStatement.getPrevSibling();
        }
        String whitespace = sibling instanceof PsiWhiteSpace ? sibling.getText() : "";
        int i = whitespace.lastIndexOf("\n");
        return i != -1 ? whitespace.length() - i - 1 : 0;
    }

    public static void removeRedundantPass(PyStatementList statementList) {
        PyStatement[] statements = statementList.getStatements();
        if (statements.length > 1) {
            for (PyStatement statement : statements) {
                if (!(statement instanceof PyPassStatement)) continue;
                statement.delete();
            }
        }
    }

    public static boolean isMethodContext(PsiElement element) {
        PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFile.class, PyFunction.class, PyClass.class});
        return parent instanceof PyFunction && PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PyFile.class, PyClass.class}) instanceof PyClass;
    }

    @NotNull
    public static PsiElement getRealContext(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(19);
        }
        PyPsiUtils.assertValid(element);
        PsiFile file = element.getContainingFile();
        if (file instanceof PyExpressionCodeFragment) {
            PsiElement context = file.getContext();
            PsiElement psiElement = context != null ? context : element;
            if (psiElement == null) {
                PyPsiUtils.$$$reportNull$$$0(20);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PyPsiUtils.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    public static void deleteAdjacentCommaWithWhitespaces(@NotNull PsiElement element, @NotNull PsiElement child) {
        PsiElement commaNode;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(22);
        }
        if (child == null) {
            PyPsiUtils.$$$reportNull$$$0(23);
        }
        if ((commaNode = PyPsiUtils.getAdjacentComma(child)) != null) {
            PsiElement nextNonWhitespace = PyPsiUtils.getNextNonWhitespaceSibling(commaNode);
            PsiElement last = nextNonWhitespace == null ? element.getLastChild() : nextNonWhitespace.getPrevSibling();
            PsiElement prevNonWhitespace = PyPsiUtils.getPrevNonWhitespaceSibling(commaNode);
            PsiElement first = prevNonWhitespace == null ? element.getFirstChild() : prevNonWhitespace.getNextSibling();
            element.deleteChildRange(first, last);
        }
    }

    @NotNull
    public static List<PsiComment> getPrecedingComments(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(24);
        }
        List<PsiComment> list = PyPsiUtils.getPrecedingComments(element, true);
        if (list == null) {
            PyPsiUtils.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public static List<PsiComment> getPrecedingComments(@NotNull PsiElement element, boolean stopAtBlankLine) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(26);
        }
        ArrayList<PsiComment> result = new ArrayList<PsiComment>();
        while (true) {
            int newLinesCount = 0;
            element = element.getPrevSibling();
            while (element instanceof PsiWhiteSpace) {
                newLinesCount += StringUtil.getLineBreakCount((CharSequence)element.getText());
                element = element.getPrevSibling();
            }
            if (stopAtBlankLine && newLinesCount > 1 || !(element instanceof PsiComment)) break;
            result.add((PsiComment)element);
        }
        Collections.reverse(result);
        ArrayList<PsiComment> arrayList = result;
        if (arrayList == null) {
            PyPsiUtils.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    static <T, U extends PsiElement> List<T> collectStubChildren(@NotNull U e, @Nullable StubElement<U> stub, final @NotNull IElementType elementType) {
        if (e == null) {
            PyPsiUtils.$$$reportNull$$$0(28);
        }
        if (elementType == null) {
            PyPsiUtils.$$$reportNull$$$0(29);
        }
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        if (stub != null) {
            List children = stub.getChildrenStubs();
            for (StubElement child : children) {
                if (child.getStubType() != elementType) continue;
                result.add(child.getPsi());
            }
        } else {
            e.acceptChildren((PsiElementVisitor)new TopLevelVisitor(){

                @Override
                protected void checkAddElement(PsiElement node) {
                    if (node.getNode().getElementType() == elementType) {
                        result.add(node);
                    }
                }
            });
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            PyPsiUtils.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    static List<PsiElement> collectAllStubChildren(PsiElement e, StubElement stub) {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        if (stub != null) {
            List children = stub.getChildrenStubs();
            for (StubElement child : children) {
                result.add(child.getPsi());
            }
        } else {
            e.acceptChildren((PsiElementVisitor)new TopLevelVisitor(){

                @Override
                protected void checkAddElement(PsiElement node) {
                    result.add(node);
                }
            });
        }
        return result;
    }

    public static int findArgumentIndex(PyCallExpression call, PsiElement argument) {
        PyExpression[] args = call.getArguments();
        for (int i = 0; i < args.length; ++i) {
            PyExpression expression = args[i];
            if (expression instanceof PyKeywordArgument) {
                expression = ((PyKeywordArgument)expression).getValueExpression();
            }
            if ((expression = PyPsiUtils.flattenParens(expression)) != argument) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static PyTargetExpression getAttribute(@NotNull PyFile file, @NotNull String name) {
        PyTargetExpression attr;
        if (file == null) {
            PyPsiUtils.$$$reportNull$$$0(31);
        }
        if (name == null) {
            PyPsiUtils.$$$reportNull$$$0(32);
        }
        if ((attr = file.findTopLevelAttribute(name)) == null) {
            for (PyFromImportStatement element : file.getFromImports()) {
                PsiElement resolved;
                PyReferenceExpression expression = element.getImportSource();
                if (expression == null || !((resolved = expression.getReference().resolve()) instanceof PyFile) || resolved == file) continue;
                return ((PyFile)resolved).findTopLevelAttribute(name);
            }
        }
        return attr;
    }

    public static List<PyExpression> getAttributeValuesFromFile(@NotNull PyFile file, @NotNull String name) {
        if (file == null) {
            PyPsiUtils.$$$reportNull$$$0(33);
        }
        if (name == null) {
            PyPsiUtils.$$$reportNull$$$0(34);
        }
        ArrayList result = ContainerUtil.newArrayList();
        PyTargetExpression attr = file.findTopLevelAttribute(name);
        if (attr != null) {
            PyPsiUtils.sequenceToList(result, attr.findAssignedValue());
        }
        return result;
    }

    public static void sequenceToList(List<? super PyExpression> result, PyExpression value) {
        if ((value = PyPsiUtils.flattenParens(value)) instanceof PySequenceExpression) {
            result.addAll(ContainerUtil.newArrayList((Object[])((PySequenceExpression)value).getElements()));
        } else {
            result.add(value);
        }
    }

    public static List<String> getStringValues(PyExpression[] elements) {
        ArrayList results = ContainerUtil.newArrayList();
        for (PyExpression element : elements) {
            if (!(element instanceof PyStringLiteralExpression)) continue;
            results.add(((PyStringLiteralExpression)element).getStringValue());
        }
        return results;
    }

    @Nullable
    public static PyExpression flattenParens(@Nullable PyExpression expr) {
        while (expr instanceof PyParenthesizedExpression) {
            expr = ((PyParenthesizedExpression)expr).getContainedExpression();
        }
        return expr;
    }

    @Nullable
    public static String strValue(@Nullable PyExpression expression) {
        return expression instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)expression).getStringValue() : null;
    }

    public static boolean isBefore(@NotNull PsiElement element, @NotNull PsiElement element2) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(35);
        }
        if (element2 == null) {
            PyPsiUtils.$$$reportNull$$$0(36);
        }
        return element.getTextOffset() <= element2.getTextOffset();
    }

    @Nullable
    public static QualifiedName asQualifiedName(@Nullable PyExpression expr) {
        return expr instanceof PyQualifiedExpression ? ((PyQualifiedExpression)expr).asQualifiedName() : null;
    }

    @NotNull
    public static PyExpression getFirstQualifier(@NotNull PyQualifiedExpression expr) {
        PyExpression qualifier;
        if (expr == null) {
            PyPsiUtils.$$$reportNull$$$0(37);
        }
        if ((qualifier = expr.getQualifier()) instanceof PyQualifiedExpression) {
            PyExpression pyExpression = PyPsiUtils.getFirstQualifier((PyQualifiedExpression)qualifier);
            if (pyExpression == null) {
                PyPsiUtils.$$$reportNull$$$0(38);
            }
            return pyExpression;
        }
        PyQualifiedExpression pyQualifiedExpression = expr;
        if (pyQualifiedExpression == null) {
            PyPsiUtils.$$$reportNull$$$0(39);
        }
        return pyQualifiedExpression;
    }

    @NotNull
    public static String toPath(@Nullable PyQualifiedExpression expr) {
        if (expr != null) {
            QualifiedName qName = expr.asQualifiedName();
            if (qName != null) {
                String string = qName.toString();
                if (string == null) {
                    PyPsiUtils.$$$reportNull$$$0(40);
                }
                return string;
            }
            String name = expr.getName();
            if (name != null) {
                String string = name;
                if (string == null) {
                    PyPsiUtils.$$$reportNull$$$0(41);
                }
                return string;
            }
        }
        if ("" == null) {
            PyPsiUtils.$$$reportNull$$$0(42);
        }
        return "";
    }

    @Nullable
    protected static QualifiedName asQualifiedName(@NotNull PyQualifiedExpression expr) {
        if (expr == null) {
            PyPsiUtils.$$$reportNull$$$0(43);
        }
        LinkedList<String> path = new LinkedList<String>();
        String firstName = expr.getReferencedName();
        if (firstName == null) {
            return null;
        }
        path.add(firstName);
        PyExpression qualifier = expr.getQualifier();
        while (qualifier != null) {
            PyReferenceExpression qualifierReference = (PyReferenceExpression)ObjectUtils.tryCast((Object)qualifier, PyReferenceExpression.class);
            if (qualifierReference == null) {
                return null;
            }
            String qualifierName = qualifierReference.getReferencedName();
            if (qualifierName == null) {
                return null;
            }
            path.add(0, qualifierName);
            qualifier = qualifierReference.getQualifier();
        }
        return QualifiedName.fromComponents(path);
    }

    public static void assertValid(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        PsiUtilCore.ensureValid((PsiElement)element);
    }

    public static void assertValid(@NotNull Module module2) {
        if (module2 == null) {
            PyPsiUtils.$$$reportNull$$$0(44);
        }
        Preconditions.checkArgument((!module2.isDisposed() ? 1 : 0) != 0, (Object)String.format("Module %s is disposed", module2));
    }

    @Nullable
    public static PsiFileSystemItem getFileSystemItem(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(45);
        }
        if (element instanceof PsiFileSystemItem) {
            return (PsiFileSystemItem)element;
        }
        return element.getContainingFile();
    }

    @Nullable
    public static String getContainingFilePath(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(46);
        }
        if ((file = element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : element.getContainingFile().getVirtualFile()) != null) {
            return FileUtil.toSystemDependentName((String)file.getPath());
        }
        return null;
    }

    public static boolean containsImport(@NotNull PyFile file, @NotNull String source) {
        if (file == null) {
            PyPsiUtils.$$$reportNull$$$0(47);
        }
        if (source == null) {
            PyPsiUtils.$$$reportNull$$$0(48);
        }
        QualifiedName sourceQName = QualifiedName.fromDottedString((String)source);
        return Stream.concat(file.getFromImports().stream().map(PyFromImportStatement::getImportSourceQName), file.getImportTargets().stream().map(PyImportElement::getImportedQName)).filter(Objects::nonNull).anyMatch(name -> name.matchesPrefix(sourceQName));
    }

    @NotNull
    public static String getElementTextWithoutHostEscaping(@NotNull PsiElement element) {
        InjectedLanguageManager manager;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(49);
        }
        if ((manager = InjectedLanguageManager.getInstance((Project)element.getProject())).isInjectedFragment(element.getContainingFile())) {
            String string = manager.getUnescapedText(element);
            if (string == null) {
                PyPsiUtils.$$$reportNull$$$0(50);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            PyPsiUtils.$$$reportNull$$$0(51);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyPsiUtils";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 35: 
            case 45: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 18: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superParent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 31: 
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "nodesToPsi";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyPsiUtils";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealContext";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecedingComments";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStubChildren";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstQualifier";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "toPath";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTextWithoutHostEscaping";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPrevComma";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNonWhitespaceSibling";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNextComma";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNextNonWhitespaceSiblingOnSameLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNextNonWhitespaceSibling";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdjacentComma";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsForward";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsBackward";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildOfType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getChildByFilter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeInParent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeElements";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStatement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getParentRightBefore";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRealContext";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteAdjacentCommaWithWhitespaces";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPrecedingComments";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectStubChildren";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValuesFromFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isBefore";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFirstQualifier";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "asQualifiedName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "assertValid";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getFileSystemItem";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFilePath";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "containsImport";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getElementTextWithoutHostEscaping";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getParentRightBefore$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class TopLevelVisitor
    extends PyRecursiveElementVisitor {
        private TopLevelVisitor() {
        }

        @Override
        public void visitPyElement(PyElement node) {
            super.visitPyElement(node);
            this.checkAddElement((PsiElement)node);
        }

        @Override
        public void visitPyClass(PyClass node) {
            this.checkAddElement((PsiElement)node);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            this.checkAddElement(node);
        }

        protected abstract void checkAddElement(PsiElement var1);
    }
}

