/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyCompatibilityInspection;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ReplaceFunctionWithSetLiteralQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySetFunctionToLiteralInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.set.function.to.literal", new Object[0]);
        if (string == null) {
            PySetFunctionToLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PySetFunctionToLiteralInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PySetFunctionToLiteralInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PySetFunctionToLiteralInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    public static PyElement[] getSetCallArguments(PyCallExpression node) {
        PyExpression argument = node.getArguments()[0];
        if (argument instanceof PyStringLiteralExpression) {
            return PyElement.EMPTY_ARRAY;
        }
        if (argument instanceof PySequenceExpression || argument instanceof PyParenthesizedExpression && ((PyParenthesizedExpression)argument).getContainedExpression() instanceof PyTupleExpression) {
            if (argument instanceof PySequenceExpression) {
                return ((PySequenceExpression)argument).getElements();
            }
            PyExpression tuple = ((PyParenthesizedExpression)argument).getContainedExpression();
            if (tuple instanceof PyTupleExpression) {
                return ((PyTupleExpression)tuple).getElements();
            }
        }
        return PyElement.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyElement[] elements;
            PyExpression[] arguments;
            if (!Visitor.isAvailable(node)) {
                return;
            }
            PyExpression callee = node.getCallee();
            if (node.isCalleeText("set") && callee != null && PyBuiltinCache.isInBuiltins(callee) && (arguments = node.getArguments()).length == 1 && (elements = PySetFunctionToLiteralInspection.getSetCallArguments(node)).length != 0) {
                this.registerProblem((PsiElement)node, PyBundle.message("INSP.NAME.set.function.to.literal", new Object[0]), new ReplaceFunctionWithSetLiteralQuickFix());
            }
        }

        private static boolean isAvailable(PyCallExpression node) {
            InspectionProfileEntry inspection;
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)node.getProject()).getCurrentProfile();
            InspectionToolWrapper inspectionTool = profile.getInspectionTool("PyCompatibilityInspection", node.getProject());
            if (inspectionTool != null && (inspection = inspectionTool.getTool()) instanceof PyCompatibilityInspection) {
                JDOMExternalizableStringList versions = ((PyCompatibilityInspection)inspection).ourVersions;
                for (String s : versions) {
                    if (LanguageLevel.fromPythonVersion(s).supportsSetLiterals()) continue;
                    return false;
                }
            }
            return LanguageLevel.forElement((PsiElement)node).supportsSetLiterals();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection$Visitor", "<init>"));
        }
    }
}

