/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class PyOtherCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myPanel;
    private JBCheckBox myAddTrailingBlankLineCheckbox;
    private JBCheckBox myUseContinuationIndentForArguments;
    private JBCheckBox myUseContinuationIndentForCollectionsAndComprehensions;
    private ComboBox myDictAlignmentCombo;
    private JPanel myPreviewPanel;
    public static final String PREVIEW = "x = max(\n    1,\n    2,\n    3)\n\n{\n    \"green\": 42,\n    \"eggs and ham\": -0.0e0\n}\n\nodds = [\n    num for num in range(42)\n    if num % 2 != 0 \n]";

    protected PyOtherCodeStylePanel(CodeStyleSettings settings) {
        super((Language)PythonLanguage.getInstance(), null, settings);
        this.$$$setupUI$$$();
        this.addPanelToWatch(this.myPanel);
        this.installPreviewPanel(this.myPreviewPanel);
        for (PyCodeStyleSettings.DictAlignment alignment : PyCodeStyleSettings.DictAlignment.values()) {
            this.myDictAlignmentCombo.addItem((Object)alignment);
        }
        this.myDictAlignmentCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PyOtherCodeStylePanel.this.somethingChanged();
                }
            }
        });
        this.myAddTrailingBlankLineCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyOtherCodeStylePanel.this.somethingChanged();
            }
        });
        this.myUseContinuationIndentForArguments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyOtherCodeStylePanel.this.somethingChanged();
            }
        });
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return HighlighterFactory.createHighlighter((SyntaxHighlighter)new PyHighlighter(LanguageLevel.PYTHON26), (EditorColorsScheme)scheme);
    }

    protected int getRightMargin() {
        return 80;
    }

    @NotNull
    protected FileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        if (pythonFileType == null) {
            PyOtherCodeStylePanel.$$$reportNull$$$0(0);
        }
        return pythonFileType;
    }

    protected String getPreviewText() {
        return PREVIEW;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        PyCodeStyleSettings pySettings = PyOtherCodeStylePanel.getCustomSettings(settings);
        for (PyCodeStyleSettings.DictAlignment alignment : PyCodeStyleSettings.DictAlignment.values()) {
            if (pySettings.DICT_ALIGNMENT != alignment.asInt()) continue;
            this.myDictAlignmentCombo.setSelectedItem((Object)alignment);
            break;
        }
        this.myAddTrailingBlankLineCheckbox.setSelected(pySettings.BLANK_LINE_AT_FILE_END);
        this.myUseContinuationIndentForArguments.setSelected(pySettings.USE_CONTINUATION_INDENT_FOR_ARGUMENTS);
        this.myUseContinuationIndentForCollectionsAndComprehensions.setSelected(pySettings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS);
    }

    public void apply(CodeStyleSettings settings) {
        PyCodeStyleSettings customSettings = PyOtherCodeStylePanel.getCustomSettings(settings);
        customSettings.DICT_ALIGNMENT = this.getDictAlignmentAsInt();
        customSettings.BLANK_LINE_AT_FILE_END = this.ensureTrailingBlankLine();
        customSettings.USE_CONTINUATION_INDENT_FOR_ARGUMENTS = this.useContinuationIndentForArguments();
        customSettings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS = this.useContinuationIndentForCollectionLiterals();
    }

    public boolean isModified(CodeStyleSettings settings) {
        PyCodeStyleSettings customSettings = PyOtherCodeStylePanel.getCustomSettings(settings);
        return customSettings.DICT_ALIGNMENT != this.getDictAlignmentAsInt() || customSettings.BLANK_LINE_AT_FILE_END != this.ensureTrailingBlankLine() || customSettings.USE_CONTINUATION_INDENT_FOR_ARGUMENTS != this.useContinuationIndentForArguments() || customSettings.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS != this.useContinuationIndentForCollectionLiterals();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    @NotNull
    private static PyCodeStyleSettings getCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            PyOtherCodeStylePanel.$$$reportNull$$$0(1);
        }
        PyCodeStyleSettings pyCodeStyleSettings = (PyCodeStyleSettings)settings.getCustomSettings(PyCodeStyleSettings.class);
        if (pyCodeStyleSettings == null) {
            PyOtherCodeStylePanel.$$$reportNull$$$0(2);
        }
        return pyCodeStyleSettings;
    }

    private int getDictAlignmentAsInt() {
        return ((PyCodeStyleSettings.DictAlignment)((Object)this.myDictAlignmentCombo.getSelectedItem())).asInt();
    }

    private boolean ensureTrailingBlankLine() {
        return this.myAddTrailingBlankLineCheckbox.isSelected();
    }

    private boolean useContinuationIndentForArguments() {
        return this.myUseContinuationIndentForArguments.isSelected();
    }

    protected boolean useContinuationIndentForCollectionLiterals() {
        return this.myUseContinuationIndentForCollectionsAndComprehensions.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyOtherCodeStylePanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyOtherCodeStylePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        ComboBox comboBox;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 4, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("formatter.panel.dict.alignment.label"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddTrailingBlankLineCheckbox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("formatter.panel.add.trailing.line.feed"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myDictAlignmentCombo = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("formatter.panel.use.continuation.indent.for.title"), (int)0, (int)0, null, null));
        this.myUseContinuationIndentForArguments = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("formatter.panel.use.continuation.indent.for.arguments"));
        jPanel4.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseContinuationIndentForCollectionsAndComprehensions = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("formatter.panel.use.continuation.indent.for.collection.literals"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 3, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

