/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.findUsages.PyClassFindUsagesHandler;
import com.jetbrains.python.findUsages.PyFunctionFindUsagesHandler;
import com.jetbrains.python.findUsages.PyModuleFindUsagesHandler;
import com.jetbrains.python.findUsages.PyTargetExpressionFindUsagesHandler;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            PyFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        return element instanceof PyClass || element instanceof PyFile && PyUtil.isPackage((PyFile)element) || element instanceof PyImportedModule || element instanceof PyFunction || element instanceof PyTargetExpression;
    }

    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        PsiElement resolved;
        if (element == null) {
            PyFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        if (element instanceof PyImportedModule && (resolved = ((PyImportedModule)element).resolve()) != null) {
            element = resolved;
        }
        if (element instanceof PsiFileSystemItem) {
            return new PyModuleFindUsagesHandler((PsiFileSystemItem)element);
        }
        if (element instanceof PyFunction) {
            PsiElement next;
            TypeEvalContext context;
            Collection superMethods;
            if (!forHighlightUsages && (superMethods = PySuperMethodsSearch.search((PyFunction)element, true, context = TypeEvalContext.userInitiated(element.getProject(), null)).findAll()).size() > 0 && (next = (PsiElement)superMethods.iterator().next()) instanceof PyFunction && !PyFindUsagesHandlerFactory.isInObject((PyFunction)next)) {
                int rc = Messages.showYesNoDialog((Project)element.getProject(), (String)("Method " + ((PyFunction)element).getName() + " overrides method of class " + ((PyFunction)next).getContainingClass().getName() + ".\nDo you want to find usages of the base method?"), (String)"Find Usages", (Icon)Messages.getQuestionIcon());
                if (rc == 0) {
                    ArrayList<PsiElement> allMethods = new ArrayList<PsiElement>();
                    allMethods.add(element);
                    allMethods.addAll(superMethods);
                    return new PyFunctionFindUsagesHandler(element, allMethods);
                }
                return new PyFunctionFindUsagesHandler(element);
            }
            return new PyFunctionFindUsagesHandler(element);
        }
        if (element instanceof PyClass) {
            return new PyClassFindUsagesHandler((PyClass)element);
        }
        if (element instanceof PyTargetExpression) {
            return new PyTargetExpressionFindUsagesHandler((PyTargetExpression)element);
        }
        return null;
    }

    private static boolean isInObject(PyFunction fun) {
        PyClass containingClass = fun.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return PyUtil.isObjectClass(containingClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/python/findUsages/PyFindUsagesHandlerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canFindUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFindUsagesHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

