/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseQuoteHandler
extends SimpleTokenSetQuoteHandler
implements MultiCharQuoteHandler {
    private final char[] ourAutoClosingChars;

    public BaseQuoteHandler(TokenSet tokenSet, char[] autoClosingChars) {
        super(tokenSet);
        this.ourAutoClosingChars = autoClosingChars;
        Arrays.sort(this.ourAutoClosingChars);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean mayBeTripleQuote;
        Document document = iterator.getDocument();
        if (document == null) {
            return false;
        }
        CharSequence text2 = document.getCharsSequence();
        boolean mayBeSingleQuote = offset + 1 >= text2.length() || Arrays.binarySearch(this.ourAutoClosingChars, text2.charAt(offset + 1)) >= 0;
        boolean bl = mayBeTripleQuote = offset + 4 >= text2.length() || Arrays.binarySearch(this.ourAutoClosingChars, text2.charAt(offset + 4)) >= 0;
        if (mayBeTripleQuote && this.isOpeningTripleQuote(iterator, offset)) {
            return true;
        }
        if (mayBeSingleQuote) {
            int start;
            if (super.isOpeningQuote(iterator, offset)) {
                return true;
            }
            if (this.myLiteralTokenSet.contains(iterator.getTokenType()) && offset - (start = iterator.getStart()) <= 3 && BaseQuoteHandler.getLiteralStartOffset(text2, start) == offset) {
                return true;
            }
        }
        return false;
    }

    private boolean isOpeningTripleQuote(HighlighterIterator iterator, int offset) {
        String text2 = iterator.getDocument().getText();
        char theQuote = text2.charAt(offset);
        IElementType tokenType = iterator.getTokenType();
        if (this.myLiteralTokenSet.contains(tokenType) && offset >= 2 && text2.charAt(offset - 1) == theQuote && text2.charAt(offset - 2) == theQuote && (offset < 3 || text2.charAt(offset - 3) != theQuote)) {
            int tokenStart = iterator.getStart();
            if (offset + 1 == tokenStart && tokenType == PyTokenTypes.FSTRING_TEXT) {
                iterator.retreat();
                boolean afterFStringStart = iterator.getTokenType() == PyTokenTypes.FSTRING_START;
                iterator.advance();
                return afterFStringStart;
            }
            return BaseQuoteHandler.getLiteralStartOffset(text2, tokenStart) == offset - 2;
        }
        return false;
    }

    private static int getLiteralStartOffset(CharSequence text2, int start) {
        return PyStringLiteralUtil.getPrefixEndOffset(text2, start);
    }

    protected boolean isNonClosedLiteral(HighlighterIterator iterator, CharSequence chars) {
        int end = iterator.getEnd();
        if (BaseQuoteHandler.getLiteralStartOffset(chars, iterator.getStart()) >= end - 1) {
            return true;
        }
        char endSymbol = chars.charAt(end - 1);
        if (endSymbol != '\"' && endSymbol != '\'') {
            return true;
        }
        return end >= 3 && endSymbol == chars.charAt(end - 2) && chars.charAt(end - 2) == chars.charAt(end - 3) && (end < 4 || chars.charAt(end - 4) != endSymbol);
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        IElementType tokenType = iterator.getTokenType();
        if (this.myLiteralTokenSet.contains(tokenType)) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            if (end - start >= 1 && offset == end - 1) {
                Character ch;
                Document doc = iterator.getDocument();
                if (doc == null) {
                    return false;
                }
                CharSequence chars = doc.getCharsSequence();
                return chars.length() <= offset + 1 || Arrays.binarySearch(this.ourAutoClosingChars, (ch = Character.valueOf(chars.charAt(offset + 1))).charValue()) >= 0;
            }
        }
        return false;
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            BaseQuoteHandler.$$$reportNull$$$0(0);
        }
        Document document = iterator.getDocument();
        String text2 = document.getText();
        char theQuote = text2.charAt(offset - 1);
        if (this.isOpeningTripleQuote(iterator, offset - 1)) {
            return StringUtil.repeat((String)String.valueOf(theQuote), (int)3);
        }
        if (super.isOpeningQuote(iterator, offset - 1)) {
            return String.valueOf(theQuote);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/jetbrains/python/editor/BaseQuoteHandler", "getClosingQuote"));
    }
}

