/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.editor.BaseQuoteHandler;

public class PyTripleQuoteBackspaceDelegate
extends BackspaceHandlerDelegate {
    private boolean isTripleQuote;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        this.isTripleQuote = false;
        if (c == '\"' || c == '\'' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            boolean mayBeTripleQuote;
            QuoteHandler quoteHandler = TypedHandler.getQuoteHandler((PsiFile)file, (Editor)editor);
            if (!(quoteHandler instanceof BaseQuoteHandler)) {
                return;
            }
            int offset = editor.getCaretModel().getCurrentCaret().getOffset();
            String text2 = editor.getDocument().getText();
            boolean bl = mayBeTripleQuote = offset >= 3 && offset + 2 < text2.length();
            if (mayBeTripleQuote) {
                HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
                boolean hasTripleQuoteAfter = offset + 2 < text2.length() && text2.charAt(offset) == c && text2.charAt(offset + 1) == c && text2.charAt(offset + 2) == c;
                this.isTripleQuote = quoteHandler.isOpeningQuote(iterator, offset - 1) && hasTripleQuoteAfter;
            }
        }
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        if (this.isTripleQuote) {
            int offset = editor.getCaretModel().getCurrentCaret().getOffset();
            editor.getDocument().deleteString(offset - 2, offset + 3);
            return true;
        }
        return false;
    }
}

