/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.vcs.VcsException;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.CachingFileTester;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.text.ParseException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableManager {
    private static final Logger LOG = Logger.getInstance(GitExecutableManager.class);
    @NotNull
    private final GitVcsApplicationSettings myApplicationSettings;
    @NotNull
    private final AtomicNotNullLazyValue<String> myDetectedExecutable;
    @NotNull
    private final CachingFileTester<GitVersion> myVersionCache;

    public static GitExecutableManager getInstance() {
        return (GitExecutableManager)ServiceManager.getService(GitExecutableManager.class);
    }

    public GitExecutableManager(@NotNull GitVcsApplicationSettings applicationSettings) {
        if (applicationSettings == null) {
            GitExecutableManager.$$$reportNull$$$0(0);
        }
        this.myApplicationSettings = applicationSettings;
        this.myDetectedExecutable = AtomicNotNullLazyValue.createValue(new GitExecutableDetector()::detect);
        this.myVersionCache = new CachingFileTester<GitVersion>(){

            @Override
            @NotNull
            protected GitVersion testFile(@NotNull String filePath) throws VcsException, ParseException {
                if (filePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitVersion gitVersion = GitExecutableManager.doGetGitVersion(filePath);
                if (gitVersion == null) {
                    1.$$$reportNull$$$0(1);
                }
                return gitVersion;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filePath";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/config/GitExecutableManager$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/config/GitExecutableManager$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "testFile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "testFile";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static GitVersion doGetGitVersion(@NotNull String pathToGit) throws VcsException, ParseException {
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(1);
        }
        LOG.debug("Acquiring git version for " + pathToGit);
        GitLineHandler handler = new GitLineHandler(null, new File("."), pathToGit, GitCommand.VERSION, Collections.emptyList());
        handler.setPreValidateExecutable(false);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String rawResult = result2.getOutputOrThrow(new int[0]);
        GitVersion version = GitVersion.parse(rawResult);
        LOG.info("Git version for " + pathToGit + " : " + version.getPresentation());
        return version;
    }

    @NotNull
    public String getPathToGit() {
        String path = this.myApplicationSettings.getSavedPathToGit();
        String string = path == null ? this.getDetectedExecutable() : path;
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPathToGit(@NotNull Project project) {
        String path;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(3);
        }
        String string = (path = GitVcsSettings.getInstance(project).getPathToGit()) == null ? this.getPathToGit() : path;
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getDetectedExecutable() {
        String string = (String)this.myDetectedExecutable.getValue();
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public GitVersion getVersion(@NotNull Project project) {
        String projectExecutablePath;
        CachingFileTester.TestResult result2;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(6);
        }
        if ((result2 = this.myVersionCache.getCachedResultForFile(projectExecutablePath = this.getPathToGit(project))) == null || result2.getResult() == null) {
            GitVersion gitVersion = GitVersion.NULL;
            if (gitVersion == null) {
                GitExecutableManager.$$$reportNull$$$0(7);
            }
            return gitVersion;
        }
        GitVersion gitVersion = (GitVersion)result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(8);
        }
        return gitVersion;
    }

    @NotNull
    public GitVersion getVersionOrCancel(@NotNull Project project) throws ProcessCanceledException {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            GitVersion gitVersion = (GitVersion)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (project == null) {
                    GitExecutableManager.$$$reportNull$$$0(16);
                }
                return this.getVersionOrCancel(project);
            }, GitBundle.getString("git.executable.version.progress.title"), true, project);
            if (gitVersion == null) {
                GitExecutableManager.$$$reportNull$$$0(10);
            }
            return gitVersion;
        }
        String pathToGit = this.getPathToGit(project);
        GitVersion version = this.identifyVersionOrDisplayError(project, pathToGit);
        if (version == null) {
            throw new ProcessCanceledException();
        }
        GitVersion gitVersion = version;
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(11);
        }
        return gitVersion;
    }

    @NotNull
    public GitVersion identifyVersion(@NotNull String pathToGit) throws GitVersionIdentificationException {
        CachingFileTester.TestResult result2;
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(12);
        }
        if ((result2 = this.myVersionCache.getResultForFile(pathToGit)).getResult() == null) {
            throw new GitVersionIdentificationException("Cannot identify version of git executable " + pathToGit, result2.getException());
        }
        GitVersion gitVersion = (GitVersion)result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(13);
        }
        return gitVersion;
    }

    public boolean testGitExecutableVersionValid(@NotNull Project project) {
        String pathToGit;
        GitVersion version;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(14);
        }
        if ((version = this.identifyVersionOrDisplayError(project, pathToGit = this.getPathToGit(project))) == null) {
            return false;
        }
        GitExecutableProblemsNotifier executableProblemsNotifier = GitExecutableProblemsNotifier.getInstance(project);
        if (version.isSupported()) {
            executableProblemsNotifier.expireNotifications();
            return true;
        }
        executableProblemsNotifier.notifyUnsupportedVersion(version);
        return false;
    }

    @Nullable
    private GitVersion identifyVersionOrDisplayError(@Nullable Project project, @NotNull String pathToGit) {
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(15);
        }
        try {
            return this.identifyVersion(pathToGit);
        }
        catch (GitVersionIdentificationException e) {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (project != null && progressIndicator != null && !progressIndicator.getModalityState().dominates(ModalityState.NON_MODAL)) {
                GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            } else {
                GitExecutableProblemsNotifier.showExecutionErrorDialog(e, project);
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationSettings";
                break;
            }
            case 1: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToGit";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToGit";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectedExecutable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionOrCancel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doGetGitVersion";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPathToGit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVersionOrCancel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "testGitExecutableVersionValid";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersionOrDisplayError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getVersionOrCancel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

