/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableConsumer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataInputOutputUtilRt {
    public static int readINT(@NotNull DataInput record) throws IOException {
        int val;
        if (record == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(0);
        }
        if ((val = record.readUnsignedByte()) < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static int readINT(@NotNull ByteBuffer byteBuffer) {
        int val;
        if (byteBuffer == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(1);
        }
        if ((val = byteBuffer.get() & 0xFF) < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = byteBuffer.get() & 0xFF;
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeINT(@NotNull DataOutput record, int val) throws IOException {
        if (record == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(2);
        }
        if (0 > val || val >= 192) {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
        }
        record.writeByte(val);
    }

    public static void writeINT(@NotNull ByteBuffer byteBuffer, int val) {
        if (byteBuffer == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(3);
        }
        if (0 > val || val >= 192) {
            byteBuffer.put((byte)(192 + (val & 0x3F)));
            val >>>= 6;
            while (val >= 128) {
                byteBuffer.put((byte)(val & 0x7F | 0x80));
                val >>>= 7;
            }
        }
        byteBuffer.put((byte)val);
    }

    public static <T> void writeSeq(@NotNull DataOutput out, @NotNull Collection<? extends T> collection, @NotNull ThrowableConsumer<T, IOException> writeElement) throws IOException {
        if (out == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(4);
        }
        if (collection == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(5);
        }
        if (writeElement == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(6);
        }
        DataInputOutputUtilRt.writeINT(out, collection.size());
        for (T t : collection) {
            writeElement.consume(t);
        }
    }

    @NotNull
    public static <T> List<T> readSeq(@NotNull DataInput in, @NotNull ThrowableComputable<? extends T, IOException> readElement) throws IOException {
        if (in == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(7);
        }
        if (readElement == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(8);
        }
        int size = DataInputOutputUtilRt.readINT(in);
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            result.add(readElement.compute());
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            DataInputOutputUtilRt.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteBuffer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/DataInputOutputUtilRt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/DataInputOutputUtilRt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readSeq";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readINT";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeINT";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeSeq";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readSeq";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

