/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Range;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.IndexTreePathState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class TreeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.ui.tree.TreeUtil");
    private static final String TREE_UTIL_SCROLL_TIME_STAMP = "TreeUtil.scrollTimeStamp";
    private static final JBIterable<Integer> NUMBERS = JBIterable.generate((Object)0, i -> i + 1);

    private TreeUtil() {
    }

    @NotNull
    public static JBTreeTraverser<Object> treeTraverser(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(0);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(node -> TreeUtil.nodeChildren(node, model)).withRoot(root);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(1);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBTreeTraverser<TreePath> treePathTraverser(@NotNull JTree tree) {
        TreeModel model;
        Object root;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(2);
        }
        TreePath rootPath = (root = (model = tree.getModel()).getRoot()) == null ? null : new TreePath(root);
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(path2 -> TreeUtil.nodeChildren(path2.getLastPathComponent(), model).map(o -> path2.pathByAddingChild(o))).withRoot((Object)rootPath);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(3);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBIterable<Object> nodeChildren(@Nullable Object node, @NotNull TreeModel model) {
        int count;
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(4);
        }
        JBIterable jBIterable = (count = model.getChildCount(node)) == 0 ? JBIterable.empty() : NUMBERS.take(count).map(index2 -> {
            if (model == null) {
                TreeUtil.$$$reportNull$$$0(317);
            }
            return model.getChild(node, (int)index2);
        });
        if (jBIterable == null) {
            TreeUtil.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public static JBTreeTraverser<TreeNode> treeNodeTraverser(@Nullable TreeNode treeNode) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(node -> TreeUtil.nodeChildren(node)).withRoot((Object)treeNode);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(6);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBIterable<TreeNode> nodeChildren(@Nullable TreeNode treeNode) {
        int count = treeNode == null ? 0 : treeNode.getChildCount();
        JBIterable jBIterable = count == 0 ? JBIterable.empty() : NUMBERS.take(count).map(index2 -> treeNode.getChildAt((int)index2));
        if (jBIterable == null) {
            TreeUtil.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(8);
        }
        List<TreePath> list = TreeUtil.collectExpandedObjects(tree, Function.identity());
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static List<Object> collectExpandedUserObjects(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(10);
        }
        List<Object> list = TreeUtil.collectExpandedObjects(tree, TreeUtil::getLastUserObject);
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> collectExpandedObjects(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(12);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(13);
        }
        List<? extends T> list = TreeUtil.collectVisibleRows(tree, tree::isExpanded, mapper);
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public static <T> T findObjectInPath(@Nullable TreePath path2, @NotNull Class<T> clazz) {
        if (clazz == null) {
            TreeUtil.$$$reportNull$$$0(15);
        }
        while (path2 != null) {
            T object = TreeUtil.getLastUserObject(clazz, path2);
            if (object != null) {
                return object;
            }
            path2 = path2.getParentPath();
        }
        return null;
    }

    @NotNull
    public static <T> List<T> collectSelectedObjectsOfType(@NotNull JTree tree, @NotNull Class<? extends T> type) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(16);
        }
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(17);
        }
        List<Object> list = TreeUtil.collectSelectedObjects(tree, path2 -> {
            if (type == null) {
                TreeUtil.$$$reportNull$$$0(316);
            }
            return TreeUtil.getLastUserObject(type, path2);
        });
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(19);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(20);
        }
        List<TreePath> list = TreeUtil.collectExpandedObjects(tree, root, Function.identity());
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public static List<Object> collectExpandedUserObjects(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(22);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(23);
        }
        List<Object> list = TreeUtil.collectExpandedObjects(tree, root, TreeUtil::getLastUserObject);
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> collectExpandedObjects(@NotNull JTree tree, @NotNull TreePath root, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(25);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(26);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(27);
        }
        if (!tree.isVisible(root)) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(28);
            }
            return list;
        }
        List<? extends T> list = TreeUtil.collectVisibleRows(tree, path2 -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(314);
            }
            if (root == null) {
                TreeUtil.$$$reportNull$$$0(315);
            }
            return tree.isExpanded((TreePath)path2) && root.isDescendant((TreePath)path2);
        }, mapper);
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    public static void restoreExpandedPaths(@NotNull JTree tree, @NotNull List<? extends TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(30);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(31);
        }
        for (int i = paths.size() - 1; i >= 0; --i) {
            tree.expandPath(paths.get(i));
        }
    }

    @NotNull
    public static TreePath getPath(@NotNull TreeNode aRootNode, @NotNull TreeNode aNode) {
        if (aRootNode == null) {
            TreeUtil.$$$reportNull$$$0(32);
        }
        if (aNode == null) {
            TreeUtil.$$$reportNull$$$0(33);
        }
        Object[] nodes = TreeUtil.getPathFromRootTo(aRootNode, aNode, true);
        TreePath treePath = new TreePath(nodes);
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(34);
        }
        return treePath;
    }

    public static boolean isAncestor(@NotNull TreeNode ancestor, @NotNull TreeNode node) {
        if (ancestor == null) {
            TreeUtil.$$$reportNull$$$0(35);
        }
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(36);
        }
        for (TreeNode parent = node; parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    private static boolean isAncestor(@NotNull TreePath ancestor, @NotNull TreePath path2) {
        if (ancestor == null) {
            TreeUtil.$$$reportNull$$$0(37);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(38);
        }
        if (path2.getPathCount() < ancestor.getPathCount()) {
            return false;
        }
        for (int i = 0; i < ancestor.getPathCount(); ++i) {
            if (path2.getPathComponent(i).equals(ancestor.getPathComponent(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDescendants(@NotNull TreePath path2, @NotNull TreePath[] paths) {
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(39);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(40);
        }
        for (TreePath ancestor : paths) {
            if (!TreeUtil.isAncestor(ancestor, path2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TreePath getPathFromRoot(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(41);
        }
        Object[] path2 = TreeUtil.getPathFromRootTo(null, node, false);
        TreePath treePath = new TreePath(path2);
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(42);
        }
        return treePath;
    }

    @NotNull
    private static TreeNode[] getPathFromRootTo(@Nullable TreeNode root, @NotNull TreeNode node, boolean includeRoot) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(43);
        }
        int height = 0;
        for (TreeNode n = node; n != root; n = n.getParent()) {
            ++height;
        }
        TreeNode[] path2 = new TreeNode[includeRoot ? height + 1 : height];
        int i = path2.length - 1;
        TreeNode n = node;
        while (i >= 0) {
            path2[i--] = n;
            n = n.getParent();
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(44);
        }
        return path2;
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, @NotNull TreeModel model, Object parent) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(45);
        }
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (!childNode.getUserObject().equals(object)) continue;
            return childNode;
        }
        return null;
    }

    public static void removeSelected(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(46);
        }
        if ((paths = tree.getSelectionPaths()) == null) {
            return;
        }
        for (TreePath path2 : paths) {
            TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), path2).restoreSelection(tree);
        }
    }

    public static void removeLastPathComponent(@NotNull JTree tree, @NotNull TreePath pathToBeRemoved) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(47);
        }
        if (pathToBeRemoved == null) {
            TreeUtil.$$$reportNull$$$0(48);
        }
        TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), pathToBeRemoved).restoreSelection(tree);
    }

    @Nullable
    public static DefaultMutableTreeNode findNodeWithObject(@NotNull DefaultMutableTreeNode aRoot, Object aObject) {
        if (aRoot == null) {
            TreeUtil.$$$reportNull$$$0(49);
        }
        return TreeUtil.findNode(aRoot, (Condition<? super DefaultMutableTreeNode>)((Condition)node -> Comparing.equal((Object)node.getUserObject(), (Object)aObject)));
    }

    @Nullable
    public static DefaultMutableTreeNode findNode(@NotNull DefaultMutableTreeNode aRoot, @NotNull Condition<? super DefaultMutableTreeNode> condition) {
        if (aRoot == null) {
            TreeUtil.$$$reportNull$$$0(50);
        }
        if (condition == null) {
            TreeUtil.$$$reportNull$$$0(51);
        }
        if (condition.value((Object)aRoot)) {
            return aRoot;
        }
        for (int i = 0; i < aRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode candidate = TreeUtil.findNode((DefaultMutableTreeNode)aRoot.getChildAt(i), condition);
            if (null == candidate) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static TreePath findCommonPath(@NotNull TreePath[] treePaths) {
        if (treePaths == null) {
            TreeUtil.$$$reportNull$$$0(52);
        }
        LOG.assertTrue(TreeUtil.areComponentsEqual(treePaths, 0));
        TreePath result2 = new TreePath(treePaths[0].getPathComponent(0));
        int pathIndex = 1;
        while (TreeUtil.areComponentsEqual(treePaths, pathIndex)) {
            result2 = result2.pathByAddingChild(treePaths[0].getPathComponent(pathIndex));
            ++pathIndex;
        }
        TreePath treePath = result2;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(53);
        }
        return treePath;
    }

    @NotNull
    public static ActionCallback selectFirstNode(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(54);
        }
        TreePath selectionPath = TreeUtil.getFirstNodePath(tree);
        ActionCallback actionCallback = TreeUtil.selectPath(tree, selectionPath);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(55);
        }
        return actionCallback;
    }

    @NotNull
    public static TreePath getFirstNodePath(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(56);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        if (!tree.isRootVisible() && model.getChildCount(root) > 0) {
            selectionPath = selectionPath.pathByAddingChild(model.getChild(root, 0));
        }
        TreePath treePath = selectionPath;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(57);
        }
        return treePath;
    }

    @NotNull
    public static TreePath getFirstLeafNodePath(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(58);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        while (model.getChildCount(root) > 0) {
            Object child = model.getChild(root, 0);
            selectionPath = selectionPath.pathByAddingChild(child);
            root = child;
        }
        TreePath treePath = selectionPath;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(59);
        }
        return treePath;
    }

    @NotNull
    private static IndexTreePathState removeLastPathComponent(@NotNull DefaultTreeModel model, @NotNull TreePath pathToBeRemoved) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(60);
        }
        if (pathToBeRemoved == null) {
            TreeUtil.$$$reportNull$$$0(61);
        }
        IndexTreePathState selectionState = new IndexTreePathState(pathToBeRemoved);
        if (((MutableTreeNode)pathToBeRemoved.getLastPathComponent()).getParent() == null) {
            IndexTreePathState indexTreePathState = selectionState;
            if (indexTreePathState == null) {
                TreeUtil.$$$reportNull$$$0(62);
            }
            return indexTreePathState;
        }
        model.removeNodeFromParent((MutableTreeNode)pathToBeRemoved.getLastPathComponent());
        IndexTreePathState indexTreePathState = selectionState;
        if (indexTreePathState == null) {
            TreeUtil.$$$reportNull$$$0(63);
        }
        return indexTreePathState;
    }

    private static boolean areComponentsEqual(@NotNull TreePath[] paths, int componentIndex) {
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(64);
        }
        if (paths[0].getPathCount() <= componentIndex) {
            return false;
        }
        Object pathComponent = paths[0].getPathComponent(componentIndex);
        for (TreePath treePath : paths) {
            if (treePath.getPathCount() <= componentIndex) {
                return false;
            }
            if (pathComponent.equals(treePath.getPathComponent(componentIndex))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static TreePath[] removeDuplicates(@NotNull TreePath[] paths) {
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(65);
        }
        ArrayList<TreePath> result2 = new ArrayList<TreePath>();
        for (TreePath path2 : paths) {
            if (result2.contains(path2)) continue;
            result2.add(path2);
        }
        TreePath[] treePathArray = result2.toArray(new TreePath[0]);
        if (treePathArray == null) {
            TreeUtil.$$$reportNull$$$0(66);
        }
        return treePathArray;
    }

    @NotNull
    public static TreePath[] selectMaximals(@Nullable TreePath[] paths) {
        if (paths == null) {
            TreePath[] treePathArray = new TreePath[]{};
            if (treePathArray == null) {
                TreeUtil.$$$reportNull$$$0(67);
            }
            return treePathArray;
        }
        TreePath[] noDuplicates = TreeUtil.removeDuplicates(paths);
        ArrayList<TreePath> result2 = new ArrayList<TreePath>();
        for (TreePath path2 : noDuplicates) {
            ArrayList<TreePath> otherPaths = new ArrayList<TreePath>(Arrays.asList(noDuplicates));
            otherPaths.remove(path2);
            if (TreeUtil.isDescendants(path2, otherPaths.toArray(new TreePath[0]))) continue;
            result2.add(path2);
        }
        TreePath[] treePathArray = result2.toArray(new TreePath[0]);
        if (treePathArray == null) {
            TreeUtil.$$$reportNull$$$0(68);
        }
        return treePathArray;
    }

    public static void sort(@NotNull DefaultTreeModel model, @Nullable Comparator comparator) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(69);
        }
        TreeUtil.sort((DefaultMutableTreeNode)model.getRoot(), comparator);
    }

    public static void sort(@NotNull DefaultMutableTreeNode node, @Nullable Comparator comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(70);
        }
        TreeUtil.sortRecursively(node, comparator);
    }

    public static <T extends MutableTreeNode> void sortRecursively(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(71);
        }
        TreeUtil.sortChildren(node, comparator);
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeUtil.sortRecursively((MutableTreeNode)node.getChildAt(i), comparator);
        }
    }

    public static <T extends MutableTreeNode> void sortChildren(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(72);
        }
        List<TreeNode> children = TreeUtil.listChildren(node);
        Collections.sort(children, comparator);
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            node.remove(i);
        }
        TreeUtil.addChildrenTo(node, children);
    }

    public static void addChildrenTo(@NotNull MutableTreeNode node, @NotNull List<? extends TreeNode> children) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(73);
        }
        if (children == null) {
            TreeUtil.$$$reportNull$$$0(74);
        }
        for (TreeNode treeNode : children) {
            MutableTreeNode child = (MutableTreeNode)treeNode;
            node.insert(child, node.getChildCount());
        }
    }

    @Deprecated
    public static boolean traverse(@NotNull TreeNode node, @NotNull Traverse traverse) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(75);
        }
        if (traverse == null) {
            TreeUtil.$$$reportNull$$$0(76);
        }
        return TreeUtil.treeNodeTraverser(node).traverse(TreeTraversal.POST_ORDER_DFS).processEach(traverse::accept);
    }

    @Deprecated
    public static boolean traverseDepth(@NotNull TreeNode node, @NotNull Traverse traverse) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(77);
        }
        if (traverse == null) {
            TreeUtil.$$$reportNull$$$0(78);
        }
        return TreeUtil.treeNodeTraverser(node).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(traverse::accept);
    }

    public static void selectPaths(@NotNull JTree tree, @NotNull Collection<? extends TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(79);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(80);
        }
        if (paths.isEmpty()) {
            return;
        }
        TreeUtil.selectPaths(tree, paths.toArray(new TreePath[0]));
    }

    public static void selectPaths(@NotNull JTree tree, TreePath ... paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(81);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(82);
        }
        if (paths.length == 0) {
            return;
        }
        for (TreePath path2 : paths) {
            tree.makeVisible(path2);
        }
        tree.setSelectionPaths(paths);
        tree.scrollPathToVisible(paths[0]);
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(83);
        }
        ActionCallback actionCallback = TreeUtil.selectPath(tree, path2, true);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(84);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(85);
        }
        tree.makeVisible(path2);
        if (center) {
            ActionCallback actionCallback = TreeUtil.showRowCentred(tree, tree.getRowForPath(path2));
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(86);
            }
            return actionCallback;
        }
        int row = tree.getRowForPath(path2);
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, row - 2, row + 2, row, -1);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(87);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback moveDown(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(88);
        }
        int size = tree.getRowCount();
        int row = tree.getLeadSelectionRow();
        if (row < size - 1) {
            ActionCallback actionCallback = TreeUtil.showAndSelect(tree, ++row, row + 2, row, TreeUtil.getSelectedRow(tree), false, true, true);
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(89);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(90);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback moveUp(@NotNull JTree tree) {
        int row;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(91);
        }
        if ((row = tree.getLeadSelectionRow()) > 0) {
            ActionCallback actionCallback = TreeUtil.showAndSelect(tree, --row - 2, row, row, TreeUtil.getSelectedRow(tree), false, true, true);
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(92);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(93);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback movePageUp(@NotNull JTree tree) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(94);
        }
        if ((visible = TreeUtil.getVisibleRowCount(tree)) <= 0) {
            ActionCallback actionCallback = TreeUtil.moveHome(tree);
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(95);
            }
            return actionCallback;
        }
        int decrement = visible - 1;
        int row = Math.max(TreeUtil.getSelectedRow(tree) - decrement, 0);
        int top = TreeUtil.getFirstVisibleRow(tree) - decrement;
        int bottom = top + visible - 1;
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, TreeUtil.getSelectedRow(tree));
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(96);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback movePageDown(@NotNull JTree tree) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(97);
        }
        if ((visible = TreeUtil.getVisibleRowCount(tree)) <= 0) {
            ActionCallback actionCallback = TreeUtil.moveEnd(tree);
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(98);
            }
            return actionCallback;
        }
        int size = tree.getRowCount();
        int increment = visible - 1;
        int index2 = Math.min(TreeUtil.getSelectedRow(tree) + increment, size - 1);
        int top = TreeUtil.getFirstVisibleRow(tree) + increment;
        int bottom = top + visible - 1;
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, index2, TreeUtil.getSelectedRow(tree));
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(99);
        }
        return actionCallback;
    }

    @NotNull
    private static ActionCallback moveHome(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(100);
        }
        ActionCallback actionCallback = TreeUtil.showRowCentred(tree, 0);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(101);
        }
        return actionCallback;
    }

    @NotNull
    private static ActionCallback moveEnd(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(102);
        }
        ActionCallback actionCallback = TreeUtil.showRowCentred(tree, tree.getRowCount() - 1);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(103);
        }
        return actionCallback;
    }

    @NotNull
    private static ActionCallback showRowCentred(@NotNull JTree tree, int row) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(104);
        }
        ActionCallback actionCallback = TreeUtil.showRowCentered(tree, row, true);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(105);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(106);
        }
        ActionCallback actionCallback = TreeUtil.showRowCentered(tree, row, centerHorizontally, true);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(107);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally, boolean scroll) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(108);
        }
        int top = (visible = TreeUtil.getVisibleRowCount(tree)) > 0 ? row - (visible - 1) / 2 : row;
        int bottom = visible > 0 ? top + visible - 1 : row;
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, -1, false, scroll, false);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(109);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(110);
        }
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, previous, false);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(111);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(112);
        }
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, true, false);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(113);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(114);
        }
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, scroll, false);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(115);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll, boolean resetSelection) {
        Rectangle bottomBounds;
        TreePath path2;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(116);
        }
        if ((path2 = tree.getPathForRow(row)) == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(117);
            }
            return actionCallback;
        }
        int size = tree.getRowCount();
        if (size == 0) {
            tree.clearSelection();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(118);
            }
            return actionCallback;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if (row >= tree.getRowCount()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(119);
            }
            return actionCallback;
        }
        boolean okToScroll = true;
        if (tree.isShowing()) {
            if (!tree.isValid()) {
                tree.validate();
            }
        } else {
            Application app = ApplicationManager.getApplication();
            if (app != null && app.isUnitTestMode()) {
                okToScroll = false;
            }
        }
        Runnable selectRunnable = () -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(313);
            }
            if (!tree.isRowSelected(row)) {
                if (addToSelection) {
                    tree.getSelectionModel().addSelectionPath(tree.getPathForRow(row));
                } else {
                    tree.setSelectionRow(row);
                }
            } else if (resetSelection && !addToSelection) {
                tree.setSelectionRow(row);
            }
        };
        if (!okToScroll || !scroll) {
            selectRunnable.run();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(120);
            }
            return actionCallback;
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        if (rowBounds == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(121);
            }
            return actionCallback;
        }
        Rectangle topBounds = tree.getRowBounds(top);
        if (topBounds == null) {
            topBounds = rowBounds;
        }
        if ((bottomBounds = tree.getRowBounds(bottom)) == null) {
            bottomBounds = rowBounds;
        }
        Rectangle bounds = topBounds.union(bottomBounds);
        bounds.x = rowBounds.x;
        bounds.width = rowBounds.width;
        Rectangle visible = tree.getVisibleRect();
        if (visible.contains(bounds)) {
            selectRunnable.run();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(122);
            }
            return actionCallback;
        }
        Component comp = tree.getCellRenderer().getTreeCellRendererComponent(tree, path2.getLastPathComponent(), true, true, false, row, false);
        if (comp instanceof SimpleColoredComponent) {
            SimpleColoredComponent renderer = (SimpleColoredComponent)comp;
            Dimension scrollableSize = renderer.computePreferredSize(true);
            bounds.width = scrollableSize.width;
        }
        ActionCallback callback = new ActionCallback();
        selectRunnable.run();
        Range<Integer> range = TreeUtil.getExpandControlRange(tree, path2);
        if (range != null) {
            int delta = bounds.x - (Integer)range.getFrom();
            bounds.x -= delta;
            bounds.width -= delta;
        }
        if (visible.width < bounds.width) {
            bounds.width = visible.width;
        }
        if (tree instanceof Tree && !((Tree)tree).isHorizontalAutoScrollingEnabled()) {
            bounds.x = tree.getVisibleRect().x;
        }
        LOG.debug("tree scroll: ", new Object[]{path2});
        tree.scrollRectToVisible(bounds);
        Object property2 = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
        long stamp = property2 instanceof Long ? (Long)property2 + 1L : Long.MIN_VALUE;
        tree.putClientProperty(TREE_UTIL_SCROLL_TIME_STAMP, stamp);
        int offset = rowBounds.y - bounds.y;
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        TreeUtil.scrollToVisible(tree, path2, bounds, offset, stamp, callback::setDone, builder, 3);
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(123);
        }
        return actionCallback;
    }

    private static void scrollToVisible(JTree tree, TreePath path2, Rectangle bounds, int offset, long expected, Runnable done2, AbstractTreeBuilder builder, int attempt) {
        Runnable scroll = () -> {
            Rectangle pathBounds;
            Rectangle rectangle = pathBounds = attempt <= 0 ? null : tree.getPathBounds(path2);
            if (pathBounds != null) {
                Object property2 = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
                long stamp = property2 instanceof Long ? (Long)property2 : Long.MAX_VALUE;
                LOG.debug("tree scroll ", new Object[]{attempt, stamp == expected ? ": try again: " : ": ignore: ", path2});
                if (stamp == expected) {
                    bounds.y = pathBounds.y - offset;
                    Rectangle visible = tree.getVisibleRect();
                    if (bounds.y < visible.y || bounds.y > visible.y + Math.max(0, visible.height - bounds.height)) {
                        tree.scrollRectToVisible(bounds);
                        TreeUtil.scrollToVisible(tree, path2, bounds, offset, expected, done2, builder, attempt - 1);
                        return;
                    }
                }
            }
            done2.run();
        };
        SwingUtilities.invokeLater(builder == null ? scroll : () -> builder.getReady(TreeUtil.class).doWhenDone(scroll));
    }

    private static int getSelectedRow(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(124);
        }
        return tree.getRowForPath(tree.getSelectionPath());
    }

    private static int getFirstVisibleRow(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(125);
        }
        Rectangle visible = tree.getVisibleRect();
        int row = -1;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            Rectangle bounds = tree.getRowBounds(i);
            if (visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            row = i;
            break;
        }
        return row;
    }

    public static int getVisibleRowCount(@NotNull JTree tree) {
        Rectangle visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(126);
        }
        if ((visible = tree.getVisibleRect()) == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            Rectangle bounds = tree.getRowBounds(i);
            if (bounds == null || visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            ++count;
        }
        return count;
    }

    public static int getVisibleRowCountForFixedRowHeight(@NotNull JTree tree) {
        Rectangle bounds;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(127);
        }
        int rowHeight = (bounds = tree.getRowBounds(0)) == null ? 0 : bounds.height;
        return rowHeight == 0 ? tree.getVisibleRowCount() : tree.getVisibleRect().height / rowHeight;
    }

    public static void installActions(final @NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(128);
        }
        tree.getActionMap().put("scrollUpChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageUp(tree);
            }
        });
        tree.getActionMap().put("scrollDownChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageDown(tree);
            }
        });
        tree.getActionMap().put("selectPrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveUp(tree);
            }
        });
        tree.getActionMap().put("selectNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveDown(tree);
            }
        });
        TreeUtil.copyAction(tree, "selectLast", "selectLastChangeLead");
        TreeUtil.copyAction(tree, "selectFirst", "selectFirstChangeLead");
        InputMap inputMap = tree.getInputMap(0);
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollUpChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(33, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollDownChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(34, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectNext", (KeyStroke)KeyStroke.getKeyStroke(40, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectPrevious", (KeyStroke)KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectLast", (KeyStroke)KeyStroke.getKeyStroke(35, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectFirst", (KeyStroke)KeyStroke.getKeyStroke(36, 0));
    }

    private static void copyAction(@NotNull JTree tree, String original, String copyTo) {
        Action action;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(129);
        }
        if ((action = tree.getActionMap().get(original)) != null) {
            tree.getActionMap().put(copyTo, action);
        }
    }

    public static void collapseAll(@NotNull JTree tree, int keepSelectionLevel) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(130);
        }
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        for (int row = tree.getRowCount() - 1; row >= 0; --row) {
            tree.collapseRow(row);
        }
        Object root = tree.getModel().getRoot();
        if (root != null && !tree.isRootVisible()) {
            tree.expandPath(new TreePath(root));
        }
        if (leadSelectionPath != null) {
            Object[] path2 = leadSelectionPath.getPath();
            Object[] pathToSelect = new Object[path2.length > keepSelectionLevel && keepSelectionLevel >= 0 ? keepSelectionLevel : path2.length];
            System.arraycopy(path2, 0, pathToSelect, 0, pathToSelect.length);
            if (pathToSelect.length == 0) {
                return;
            }
            TreeUtil.selectPath(tree, new TreePath(pathToSelect));
        }
    }

    public static void selectNode(@NotNull JTree tree, TreeNode node) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(131);
        }
        TreeUtil.selectPath(tree, TreeUtil.getPathFromRoot(node));
    }

    public static void moveSelectedRow(@NotNull JTree tree, int direction) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(132);
        }
        TreePath selectionPath = tree.getSelectionPath();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
        int idx = parent.getIndex(treeNode);
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(treeNode);
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(treeNode, parent, idx + direction);
        TreeUtil.selectNode(tree, treeNode);
    }

    @NotNull
    public static List<TreeNode> listChildren(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(133);
        }
        int size = node.getChildCount();
        ArrayList<TreeNode> result2 = new ArrayList<TreeNode>(size);
        for (int i = 0; i < size; ++i) {
            TreeNode child = node.getChildAt(i);
            LOG.assertTrue(child != null);
            result2.add(child);
        }
        ArrayList<TreeNode> arrayList = result2;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(134);
        }
        return arrayList;
    }

    public static void expandRootChildIfOnlyOne(@Nullable JTree tree) {
        if (tree == null) {
            return;
        }
        Runnable runnable = () -> {
            TreeModel model = tree.getModel();
            Object root = model.getRoot();
            if (root == null) {
                return;
            }
            TreePath rootPath = new TreePath(root);
            tree.expandPath(rootPath);
            if (model.getChildCount(root) == 1) {
                Object firstChild = model.getChild(root, 0);
                tree.expandPath(rootPath.pathByAddingChild(firstChild));
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void expandAll(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(135);
        }
        TreeUtil.promiseExpandAll(tree);
    }

    public static void expandAll(@NotNull JTree tree, @NotNull Runnable onDone) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(136);
        }
        if (onDone == null) {
            TreeUtil.$$$reportNull$$$0(137);
        }
        TreeUtil.promiseExpandAll(tree).onSuccess(result2 -> {
            if (onDone == null) {
                TreeUtil.$$$reportNull$$$0(312);
            }
            UIUtil.invokeLaterIfNeeded((Runnable)onDone);
        });
    }

    @NotNull
    public static Promise<?> promiseExpandAll(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(138);
        }
        Promise<?> promise = TreeUtil.promiseExpand(tree, Integer.MAX_VALUE);
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(139);
        }
        return promise;
    }

    public static void expand(@NotNull JTree tree, int levels) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(140);
        }
        TreeUtil.promiseExpand(tree, levels);
    }

    public static void expand(@NotNull JTree tree, int depth, @NotNull Runnable onDone) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(141);
        }
        if (onDone == null) {
            TreeUtil.$$$reportNull$$$0(142);
        }
        TreeUtil.promiseExpand(tree, depth).onSuccess(result2 -> {
            if (onDone == null) {
                TreeUtil.$$$reportNull$$$0(311);
            }
            UIUtil.invokeLaterIfNeeded((Runnable)onDone);
        });
    }

    @NotNull
    public static Promise<?> promiseExpand(@NotNull JTree tree, int depth) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(143);
        }
        AsyncPromise promise = new AsyncPromise();
        TreeUtil.promiseMakeVisible(tree, path2 -> depth < path2.getPathCount() ? TreeVisitor.Action.SKIP_SIBLINGS : TreeVisitor.Action.CONTINUE, promise).onError(promise::setError).onSuccess(path2 -> {
            if (promise.isCancelled()) {
                return;
            }
            promise.setResult(null);
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(144);
        }
        return asyncPromise;
    }

    @NotNull
    public static ActionCallback selectInTree(DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(145);
        }
        ActionCallback actionCallback = TreeUtil.selectInTree(node, requestFocus, tree, true);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(146);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback selectInTree(@Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(147);
        }
        if (node == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(148);
            }
            return actionCallback;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                if (tree == null) {
                    TreeUtil.$$$reportNull$$$0(310);
                }
                IdeFocusManager.getGlobalInstance().requestFocus(tree, true);
            });
        }
        ActionCallback actionCallback = TreeUtil.selectPath(tree, treePath, center);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(149);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback selectInTree(Project project, @Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(150);
        }
        if (node == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(151);
            }
            return actionCallback;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            ActionCallback result2 = new ActionCallback(2);
            IdeFocusManager.getInstance(project).requestFocus(tree, true).notifyWhenDone(result2);
            TreeUtil.selectPath(tree, treePath, center).notifyWhenDone(result2);
            ActionCallback actionCallback = result2;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(152);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = TreeUtil.selectPath(tree, treePath, center);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(153);
        }
        return actionCallback;
    }

    private static boolean isViewable(@NotNull JTree tree, @NotNull TreePath path2) {
        TreePath parent;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(154);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(155);
        }
        return (parent = path2.getParentPath()) != null ? tree.isExpanded(parent) : tree.isRootVisible();
    }

    @NotNull
    public static List<TreePath> collectSelectedPaths(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(156);
        }
        List<TreePath> list = TreeUtil.collectSelectedObjects(tree, Function.identity());
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(157);
        }
        return list;
    }

    @NotNull
    public static List<Object> collectSelectedUserObjects(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(158);
        }
        List<Object> list = TreeUtil.collectSelectedObjects(tree, TreeUtil::getLastUserObject);
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(159);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> collectSelectedObjects(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(160);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(161);
        }
        List<? extends T> list = TreeUtil.getSelection(tree, path2 -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(309);
            }
            return TreeUtil.isViewable(tree, path2);
        }, mapper);
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(162);
        }
        return list;
    }

    @NotNull
    public static List<TreePath> collectSelectedPaths(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(163);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(164);
        }
        List<TreePath> list = TreeUtil.collectSelectedObjects(tree, root, Function.identity());
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(165);
        }
        return list;
    }

    @NotNull
    public static List<Object> collectSelectedUserObjects(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(166);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(167);
        }
        List<Object> list = TreeUtil.collectSelectedObjects(tree, root, TreeUtil::getLastUserObject);
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(168);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> collectSelectedObjects(@NotNull JTree tree, @NotNull TreePath root, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(169);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(170);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(171);
        }
        if (!tree.isVisible(root)) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(172);
            }
            return list;
        }
        List<? extends T> list = TreeUtil.getSelection(tree, path2 -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(307);
            }
            if (root == null) {
                TreeUtil.$$$reportNull$$$0(308);
            }
            return TreeUtil.isViewable(tree, path2) && root.isDescendant((TreePath)path2);
        }, mapper);
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(173);
        }
        return list;
    }

    @NotNull
    private static <T> List<T> getSelection(@NotNull JTree tree, @NotNull Predicate<? super TreePath> filter, @NotNull Function<? super TreePath, ? extends T> mapper) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(174);
        }
        if (filter == null) {
            TreeUtil.$$$reportNull$$$0(175);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(176);
        }
        if ((paths = tree.getSelectionPaths()) == null || paths.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(177);
            }
            return list;
        }
        List list = Stream.of(paths).filter(filter).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(178);
        }
        return list;
    }

    public static void unselectPath(@NotNull JTree tree, @Nullable TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(179);
        }
        if (path2 == null) {
            return;
        }
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        for (TreePath selectionPath : selectionPaths) {
            if (selectionPath.getPathCount() <= path2.getPathCount() || !path2.isDescendant(selectionPath)) continue;
            tree.removeSelectionPath(selectionPath);
        }
    }

    @Nullable
    public static Range<Integer> getExpandControlRange(@NotNull JTree aTree, @Nullable TreePath path2) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(180);
        }
        TreeModel treeModel = aTree.getModel();
        BasicTreeUI basicTreeUI = (BasicTreeUI)aTree.getUI();
        Icon expandedIcon = basicTreeUI.getExpandedIcon();
        Range box = null;
        if (path2 != null && !treeModel.isLeaf(path2.getLastPathComponent())) {
            Insets i = aTree.getInsets();
            int boxWidth = expandedIcon != null ? expandedIcon.getIconWidth() : 8;
            int boxLeftX = i != null ? i.left : 0;
            boolean leftToRight = aTree.getComponentOrientation().isLeftToRight();
            int depthOffset = TreeUtil.getDepthOffset(aTree);
            int totalChildIndent = basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent();
            if (leftToRight) {
                boxLeftX += (path2.getPathCount() + depthOffset - 2) * totalChildIndent + basicTreeUI.getLeftChildIndent() - boxWidth / 2;
            }
            int boxRightX = boxLeftX + boxWidth;
            box = new Range((Comparable)Integer.valueOf(boxLeftX), (Comparable)Integer.valueOf(boxRightX));
        }
        return box;
    }

    public static int getDepthOffset(@NotNull JTree aTree) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(181);
        }
        if (aTree.isRootVisible()) {
            return aTree.getShowsRootHandles() ? 1 : 0;
        }
        return aTree.getShowsRootHandles() ? 0 : -1;
    }

    @NotNull
    public static RelativePoint getPointForSelection(@NotNull JTree aTree) {
        int[] rows;
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(182);
        }
        if ((rows = aTree.getSelectionRows()) == null || rows.length == 0) {
            RelativePoint relativePoint = RelativePoint.getCenterOf((JComponent)aTree);
            if (relativePoint == null) {
                TreeUtil.$$$reportNull$$$0(183);
            }
            return relativePoint;
        }
        RelativePoint relativePoint = TreeUtil.getPointForRow(aTree, rows[rows.length - 1]);
        if (relativePoint == null) {
            TreeUtil.$$$reportNull$$$0(184);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getPointForRow(@NotNull JTree aTree, int aRow) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(185);
        }
        RelativePoint relativePoint = TreeUtil.getPointForPath(aTree, aTree.getPathForRow(aRow));
        if (relativePoint == null) {
            TreeUtil.$$$reportNull$$$0(186);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getPointForPath(@NotNull JTree aTree, TreePath path2) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(187);
        }
        Rectangle rowBounds = aTree.getPathBounds(path2);
        rowBounds.x += 20;
        RelativePoint relativePoint = TreeUtil.getPointForBounds(aTree, rowBounds);
        if (relativePoint == null) {
            TreeUtil.$$$reportNull$$$0(188);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getPointForBounds(JComponent aComponent, @NotNull Rectangle aBounds) {
        if (aBounds == null) {
            TreeUtil.$$$reportNull$$$0(189);
        }
        RelativePoint relativePoint = new RelativePoint((Component)aComponent, new Point(aBounds.x, (int)aBounds.getMaxY()));
        if (relativePoint == null) {
            TreeUtil.$$$reportNull$$$0(190);
        }
        return relativePoint;
    }

    public static boolean isOverSelection(@NotNull JTree tree, @NotNull Point point) {
        TreePath path2;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(191);
        }
        if (point == null) {
            TreeUtil.$$$reportNull$$$0(192);
        }
        return (path2 = tree.getPathForLocation(point.x, point.y)) != null && tree.getSelectionModel().isPathSelected(path2);
    }

    public static void dropSelectionButUnderPoint(@NotNull JTree tree, @NotNull Point treePoint) {
        TreePath toRetain;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(193);
        }
        if (treePoint == null) {
            TreeUtil.$$$reportNull$$$0(194);
        }
        if ((toRetain = tree.getPathForLocation(treePoint.x, treePoint.y)) == null) {
            return;
        }
        TreePath[] selection = tree.getSelectionModel().getSelectionPaths();
        for (TreePath each : selection = selection == null ? new TreePath[]{} : selection) {
            if (toRetain.equals(each)) continue;
            tree.getSelectionModel().removeSelectionPath(each);
        }
    }

    @Nullable
    public static Object getUserObject(@Nullable Object node) {
        return node instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)node).getUserObject() : node;
    }

    @Nullable
    public static <T> T getUserObject(@NotNull Class<T> type, @Nullable Object node) {
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(195);
        }
        return type.isInstance(node = TreeUtil.getUserObject(node)) ? (T)type.cast(node) : null;
    }

    @Nullable
    public static Object getLastUserObject(@Nullable TreePath path2) {
        return path2 == null ? null : TreeUtil.getUserObject(path2.getLastPathComponent());
    }

    @Nullable
    public static <T> T getLastUserObject(@NotNull Class<T> type, @Nullable TreePath path2) {
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(196);
        }
        return path2 == null ? null : (T)TreeUtil.getUserObject(type, path2.getLastPathComponent());
    }

    @Nullable
    public static TreePath getSelectedPathIfOne(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(197);
        }
        return (paths = tree.getSelectionPaths()) != null && paths.length == 1 ? paths[0] : null;
    }

    public static void ensureSelection(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(198);
        }
        if ((paths = tree.getSelectionPaths()) != null) {
            for (TreePath each : paths) {
                if (tree.getRowForPath(each) < 0 || !tree.isVisible(each)) continue;
                return;
            }
        }
        for (int eachRow = 0; eachRow < tree.getRowCount(); ++eachRow) {
            TreePath eachPath = tree.getPathForRow(eachRow);
            if (eachPath == null || !tree.isVisible(eachPath)) continue;
            tree.setSelectionPath(eachPath);
            break;
        }
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, @NotNull Comparator<? super T> comparator) {
        if (child == null) {
            TreeUtil.$$$reportNull$$$0(199);
        }
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(200);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(201);
        }
        TreeUtil.insertNode(child, parent, model, false, comparator);
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, boolean allowDuplication, @NotNull Comparator<? super T> comparator) {
        int insertionPoint;
        int index2;
        if (child == null) {
            TreeUtil.$$$reportNull$$$0(202);
        }
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(203);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(204);
        }
        if ((index2 = TreeUtil.indexedBinarySearch(parent, child, comparator)) >= 0 && !allowDuplication) {
            LOG.error("Node " + child + " is already added to " + parent);
            return;
        }
        int n = insertionPoint = index2 >= 0 ? index2 : -(index2 + 1);
        if (model != null) {
            model.insertNodeInto(child, parent, insertionPoint);
        } else {
            parent.insert(child, insertionPoint);
        }
    }

    public static <T extends TreeNode> int indexedBinarySearch(@NotNull T parent, @NotNull T key, @NotNull Comparator<? super T> comparator) {
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(205);
        }
        if (key == null) {
            TreeUtil.$$$reportNull$$$0(206);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(207);
        }
        return ObjectUtils.binarySearch((int)0, (int)parent.getChildCount(), mid -> {
            if (comparator == null) {
                TreeUtil.$$$reportNull$$$0(304);
            }
            if (parent == null) {
                TreeUtil.$$$reportNull$$$0(305);
            }
            if (key == null) {
                TreeUtil.$$$reportNull$$$0(306);
            }
            return comparator.compare(parent.getChildAt(mid), key);
        });
    }

    @NotNull
    public static Comparator<TreePath> getDisplayOrderComparator(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(208);
        }
        Comparator<TreePath> comparator = Comparator.comparingInt(tree::getRowForPath);
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(209);
        }
        return comparator;
    }

    private static void expandPathWithDebug(@NotNull JTree tree, @NotNull TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(210);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(211);
        }
        LOG.debug("tree expand path: ", new Object[]{path2});
        tree.expandPath(path2);
    }

    public static void expand(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(212);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(213);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(214);
        }
        TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(302);
            }
            if (consumer == null) {
                TreeUtil.$$$reportNull$$$0(303);
            }
            TreeUtil.expandPathWithDebug(tree, path2);
            consumer.accept((TreePath)path2);
        });
    }

    @NotNull
    public static Promise<TreePath> promiseExpand(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(215);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(216);
        }
        Promise<TreePath> promise = TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(301);
            }
            TreeUtil.expandPathWithDebug(tree, path2);
        });
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(217);
        }
        return promise;
    }

    @NotNull
    public static Promise<List<TreePath>> promiseExpand(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(218);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(219);
        }
        Promise<List<TreePath>> promise = TreeUtil.promiseMakeVisibleAll(tree, visitors, paths -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(299);
            }
            paths.forEach(path2 -> {
                if (tree == null) {
                    TreeUtil.$$$reportNull$$$0(300);
                }
                TreeUtil.expandPathWithDebug(tree, path2);
            });
        });
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(220);
        }
        return promise;
    }

    public static void makeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(221);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(222);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(223);
        }
        TreeUtil.promiseMakeVisibleOne(tree, visitor, consumer);
    }

    @NotNull
    public static Promise<TreePath> promiseMakeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(224);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(225);
        }
        Promise<TreePath> promise = TreeUtil.promiseMakeVisibleOne(tree, visitor, null);
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(226);
        }
        return promise;
    }

    @NotNull
    private static Promise<TreePath> promiseMakeVisibleOne(@NotNull JTree tree, @NotNull TreeVisitor visitor, @Nullable Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(227);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(228);
        }
        AsyncPromise<TreePath> promise = new AsyncPromise<TreePath>();
        TreeUtil.promiseMakeVisible(tree, visitor, promise).onError(promise::setError).onSuccess(path2 -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(297);
            }
            if (promise.isCancelled()) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (tree == null) {
                    TreeUtil.$$$reportNull$$$0(298);
                }
                if (promise.isCancelled()) {
                    return;
                }
                if (tree.isVisible((TreePath)path2)) {
                    if (consumer != null) {
                        consumer.accept((TreePath)path2);
                    }
                    promise.setResult((TreePath)path2);
                } else {
                    promise.cancel();
                }
            });
        });
        AsyncPromise<TreePath> asyncPromise = promise;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(229);
        }
        return asyncPromise;
    }

    @NotNull
    public static Promise<List<TreePath>> promiseMakeVisible(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(230);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(231);
        }
        Promise<List<TreePath>> promise = TreeUtil.promiseMakeVisibleAll(tree, visitors, null);
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(232);
        }
        return promise;
    }

    private static Promise<List<TreePath>> promiseMakeVisibleAll(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors, @Nullable Consumer<? super List<TreePath>> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(233);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(234);
        }
        AsyncPromise<List<TreePath>> promise = new AsyncPromise<List<TreePath>>();
        List promises = visitors.filter(Objects::nonNull).map(visitor -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(296);
            }
            return TreeUtil.promiseMakeVisible(tree, visitor, promise);
        }).collect(Collectors.toList());
        Promises.collectResults(promises, true).onError(promise::setError).onSuccess(paths -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(294);
            }
            if (promise.isCancelled()) {
                return;
            }
            if (!ContainerUtil.isEmpty((Collection)paths)) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (tree == null) {
                        TreeUtil.$$$reportNull$$$0(295);
                    }
                    if (promise.isCancelled()) {
                        return;
                    }
                    List visible = ContainerUtil.filter((Collection)paths, tree::isVisible);
                    if (!ContainerUtil.isEmpty((Collection)visible)) {
                        if (consumer != null) {
                            consumer.accept(visible);
                        }
                        promise.setResult(visible);
                    } else {
                        promise.cancel();
                    }
                });
            } else {
                promise.cancel();
            }
        });
        return promise;
    }

    @NotNull
    private static Promise<TreePath> promiseMakeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull AsyncPromise<?> promise) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(235);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(236);
        }
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(237);
        }
        Promise<TreePath> promise2 = TreeUtil.promiseVisit(tree, path2 -> {
            if (promise == null) {
                TreeUtil.$$$reportNull$$$0(291);
            }
            if (visitor == null) {
                TreeUtil.$$$reportNull$$$0(292);
            }
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(293);
            }
            if (promise.isCancelled()) {
                return TreeVisitor.Action.SKIP_SIBLINGS;
            }
            TreeVisitor.Action action = visitor.visit(path2);
            if (action == TreeVisitor.Action.CONTINUE || action == TreeVisitor.Action.INTERRUPT) {
                if (!tree.isVisible(path2)) {
                    if (!promise.isCancelled()) {
                        LOG.debug("tree expand canceled");
                        promise.cancel();
                    }
                    return TreeVisitor.Action.SKIP_SIBLINGS;
                }
                if (action == TreeVisitor.Action.CONTINUE) {
                    TreeUtil.expandPathWithDebug(tree, path2);
                }
            }
            return action;
        });
        if (promise2 == null) {
            TreeUtil.$$$reportNull$$$0(238);
        }
        return promise2;
    }

    public static void select(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(239);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(240);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(241);
        }
        TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(289);
            }
            if (consumer == null) {
                TreeUtil.$$$reportNull$$$0(290);
            }
            TreeUtil.internalSelectPath(tree, path2);
            consumer.accept((TreePath)path2);
        });
    }

    @NotNull
    public static Promise<TreePath> promiseSelect(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(242);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(243);
        }
        Promise<TreePath> promise = TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(288);
            }
            TreeUtil.internalSelectPath(tree, path2);
        });
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(244);
        }
        return promise;
    }

    private static void internalSelectPath(@NotNull JTree tree, @NotNull TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(245);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(246);
        }
        assert (EventQueue.isDispatchThread());
        tree.setSelectionPath(path2);
        TreeUtil.internalScroll(tree, path2);
    }

    @NotNull
    public static Promise<List<TreePath>> promiseSelect(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(247);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(248);
        }
        Promise<List<TreePath>> promise = TreeUtil.promiseMakeVisibleAll(tree, visitors, paths -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(287);
            }
            TreeUtil.internalSelectPaths(tree, paths);
        });
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(249);
        }
        return promise;
    }

    private static void internalSelectPaths(@NotNull JTree tree, @NotNull List<? extends TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(250);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(251);
        }
        assert (EventQueue.isDispatchThread());
        if (paths.isEmpty()) {
            return;
        }
        tree.setSelectionPaths(paths.toArray(new TreePath[0]));
        for (TreePath treePath : paths) {
            if (TreeUtil.internalScroll(tree, treePath)) break;
        }
    }

    private static boolean internalScroll(@NotNull JTree tree, @NotNull TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(252);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(253);
        }
        assert (EventQueue.isDispatchThread());
        int row = tree.getRowForPath(path2);
        if (row == -1) {
            LOG.debug("cannot scroll to: ", new Object[]{path2});
            return false;
        }
        TreeUtil.showRowCentred(tree, row);
        return true;
    }

    @NotNull
    public static Promise<TreePath> promiseSelectFirst(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(254);
        }
        Promise<TreePath> promise = TreeUtil.promiseSelect(tree, (TreePath path2) -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(286);
            }
            return !tree.isRootVisible() && path2.getParentPath() == null ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.INTERRUPT;
        });
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(255);
        }
        return promise;
    }

    public static void visit(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(256);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(257);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(258);
        }
        TreeUtil.promiseVisit(tree, visitor).onSuccess(path2 -> {
            if (consumer == null) {
                TreeUtil.$$$reportNull$$$0(284);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (consumer == null) {
                    TreeUtil.$$$reportNull$$$0(285);
                }
                consumer.accept((TreePath)path2);
            });
        });
    }

    @NotNull
    public static Promise<TreePath> promiseVisit(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        TreeModel model;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(259);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(260);
        }
        if ((model = tree.getModel()) instanceof TreeVisitor.Acceptor) {
            TreeVisitor.Acceptor acceptor = (TreeVisitor.Acceptor)((Object)model);
            Promise<TreePath> promise = acceptor.accept(visitor);
            if (promise == null) {
                TreeUtil.$$$reportNull$$$0(261);
            }
            return promise;
        }
        if (model == null) {
            Promise<TreePath> promise = Promises.rejectedPromise("tree model is not set");
            if (promise == null) {
                TreeUtil.$$$reportNull$$$0(262);
            }
            return promise;
        }
        AsyncPromise<TreePath> promise = new AsyncPromise<TreePath>();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (visitor == null) {
                TreeUtil.$$$reportNull$$$0(283);
            }
            promise.setResult(TreeUtil.visitModel(model, visitor));
        });
        AsyncPromise<TreePath> asyncPromise = promise;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(263);
        }
        return asyncPromise;
    }

    private static TreePath visitModel(@NotNull TreeModel model, @NotNull TreeVisitor visitor) {
        Object root;
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(264);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(265);
        }
        if ((root = model.getRoot()) == null) {
            return null;
        }
        TreePath path2 = new TreePath(root);
        switch (visitor.visit(path2)) {
            case INTERRUPT: {
                return path2;
            }
            case CONTINUE: {
                break;
            }
            default: {
                return null;
            }
        }
        ArrayDeque<Deque<TreePath>> stack = new ArrayDeque<Deque<TreePath>>();
        stack.push(TreeUtil.children(model, path2));
        while (path2 != null) {
            Deque siblings = (Deque)stack.peek();
            if (siblings == null) {
                return null;
            }
            TreePath next = (TreePath)siblings.poll();
            if (next == null) {
                LOG.assertTrue(siblings == stack.poll());
                path2 = path2.getParentPath();
                continue;
            }
            switch (visitor.visit(next)) {
                case INTERRUPT: {
                    return next;
                }
                case CONTINUE: {
                    path2 = next;
                    stack.push(TreeUtil.children(model, path2));
                    break;
                }
                case SKIP_SIBLINGS: {
                    siblings.clear();
                    break;
                }
            }
        }
        LOG.assertTrue(stack.isEmpty());
        return null;
    }

    @NotNull
    private static Deque<TreePath> children(@NotNull TreeModel model, @NotNull TreePath path2) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(266);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(267);
        }
        Object object = path2.getLastPathComponent();
        int count = model.getChildCount(object);
        ArrayDeque<TreePath> deque = new ArrayDeque<TreePath>(count);
        for (int i = 0; i < count; ++i) {
            deque.add(path2.pathByAddingChild(model.getChild(object, i)));
        }
        ArrayDeque<TreePath> arrayDeque = deque;
        if (arrayDeque == null) {
            TreeUtil.$$$reportNull$$$0(268);
        }
        return arrayDeque;
    }

    public static TreePath visitVisibleRows(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(269);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(270);
        }
        TreePath parent = null;
        int count = tree.getRowCount();
        block6: for (int row = 0; row < count; ++row) {
            if (count != tree.getRowCount()) {
                throw new ConcurrentModificationException("tree is modified");
            }
            TreePath path2 = tree.getPathForRow(row);
            if (path2 == null) {
                throw new NullPointerException("path is not found at row " + row);
            }
            if (parent != null && parent.isDescendant(path2)) continue;
            switch (visitor.visit(path2)) {
                case INTERRUPT: {
                    return path2;
                }
                case CONTINUE: {
                    parent = null;
                    continue block6;
                }
                case SKIP_CHILDREN: {
                    parent = path2;
                    continue block6;
                }
                case SKIP_SIBLINGS: {
                    parent = path2.getParentPath();
                    if (parent != null) continue block6;
                    return null;
                }
            }
        }
        return null;
    }

    public static <T> void visitVisibleRows(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper, @NotNull Consumer<? super T> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(271);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(272);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(273);
        }
        TreeUtil.visitVisibleRows(tree, path2 -> {
            Object object;
            if (mapper == null) {
                TreeUtil.$$$reportNull$$$0(281);
            }
            if (consumer == null) {
                TreeUtil.$$$reportNull$$$0(282);
            }
            if ((object = mapper.apply(path2)) != null) {
                consumer.accept((Object)object);
            }
            return TreeVisitor.Action.CONTINUE;
        });
    }

    @NotNull
    private static <T> List<T> collectVisibleRows(@NotNull JTree tree, @NotNull Predicate<? super TreePath> filter, @NotNull Function<? super TreePath, ? extends T> mapper) {
        int count;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(274);
        }
        if (filter == null) {
            TreeUtil.$$$reportNull$$$0(275);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(276);
        }
        if ((count = tree.getRowCount()) == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(277);
            }
            return list;
        }
        ArrayList list = new ArrayList(count);
        TreeUtil.visitVisibleRows(tree, path2 -> {
            if (filter == null) {
                TreeUtil.$$$reportNull$$$0(279);
            }
            if (mapper == null) {
                TreeUtil.$$$reportNull$$$0(280);
            }
            return filter.test((TreePath)path2) ? mapper.apply((TreePath)path2) : null;
        }, list::add);
        ArrayList arrayList = list;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(278);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 42: 
            case 44: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 134: 
            case 139: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 157: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 172: 
            case 173: 
            case 177: 
            case 178: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 190: 
            case 209: 
            case 217: 
            case 220: 
            case 226: 
            case 229: 
            case 232: 
            case 238: 
            case 244: 
            case 249: 
            case 255: 
            case 261: 
            case 262: 
            case 263: 
            case 268: 
            case 277: 
            case 278: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 42: 
            case 44: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 134: 
            case 139: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 157: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 172: 
            case 173: 
            case 177: 
            case 178: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 190: 
            case 209: 
            case 217: 
            case 220: 
            case 226: 
            case 229: 
            case 232: 
            case 238: 
            case 244: 
            case 249: 
            case 255: 
            case 261: 
            case 262: 
            case 263: 
            case 268: 
            case 277: 
            case 278: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 42: 
            case 44: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 134: 
            case 139: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 157: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 172: 
            case 173: 
            case 177: 
            case 178: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 190: 
            case 209: 
            case 217: 
            case 220: 
            case 226: 
            case 229: 
            case 232: 
            case 238: 
            case 244: 
            case 249: 
            case 255: 
            case 261: 
            case 262: 
            case 263: 
            case 268: 
            case 277: 
            case 278: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/tree/TreeUtil";
                break;
            }
            case 4: 
            case 45: 
            case 60: 
            case 69: 
            case 264: 
            case 266: 
            case 317: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 13: 
            case 27: 
            case 161: 
            case 171: 
            case 176: 
            case 272: 
            case 276: 
            case 280: 
            case 281: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: 
            case 195: 
            case 196: 
            case 316: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 164: 
            case 167: 
            case 170: 
            case 308: 
            case 315: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 31: 
            case 40: 
            case 64: 
            case 65: 
            case 80: 
            case 82: 
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aRootNode";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aNode";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 36: 
            case 41: 
            case 43: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 77: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 38: 
            case 39: 
            case 155: 
            case 211: 
            case 246: 
            case 253: 
            case 267: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 48: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBeRemoved";
                break;
            }
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aRoot";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePaths";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverse";
                break;
            }
            case 137: 
            case 142: 
            case 311: 
            case 312: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 175: 
            case 275: 
            case 279: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 180: 
            case 181: 
            case 182: 
            case 185: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aTree";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aBounds";
                break;
            }
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePoint";
                break;
            }
            case 199: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 200: 
            case 203: 
            case 205: 
            case 305: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 201: 
            case 204: 
            case 207: 
            case 304: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 206: 
            case 306: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 213: 
            case 216: 
            case 222: 
            case 225: 
            case 228: 
            case 236: 
            case 240: 
            case 243: 
            case 257: 
            case 260: 
            case 265: 
            case 270: 
            case 283: 
            case 292: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 214: 
            case 223: 
            case 241: 
            case 258: 
            case 273: 
            case 282: 
            case 284: 
            case 285: 
            case 290: 
            case 303: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 219: 
            case 231: 
            case 234: 
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitors";
                break;
            }
            case 237: 
            case 291: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/tree/TreeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "treeTraverser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "treePathTraverser";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "treeNodeTraverser";
                break;
            }
            case 9: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExpandedPaths";
                break;
            }
            case 11: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExpandedUserObjects";
                break;
            }
            case 14: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExpandedObjects";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedObjectsOfType";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFromRoot";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFromRootTo";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonPath";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFirstNode";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstNodePath";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLeafNodePath";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastPathComponent";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMaximals";
                break;
            }
            case 84: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "selectPath";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "moveDown";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "moveUp";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "movePageUp";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "movePageDown";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "moveHome";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "moveEnd";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "showRowCentred";
                break;
            }
            case 107: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "showRowCentered";
                break;
            }
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndSelect";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "listChildren";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseExpandAll";
                break;
            }
            case 144: 
            case 217: 
            case 220: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseExpand";
                break;
            }
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "selectInTree";
                break;
            }
            case 157: 
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedPaths";
                break;
            }
            case 159: 
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedUserObjects";
                break;
            }
            case 162: 
            case 172: 
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedObjects";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 183: 
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForSelection";
                break;
            }
            case 186: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForRow";
                break;
            }
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForPath";
                break;
            }
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForBounds";
                break;
            }
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayOrderComparator";
                break;
            }
            case 226: 
            case 232: 
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseMakeVisible";
                break;
            }
            case 229: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseMakeVisibleOne";
                break;
            }
            case 244: 
            case 249: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseSelect";
                break;
            }
            case 255: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseSelectFirst";
                break;
            }
            case 261: 
            case 262: 
            case 263: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseVisit";
                break;
            }
            case 268: {
                objectArray = objectArray2;
                objectArray2[1] = "children";
                break;
            }
            case 277: 
            case 278: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVisibleRows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "treeTraverser";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 42: 
            case 44: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 134: 
            case 139: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 157: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 172: 
            case 173: 
            case 177: 
            case 178: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 190: 
            case 209: 
            case 217: 
            case 220: 
            case 226: 
            case 229: 
            case 232: 
            case 238: 
            case 244: 
            case 249: 
            case 255: 
            case 261: 
            case 262: 
            case 263: 
            case 268: 
            case 277: 
            case 278: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "treePathTraverser";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "nodeChildren";
                break;
            }
            case 8: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedPaths";
                break;
            }
            case 10: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedUserObjects";
                break;
            }
            case 12: 
            case 13: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedObjects";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findObjectInPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedObjectsOfType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpandedPaths";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isDescendants";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRoot";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRootTo";
                break;
            }
            case 45: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findNodeWithObject";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeSelected";
                break;
            }
            case 47: 
            case 48: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "removeLastPathComponent";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findCommonPath";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "selectFirstNode";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNodePath";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLeafNodePath";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "areComponentsEqual";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "sortRecursively";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "sortChildren";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenTo";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "traverseDepth";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "selectPaths";
                break;
            }
            case 83: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "moveDown";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "moveUp";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "movePageUp";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "movePageDown";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "moveHome";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "moveEnd";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "showRowCentred";
                break;
            }
            case 106: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "showRowCentered";
                break;
            }
            case 110: 
            case 112: 
            case 114: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "showAndSelect";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRow";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getFirstVisibleRow";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRowCount";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRowCountForFixedRowHeight";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "installActions";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "copyAction";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "collapseAll";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "selectNode";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedRow";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "listChildren";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "expandAll";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "promiseExpandAll";
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 212: 
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 143: 
            case 215: 
            case 216: 
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "promiseExpand";
                break;
            }
            case 145: 
            case 147: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "selectInTree";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "isViewable";
                break;
            }
            case 156: 
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedPaths";
                break;
            }
            case 158: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedUserObjects";
                break;
            }
            case 160: 
            case 161: 
            case 169: 
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedObjects";
                break;
            }
            case 174: 
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "getSelection";
                break;
            }
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "unselectPath";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "getExpandControlRange";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "getDepthOffset";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "getPointForSelection";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "getPointForRow";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "getPointForPath";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "getPointForBounds";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "isOverSelection";
                break;
            }
            case 193: 
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "dropSelectionButUnderPoint";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "getUserObject";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "getLastUserObject";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedPathIfOne";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "ensureSelection";
                break;
            }
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "insertNode";
                break;
            }
            case 205: 
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "indexedBinarySearch";
                break;
            }
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrderComparator";
                break;
            }
            case 210: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "expandPathWithDebug";
                break;
            }
            case 221: 
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "makeVisible";
                break;
            }
            case 224: 
            case 225: 
            case 230: 
            case 231: 
            case 235: 
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "promiseMakeVisible";
                break;
            }
            case 227: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "promiseMakeVisibleOne";
                break;
            }
            case 233: 
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "promiseMakeVisibleAll";
                break;
            }
            case 239: 
            case 240: 
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 242: 
            case 243: 
            case 247: 
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "promiseSelect";
                break;
            }
            case 245: 
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "internalSelectPath";
                break;
            }
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "internalSelectPaths";
                break;
            }
            case 252: 
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "internalScroll";
                break;
            }
            case 254: {
                objectArray = objectArray;
                objectArray[2] = "promiseSelectFirst";
                break;
            }
            case 256: 
            case 257: 
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "promiseVisit";
                break;
            }
            case 264: 
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "visitModel";
                break;
            }
            case 266: 
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "children";
                break;
            }
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: {
                objectArray = objectArray;
                objectArray[2] = "visitVisibleRows";
                break;
            }
            case 274: 
            case 275: 
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "collectVisibleRows";
                break;
            }
            case 279: 
            case 280: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectVisibleRows$40";
                break;
            }
            case 281: 
            case 282: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitVisibleRows$39";
                break;
            }
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseVisit$38";
                break;
            }
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visit$37";
                break;
            }
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$36";
                break;
            }
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseSelectFirst$35";
                break;
            }
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseSelect$34";
                break;
            }
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseSelect$33";
                break;
            }
            case 289: 
            case 290: {
                objectArray = objectArray;
                objectArray[2] = "lambda$select$32";
                break;
            }
            case 291: 
            case 292: 
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseMakeVisible$31";
                break;
            }
            case 294: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseMakeVisibleAll$30";
                break;
            }
            case 295: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$29";
                break;
            }
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseMakeVisibleAll$28";
                break;
            }
            case 297: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseMakeVisibleOne$27";
                break;
            }
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$26";
                break;
            }
            case 299: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseExpand$25";
                break;
            }
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$24";
                break;
            }
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseExpand$23";
                break;
            }
            case 302: 
            case 303: {
                objectArray = objectArray;
                objectArray[2] = "lambda$expand$22";
                break;
            }
            case 304: 
            case 305: 
            case 306: {
                objectArray = objectArray;
                objectArray[2] = "lambda$indexedBinarySearch$21";
                break;
            }
            case 307: 
            case 308: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectSelectedObjects$20";
                break;
            }
            case 309: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectSelectedObjects$19";
                break;
            }
            case 310: {
                objectArray = objectArray;
                objectArray[2] = "lambda$selectInTree$18";
                break;
            }
            case 311: {
                objectArray = objectArray;
                objectArray[2] = "lambda$expand$15";
                break;
            }
            case 312: {
                objectArray = objectArray;
                objectArray[2] = "lambda$expandAll$14";
                break;
            }
            case 313: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showAndSelect$10";
                break;
            }
            case 314: 
            case 315: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectExpandedObjects$8";
                break;
            }
            case 316: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectSelectedObjectsOfType$7";
                break;
            }
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "lambda$nodeChildren$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 42: 
            case 44: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 134: 
            case 139: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 157: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 172: 
            case 173: 
            case 177: 
            case 178: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 190: 
            case 209: 
            case 217: 
            case 220: 
            case 226: 
            case 229: 
            case 232: 
            case 238: 
            case 244: 
            case 249: 
            case 255: 
            case 261: 
            case 262: 
            case 263: 
            case 268: 
            case 277: 
            case 278: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    @FunctionalInterface
    public static interface Traverse {
        public boolean accept(Object var1);
    }
}

