/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LibraryInfo {
    public static final LibraryInfo[] EMPTY_ARRAY = new LibraryInfo[0];
    @Nullable
    private final LibraryDownloadInfo myDownloadInfo;
    @NonNls
    private final String myName;
    @Nullable
    private String myMd5;
    @NonNls
    private final String[] myRequiredClasses;

    public LibraryInfo(@NonNls String name, @Nullable @NonNls String downloadingUrl, @Nullable String presentableUrl, @Nullable String md5, String ... requiredClasses) {
        this.myName = name;
        this.myMd5 = md5;
        this.myRequiredClasses = requiredClasses;
        if (downloadingUrl != null) {
            int dot = name.lastIndexOf(46);
            String prefix = name.substring(0, dot);
            String suffix = name.substring(dot);
            this.myDownloadInfo = new LibraryDownloadInfo(downloadingUrl, presentableUrl, prefix, suffix);
        } else {
            this.myDownloadInfo = null;
        }
    }

    public LibraryInfo(@NonNls String name, @Nullable LibraryDownloadInfo downloadInfo, String ... requiredClasses) {
        this.myName = name;
        this.myRequiredClasses = requiredClasses;
        this.myDownloadInfo = downloadInfo;
    }

    @NonNls
    public String getName() {
        return this.myName;
    }

    @NonNls
    public String[] getRequiredClasses() {
        return this.myRequiredClasses;
    }

    @Nullable
    public LibraryDownloadInfo getDownloadingInfo() {
        return this.myDownloadInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryInfo that = (LibraryInfo)o;
        if (this.myDownloadInfo != null ? !this.myDownloadInfo.equals(that.myDownloadInfo) : that.myDownloadInfo != null) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return Arrays.equals(this.myRequiredClasses, that.myRequiredClasses);
    }

    public int hashCode() {
        int result2 = this.myDownloadInfo != null ? this.myDownloadInfo.hashCode() : 0;
        result2 = 31 * result2 + this.myName.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.myRequiredClasses);
        return result2;
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public String getMd5() {
        return this.myMd5;
    }
}

