#!/usr/bin/env python

# "Optional option arguments" with Optik, version 1:
# supply a callback function to handle options with
# optional arguments.
#
# There are lots of problems with this approach:
#   * doesn't allow "--home=~"; only "--home" and "--home ~" work
#   * doesn't allow "-afoo"; only "-a" or "-a foo" work
#   * option type can't be specified, because that makes
#     OptionParser require a value
#   * all the logic about what "-" and "--" mean is duplicated
#     in the callback here
#   * it's awkward as hell to use
# 
# This just shows that Optik's current design is ill-suited
# to handling optional option args.  Hmm.

from optik import OptionParser, Option

def optional_arg(option, opt, value, parser, option_default=None):

    assert value is None
    value = option_default

    # If there is a next argument, peek at it to see if it can
    # be considered an argument to 'opt'.
    if parser.rargs:
        arg = parser.rargs[0]

        if arg[0:2] == "--" or arg[0:1] == "-":
            # Either arg is another option -- "--foobar", "-a" -- or
            # it's one of the special stop-values, "--" or "-".
            # In either case, we consider it special and do *not*
            # consume it as an argument to the current option.
            pass
        else:
            # Otherwise, consume arg and use it as the value for 'option'.
            value = arg
            del parser.rargs[0]

    setattr(parser.values, option.dest, value)


parser = OptionParser()
parser.add_option("-v", action="callback", dest='verbose',
                  callback=optional_arg,
                  callback_kwargs={'option_default': 1})
parser.add_option("-l", "--log-file", action="callback", dest='log_file',
                  callback=optional_arg,
                  callback_kwargs={'option_default': "foo.log"})
(options, args) = parser.parse_args()

print "options.verbose = %r" % options.verbose
print "options.log_file = %r" % options.log_file
