/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.discovery;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.logstash.plugins.discovery.Configuration;
import org.logstash.plugins.discovery.ConfigurationBuilder;
import org.logstash.plugins.discovery.ReflectionUtils;
import org.logstash.plugins.discovery.ReflectionsException;
import org.logstash.plugins.discovery.Scanner;
import org.logstash.plugins.discovery.Store;
import org.logstash.plugins.discovery.SubTypesScanner;
import org.logstash.plugins.discovery.TypeAnnotationsScanner;
import org.logstash.plugins.discovery.Vfs;

public class Reflections {
    protected final Configuration configuration;
    protected Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store(configuration);
        if (configuration.getScanners() != null && !configuration.getScanners().isEmpty()) {
            for (Scanner scanner : configuration.getScanners()) {
                scanner.setConfiguration(configuration);
                scanner.setStore(this.store.getOrCreate(scanner.getClass().getSimpleName()));
            }
            this.scan();
            if (configuration.shouldExpandSuperTypes()) {
                this.expandSuperTypes();
            }
        }
    }

    public Reflections(String prefix, Scanner ... scanners) {
        this(new Object[]{prefix, scanners});
    }

    public Reflections(Object ... params) {
        this(ConfigurationBuilder.build(params));
    }

    protected void scan() {
        if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
            return;
        }
        ExecutorService executorService = this.configuration.getExecutorService();
        ArrayList futures = Lists.newArrayList();
        for (URL url : this.configuration.getUrls()) {
            try {
                if (executorService != null) {
                    futures.add(executorService.submit(() -> this.scan(url)));
                    continue;
                }
                this.scan(url);
            }
            catch (ReflectionsException reflectionsException) {}
        }
        if (executorService != null) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(URL url) {
        try (Vfs.Dir dir = Vfs.fromURL(url);){
            for (Vfs.File file : dir.getFiles()) {
                Predicate<String> inputsFilter = this.configuration.getInputsFilter();
                String path = file.getRelativePath();
                String fqn = path.replace('/', '.');
                if (inputsFilter != null && !inputsFilter.apply((Object)path) && !inputsFilter.apply((Object)fqn)) continue;
                Object classObject = null;
                for (Scanner scanner : this.configuration.getScanners()) {
                    try {
                        if (!scanner.acceptsInput(path) && !scanner.acceptResult(fqn)) continue;
                        classObject = scanner.scan(file, classObject);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void expandSuperTypes() {
        if (this.store.keySet().contains(Reflections.index(SubTypesScanner.class))) {
            Multimap<String, String> mmap = this.store.get(Reflections.index(SubTypesScanner.class));
            Sets.SetView keys = Sets.difference((Set)mmap.keySet(), (Set)Sets.newHashSet((Iterable)mmap.values()));
            HashMultimap expand = HashMultimap.create();
            for (String key : keys) {
                Class<?> type = ReflectionUtils.forName(key, new ClassLoader[0]);
                if (type == null) continue;
                this.expandSupertypes((Multimap<String, String>)expand, key, type);
            }
            mmap.putAll((Multimap)expand);
        }
    }

    private void expandSupertypes(Multimap<String, String> mmap, String key, Class<?> type) {
        for (Class<?> supertype : ReflectionUtils.getSuperTypes(type)) {
            if (!mmap.put((Object)supertype.getName(), (Object)key)) continue;
            this.expandSupertypes(mmap, supertype.getName(), supertype);
        }
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.getTypesAnnotatedWith(annotation, false);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        Iterable<String> annotated = this.store.get(Reflections.index(TypeAnnotationsScanner.class), annotation.getName());
        Iterable<String> classes = this.getAllAnnotated(annotated, annotation.isAnnotationPresent(Inherited.class), honorInherited);
        return Sets.newHashSet((Iterable)Iterables.concat(ReflectionUtils.forNames(annotated, this.loaders()), ReflectionUtils.forNames(classes, this.loaders())));
    }

    protected Iterable<String> getAllAnnotated(Iterable<String> annotated, boolean inherited, boolean honorInherited) {
        Iterable subTypes = Iterables.concat(annotated, this.store.getAll(Reflections.index(TypeAnnotationsScanner.class), annotated));
        return Iterables.concat((Iterable)subTypes, this.store.getAll(Reflections.index(SubTypesScanner.class), subTypes));
    }

    private static String index(Class<? extends Scanner> scannerClass) {
        return scannerClass.getSimpleName();
    }

    private ClassLoader[] loaders() {
        return this.configuration.getClassLoaders();
    }
}

