/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.pipeline;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.RubySymbol;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.counter.CounterMetric;
import org.logstash.instrument.metrics.counter.LongCounter;
import org.logstash.instrument.metrics.gauge.GaugeMetric;
import org.logstash.instrument.metrics.gauge.LazyDelegatingGauge;
import org.logstash.instrument.metrics.gauge.TextGauge;
import org.logstash.instrument.witness.MetricSerializer;
import org.logstash.instrument.witness.SerializableWitness;
import org.logstash.instrument.witness.pipeline.EventsWitness;

@JsonSerialize(using=Serializer.class)
public class PluginWitness
implements SerializableWitness {
    private final EventsWitness eventsWitness = new EventsWitness();
    private final CustomWitness customWitness = new CustomWitness();
    private final TextGauge id;
    private final TextGauge name;
    private final Snitch snitch;

    public PluginWitness(String id) {
        this.id = new TextGauge("id", id);
        this.name = new TextGauge("name");
        this.snitch = new Snitch(this);
    }

    public EventsWitness events() {
        return this.eventsWitness;
    }

    public PluginWitness name(String name) {
        this.name.set(name);
        return this;
    }

    public CustomWitness custom() {
        return this.customWitness;
    }

    public Snitch snitch() {
        return this.snitch;
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen, provider);
    }

    public static final class Snitch {
        private final PluginWitness witness;

        private Snitch(PluginWitness witness) {
            this.witness = witness;
        }

        public String id() {
            return (String)this.witness.id.getValue();
        }

        public String name() {
            return (String)this.witness.name.getValue();
        }
    }

    public static final class CustomWitness {
        private final Snitch snitch;
        private final Map<String, GaugeMetric<Object, Object>> gauges = new ConcurrentHashMap<String, GaugeMetric<Object, Object>>();
        private final Map<String, CounterMetric<Long>> counters = new ConcurrentHashMap<String, CounterMetric<Long>>();

        private CustomWitness() {
            this.snitch = new Snitch(this);
        }

        public void gauge(RubySymbol key, Object value) {
            this.gauge(key.asJavaString(), value);
        }

        public void gauge(String key, Object value) {
            LazyDelegatingGauge gauge = this.gauges.get(key);
            if (gauge != null) {
                gauge.set((Object)value);
            } else {
                gauge = new LazyDelegatingGauge(key, value);
                this.gauges.put(key, gauge);
            }
        }

        public void increment(RubySymbol key) {
            this.increment(key.asJavaString());
        }

        public void increment(String key) {
            this.increment(key, 1L);
        }

        public void increment(RubySymbol key, long by) {
            this.increment(key.asJavaString(), by);
        }

        public void increment(String key, long by) {
            LongCounter counter = this.counters.get(key);
            if (counter != null) {
                counter.increment((Long)by);
            } else {
                counter = new LongCounter(key);
                counter.increment();
                this.counters.put(key, counter);
            }
        }

        public Snitch snitch() {
            return this.snitch;
        }

        public static final class Snitch {
            private final CustomWitness witness;

            private Snitch(CustomWitness witness) {
                this.witness = witness;
            }

            public GaugeMetric gauge(String key) {
                return (GaugeMetric)this.witness.gauges.get(key);
            }

            public Map<String, GaugeMetric<?, ?>> gauges() {
                return Collections.unmodifiableMap(this.witness.gauges);
            }

            public CounterMetric<?> counter(String key) {
                return (CounterMetric)this.witness.counters.get(key);
            }

            public Map<String, CounterMetric<?>> counters() {
                return Collections.unmodifiableMap(this.witness.counters);
            }
        }
    }

    public static final class Serializer
    extends StdSerializer<PluginWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(PluginWitness.class);
        }

        protected Serializer(Class<PluginWitness> t) {
            super(t);
        }

        public void serialize(PluginWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen, provider);
            gen.writeEndObject();
        }

        static void innerSerialize(PluginWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            MetricSerializer<Metric<String>> stringSerializer = MetricSerializer.Get.stringSerializer(gen);
            MetricSerializer<Metric<Long>> longSerializer = MetricSerializer.Get.longSerializer(gen);
            stringSerializer.serialize(witness.id);
            witness.events().genJson(gen, provider);
            stringSerializer.serialize(witness.name);
            for (GaugeMetric gauge : witness.customWitness.gauges.values()) {
                gen.writeObjectField(gauge.getName(), gauge.getValue());
            }
            for (CounterMetric counter : witness.customWitness.counters.values()) {
                longSerializer.serialize(counter);
            }
        }
    }
}

