/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.gauge.RubyTimeStampGauge;

@FunctionalInterface
public interface MetricSerializer<T extends Metric<?>> {
    public void serialize(T var1) throws IOException;

    public static class Get {
        public static MetricSerializer<Metric<Number>> numberSerializer(JsonGenerator gen) {
            return m -> {
                if (m != null) {
                    Number value = (Number)m.getValue();
                    gen.writeObjectField(m.getName(), (Object)(value == null ? (Number)0 : (Number)value));
                }
            };
        }

        public static MetricSerializer<Metric<Long>> longSerializer(JsonGenerator gen) {
            return m -> {
                if (m != null) {
                    Long value = (Long)m.getValue();
                    gen.writeNumberField(m.getName(), value == null ? 0L : value);
                }
            };
        }

        public static MetricSerializer<Metric<Boolean>> booleanSerializer(JsonGenerator gen) {
            return m -> {
                if (m != null) {
                    Boolean value = (Boolean)m.getValue();
                    gen.writeBooleanField(m.getName(), value == null ? false : value);
                }
            };
        }

        public static MetricSerializer<Metric<String>> stringSerializer(JsonGenerator gen) {
            return m -> {
                if (m != null) {
                    gen.writeStringField(m.getName(), (String)m.getValue());
                }
            };
        }

        public static MetricSerializer<RubyTimeStampGauge> timestampSerializer(JsonGenerator gen) {
            return m -> {
                if (m != null) {
                    gen.writeStringField(m.getName(), m.getValue() != null ? m.getValue().toString() : null);
                }
            };
        }
    }
}

