/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.OptionalInt;
import java.util.zip.CRC32;
import org.logstash.common.io.RecordHeader;
import org.logstash.common.io.RecordType;

public final class RecordIOWriter
implements Closeable {
    private final FileChannel channel;
    private int posInBlock = 0;
    private int currentBlockIdx = 0;
    static final int BLOCK_SIZE = 32768;
    static final int RECORD_HEADER_SIZE = 13;
    static final int VERSION_SIZE = 1;
    static final char VERSION = '1';

    public RecordIOWriter(Path recordsFile) throws IOException {
        recordsFile.toFile().createNewFile();
        this.channel = FileChannel.open(recordsFile, StandardOpenOption.WRITE);
        this.channel.write(ByteBuffer.wrap(new byte[]{49}));
    }

    private int remainingInBlock() {
        return 32768 - this.posInBlock;
    }

    int writeRecordHeader(RecordHeader header) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(13);
        buffer.put(header.getType().toByte());
        buffer.putInt(header.getSize());
        buffer.putInt(header.getTotalEventSize().orElse(-1));
        buffer.putInt(header.getChecksum());
        buffer.rewind();
        return this.channel.write(buffer);
    }

    private RecordType getNextType(ByteBuffer buffer, RecordType previous) {
        boolean fits;
        boolean bl = fits = buffer.remaining() + 13 < this.remainingInBlock();
        if (previous == null) {
            return fits ? RecordType.COMPLETE : RecordType.START;
        }
        if (previous == RecordType.START || previous == RecordType.MIDDLE) {
            return fits ? RecordType.END : RecordType.MIDDLE;
        }
        return null;
    }

    public long getPosition() throws IOException {
        return this.channel.position();
    }

    public long writeEvent(byte[] eventArray) throws IOException {
        ByteBuffer eventBuffer = ByteBuffer.wrap(eventArray);
        RecordType nextType = null;
        ByteBuffer slice = eventBuffer.slice();
        long startPosition = this.channel.position();
        while (slice.hasRemaining()) {
            if (this.posInBlock + 13 + 1 > 32768) {
                this.channel.position(++this.currentBlockIdx * 32768 + 1);
                this.posInBlock = 0;
            }
            nextType = this.getNextType(slice, nextType);
            int originalLimit = slice.limit();
            int nextRecordSize = Math.min(this.remainingInBlock() - 13, slice.remaining());
            OptionalInt optTotalSize = nextType == RecordType.START ? OptionalInt.of(eventArray.length) : OptionalInt.empty();
            slice.limit(nextRecordSize);
            CRC32 checksum = new CRC32();
            checksum.update(slice.array(), slice.arrayOffset() + slice.position(), nextRecordSize);
            this.posInBlock += this.writeRecordHeader(new RecordHeader(nextType, nextRecordSize, optTotalSize, (int)checksum.getValue()));
            this.posInBlock += this.channel.write(slice);
            slice.limit(originalLimit);
            slice = slice.slice();
        }
        return this.channel.position() - startPosition;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

