/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.jd.gui.spi.PreferencesPanel;

public class DirectoryIndexerPreferencesProvider
extends JPanel
implements PreferencesPanel,
DocumentListener,
GroovyObject {
    private static final int MAX_VALUE = 30;
    private static final String MAXIMUM_DEPTH_KEY = "DirectoryIndexerPreferences.maximumDepth";
    private PreferencesPanel.PreferencesPanelChangeListener listener;
    private JTextField maximumDepthTextField;
    private Color errorBackgroundColor;
    private Color defaultBackgroundColor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public DirectoryIndexerPreferencesProvider() {
        super(new BorderLayout());
        Color color;
        JTextField jTextField;
        MetaClass metaClass;
        Color color2;
        Object var1_1 = null;
        this.listener = (PreferencesPanel.PreferencesPanelChangeListener)ScriptBytecodeAdapter.castToType(var1_1, PreferencesPanel.PreferencesPanelChangeListener.class);
        this.errorBackgroundColor = color2 = Color.RED;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.add((Component)new JLabel(StringGroovyMethods.plus(StringGroovyMethods.plus((CharSequence)"Maximum depth (1..", (Object)MAX_VALUE), (CharSequence)"): ")), BorderLayout.WEST);
        this.maximumDepthTextField = jTextField = new JTextField();
        this.maximumDepthTextField.getDocument().addDocumentListener(this);
        this.add((Component)this.maximumDepthTextField, BorderLayout.CENTER);
        this.defaultBackgroundColor = color = this.maximumDepthTextField.getBackground();
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Indexer";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Directory exploration";
    }

    @Override
    public void init(Color errorBackgroundColor) {
        Color color;
        this.errorBackgroundColor = color = errorBackgroundColor;
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        String string = preferences.get(MAXIMUM_DEPTH_KEY);
        String string2 = ShortTypeHandling.castToString(string);
        String string3 = DefaultTypeTransformation.booleanUnbox(string) ? string2 : "15";
        this.maximumDepthTextField.setText(string3);
        this.maximumDepthTextField.setCaretPosition(StringGroovyMethods.size(this.maximumDepthTextField.getText()));
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put(MAXIMUM_DEPTH_KEY, this.maximumDepthTextField.getText());
    }

    @Override
    public boolean arePreferencesValid() {
        int i = Integer.valueOf(this.maximumDepthTextField.getText());
        boolean bl = i > 0 && i <= MAX_VALUE;
        try {
            return bl;
        }
        catch (NumberFormatException ignore) {
            boolean bl2 = false;
            return bl2;
        }
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
        PreferencesPanel.PreferencesPanelChangeListener preferencesPanelChangeListener;
        this.listener = preferencesPanelChangeListener = listener;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    public void onTextChange() {
        Object v0;
        Color color = this.arePreferencesValid() ? this.defaultBackgroundColor : this.errorBackgroundColor;
        this.maximumDepthTextField.setBackground(color);
        PreferencesPanel.PreferencesPanelChangeListener preferencesPanelChangeListener = this.listener;
        if (preferencesPanelChangeListener != null) {
            preferencesPanelChangeListener.preferencesPanelChanged(this);
            v0 = null;
        } else {
            v0 = null;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DirectoryIndexerPreferencesProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    @Generated
    public static int getMAX_VALUE() {
        return MAX_VALUE;
    }

    @Generated
    public static String getMAXIMUM_DEPTH_KEY() {
        return MAXIMUM_DEPTH_KEY;
    }

    @Generated
    public PreferencesPanel.PreferencesPanelChangeListener getListener() {
        return this.listener;
    }

    @Generated
    public void setListener(PreferencesPanel.PreferencesPanelChangeListener preferencesPanelChangeListener) {
        this.listener = preferencesPanelChangeListener;
    }

    @Generated
    public JTextField getMaximumDepthTextField() {
        return this.maximumDepthTextField;
    }

    @Generated
    public void setMaximumDepthTextField(JTextField jTextField) {
        this.maximumDepthTextField = jTextField;
    }

    @Generated
    public Color getErrorBackgroundColor() {
        return this.errorBackgroundColor;
    }

    @Generated
    public void setErrorBackgroundColor(Color color) {
        this.errorBackgroundColor = color;
    }

    @Generated
    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    @Generated
    public void setDefaultBackgroundColor(Color color) {
        this.defaultBackgroundColor = color;
    }
}

