/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer;

import java.util.HashSet;
import jd.core.loader.Loader;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.ParameterAnnotations;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.Printer;
import jd.core.process.writer.AnnotationWriter;
import jd.core.util.CharArrayUtil;
import jd.core.util.SignatureFormatException;
import jd.core.util.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureWriter {
    public static void WriteTypeDeclaration(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, String signature) {
        char[] caSignature = signature.toCharArray();
        int length = caSignature.length;
        printer.printTypeDeclaration(classFile.getThisClassName(), classFile.getClassName());
        SignatureWriter.WriteGenerics(loader, printer, referenceMap, classFile, caSignature, length, 0);
    }

    public static int WriteConstructor(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, String signature, String descriptor) {
        char[] caSignature = signature.toCharArray();
        return SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, caSignature.length, 0, true, descriptor, false);
    }

    public static void WriteMethodDeclaration(HashSet<String> keywordSet, Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, Method method, String signature, boolean descriptorFlag) {
        boolean staticMethodFlag;
        int index;
        int length;
        char[] caSignature = signature.toCharArray();
        int newIndex = SignatureWriter.WriteGenerics(loader, printer, referenceMap, classFile, caSignature, length = caSignature.length, index = 0);
        if (newIndex != index) {
            printer.print(' ');
            index = newIndex;
        }
        if (caSignature[index] != '(') {
            throw new SignatureFormatException(signature);
        }
        ++index;
        ConstantPool constants = classFile.getConstantPool();
        String internalClassName = classFile.getThisClassName();
        String descriptor = constants.getConstantUtf8(method.descriptor_index);
        boolean bl = staticMethodFlag = (method.access_flags & 8) != 0;
        if (method.name_index == constants.instanceConstructorIndex) {
            printer.printConstructorDeclaration(internalClassName, classFile.getClassName(), descriptor);
        } else {
            newIndex = index;
            while (newIndex < length) {
                if (caSignature[newIndex++] == ')') break;
            }
            SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, length, newIndex, false, null, false);
            printer.print(' ');
            String methodName = constants.getConstantUtf8(method.name_index);
            if (keywordSet.contains(methodName)) {
                methodName = "jdMethod_" + methodName;
            }
            if (staticMethodFlag) {
                printer.printStaticMethodDeclaration(internalClassName, methodName, descriptor);
            } else {
                printer.printMethodDeclaration(internalClassName, methodName, descriptor);
            }
        }
        printer.print('(');
        int variableIndex = staticMethodFlag ? 0 : 1;
        int firstVisibleParameterIndex = 0;
        if (method.name_index == constants.instanceConstructorIndex) {
            if ((classFile.access_flags & 0x4000) != 0) {
                if (descriptorFlag) {
                    firstVisibleParameterIndex = 2;
                } else {
                    variableIndex = 3;
                }
            } else if (classFile.isAInnerClass() && (classFile.access_flags & 8) == 0) {
                firstVisibleParameterIndex = 1;
            }
        }
        ParameterAnnotations[] invisibleParameterAnnotations = method.getInvisibleParameterAnnotations();
        ParameterAnnotations[] visibleParameterAnnotations = method.getVisibleParameterAnnotations();
        int parameterIndex = 0;
        int varargsParameterIndex = (method.access_flags & 0x80) == 0 ? Integer.MAX_VALUE : SignatureUtil.GetParameterSignatureCount(signature) - 1;
        while (caSignature[index] != ')') {
            char firstChar = caSignature[index];
            if (parameterIndex >= firstVisibleParameterIndex) {
                if (parameterIndex > firstVisibleParameterIndex) {
                    printer.print(", ");
                }
                if (invisibleParameterAnnotations != null) {
                    AnnotationWriter.WriteParameterAnnotation(loader, printer, referenceMap, classFile, invisibleParameterAnnotations[parameterIndex]);
                }
                if (visibleParameterAnnotations != null) {
                    AnnotationWriter.WriteParameterAnnotation(loader, printer, referenceMap, classFile, visibleParameterAnnotations[parameterIndex]);
                }
                LocalVariable lv = null;
                if (method.getLocalVariables() != null && (lv = method.getLocalVariables().searchLocalVariableWithIndexAndOffset(variableIndex, 0)) != null && lv.finalFlag) {
                    printer.printKeyword("final");
                    printer.print(' ');
                }
                index = SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, length, index, false, null, parameterIndex == varargsParameterIndex);
                if (lv != null) {
                    printer.print(' ');
                    if (lv.name_index == -1) {
                        printer.startOfError();
                        printer.print("???");
                        printer.endOfError();
                    } else {
                        printer.print(constants.getConstantUtf8(lv.name_index));
                    }
                } else {
                    printer.print(" arg");
                    printer.print(variableIndex);
                }
            } else {
                index = SignatureUtil.SkipSignature(caSignature, length, index);
            }
            variableIndex += firstChar == 'D' || firstChar == 'J' ? 2 : 1;
            ++parameterIndex;
        }
        printer.print(')');
    }

    private static int WriteGenerics(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, char[] caSignature, int length, int index) {
        if (caSignature[index] == '<') {
            printer.print('<');
            ++index;
            while (index < length) {
                int newIndex;
                int endIndex = CharArrayUtil.IndexOf(caSignature, ':', index);
                String templateName = CharArrayUtil.Substring(caSignature, index, endIndex);
                printer.print(templateName);
                index = endIndex + 1;
                if (caSignature[index] == ':') {
                    ++index;
                }
                if (!SignatureWriter.IsObjectClass(caSignature, index, newIndex = SignatureUtil.SkipSignature(caSignature, length, index))) {
                    printer.print(' ');
                    printer.printKeyword("extends");
                    printer.print(' ');
                    SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, length, index, false, null, false);
                }
                if (caSignature[index = newIndex] == '>') break;
                printer.print(", ");
            }
            printer.print('>');
            ++index;
        }
        return index;
    }

    public static int WriteSignature(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, char[] caSignature, int length, int index) {
        return SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, length, index, false, null, false);
    }

    public static int WriteSignature(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, String signature) {
        char[] caSignature = signature.toCharArray();
        return SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, caSignature.length, 0, false, null, false);
    }

    /*
     * Unable to fully structure code
     */
    private static int WriteSignature(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, char[] caSignature, int length, int index, boolean constructorFlag, String constructorDescriptor, boolean varargsFlag) {
        while (true) {
            block33: {
                dimensionLength = 0;
                if (caSignature[index] == '[') {
                    ++dimensionLength;
                    while (++index < length) {
                        if (caSignature[index] == 'L' && index + 1 < length && caSignature[index + 1] == '[') {
                            ++index;
                            --length;
                            ++dimensionLength;
                            continue;
                        }
                        if (caSignature[index] != '[') break;
                        ++dimensionLength;
                    }
                }
                switch (caSignature[index]) {
                    case 'B': {
                        printer.printKeyword("byte");
                        ++index;
                        break;
                    }
                    case 'C': {
                        printer.printKeyword("char");
                        ++index;
                        break;
                    }
                    case 'D': {
                        printer.printKeyword("double");
                        ++index;
                        break;
                    }
                    case 'F': {
                        printer.printKeyword("float");
                        ++index;
                        break;
                    }
                    case 'I': {
                        printer.printKeyword("int");
                        ++index;
                        break;
                    }
                    case 'J': {
                        printer.printKeyword("long");
                        ++index;
                        break;
                    }
                    case '.': 
                    case 'L': {
                        typeFlag = caSignature[index] == 'L';
                        beginIndex = ++index;
                        c = 46;
                        while (index < length) {
                            c = caSignature[index];
                            if (c == 59 || c == 60) break;
                            ++index;
                        }
                        internalClassName = CharArrayUtil.Substring(caSignature, beginIndex, index);
                        if (typeFlag) {
                            thisClassName = classFile.getThisClassName();
                            if (constructorFlag) {
                                printer.printConstructor(internalClassName, SignatureWriter.InternalClassNameToClassName(loader, referenceMap, classFile, internalClassName), constructorDescriptor, thisClassName);
                            } else {
                                printer.printType(internalClassName, SignatureWriter.InternalClassNameToClassName(loader, referenceMap, classFile, internalClassName), thisClassName);
                            }
                        } else {
                            printer.print(SignatureWriter.InternalClassNameToClassName(loader, referenceMap, classFile, internalClassName));
                        }
                        if (c == 60) {
                            printer.print('<');
                            index = SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, length, index + 1, false, null, false);
                            while (caSignature[index] != '>') {
                                printer.print(", ");
                                index = SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, length, index, false, null, false);
                            }
                            printer.print('>');
                            ++index;
                        }
                        if (caSignature[index] != ';') break;
                        ++index;
                        break;
                    }
                    case 'S': {
                        printer.printKeyword("short");
                        ++index;
                        break;
                    }
                    case 'T': {
                        beginIndex = ++index;
                        index = CharArrayUtil.IndexOf(caSignature, ';', beginIndex);
                        printer.print(new String(caSignature, beginIndex, index - beginIndex));
                        ++index;
                        break;
                    }
                    case 'V': {
                        printer.printKeyword("void");
                        ++index;
                        break;
                    }
                    case 'Z': {
                        printer.printKeyword("boolean");
                        ++index;
                        break;
                    }
                    case '-': {
                        printer.print("? ");
                        printer.printKeyword("super");
                        printer.print(' ');
                        index = SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, length, index + 1, false, null, false);
                        break;
                    }
                    case '+': {
                        printer.print("? ");
                        printer.printKeyword("extends");
                        printer.print(' ');
                        index = SignatureWriter.WriteSignature(loader, printer, referenceMap, classFile, caSignature, length, index + 1, false, null, false);
                        break;
                    }
                    case '*': {
                        printer.print('?');
                        ++index;
                        break;
                    }
                    case 'X': 
                    case 'Y': {
                        printer.printKeyword("int");
                        System.err.println("<UNDEFINED>");
                        ++index;
                        break;
                    }
                    default: {
                        new Throwable("SignatureWriter.WriteSignature: invalid signature '" + String.valueOf(caSignature) + "'").printStackTrace();
                    }
                }
                if (!varargsFlag) ** GOTO lbl118
                if (dimensionLength <= 0) break block33;
                while (--dimensionLength > 0) {
                    printer.print("[]");
                }
                printer.print("...");
                break block33;
lbl-1000:
                // 1 sources

                {
                    printer.print("[]");
lbl118:
                    // 2 sources

                    ** while (dimensionLength-- > 0)
                }
            }
            if (index >= length || caSignature[index] != '.') break;
            printer.print('.');
        }
        return index;
    }

    public static String InternalClassNameToClassName(Loader loader, ReferenceMap referenceMap, ClassFile classFile, String internalName) {
        if (classFile.getThisClassName().equals(internalName)) {
            int index = internalName.lastIndexOf(36);
            if (index >= 0) {
                internalName = internalName.substring(index + 1);
            } else {
                index = internalName.lastIndexOf(47);
                if (index >= 0) {
                    internalName = internalName.substring(index + 1);
                }
            }
        } else {
            int index = internalName.lastIndexOf(47);
            if (index != -1) {
                String internalPackageName = internalName.substring(0, index);
                if (classFile.getInternalPackageName().equals(internalPackageName)) {
                    internalName = classFile.getInnerClassFile(internalName) != null ? internalName.substring(classFile.getThisClassName().length() + 1) : internalName.substring(index + 1);
                } else if (referenceMap.contains(internalName)) {
                    internalName = internalName.substring(index + 1);
                } else if ("java/lang".equals(internalPackageName)) {
                    String internalClassName = internalName.substring(index + 1);
                    String currentPackageNamePlusInternalClassName = String.valueOf(classFile.getInternalPackageName()) + '/' + internalClassName + ".class";
                    internalName = loader.canLoad(currentPackageNamePlusInternalClassName) ? internalName.replace('/', '.') : internalClassName;
                } else {
                    internalName = internalName.replace('/', '.');
                }
            }
        }
        return internalName.replace('$', '.');
    }

    public static String InternalClassNameToShortClassName(ReferenceMap referenceMap, ClassFile classFile, String internalClassName) {
        int index = internalClassName.lastIndexOf(47);
        if (index != -1) {
            String aPackageName = internalClassName.substring(0, index);
            internalClassName = classFile.getInternalPackageName().equals(aPackageName) ? internalClassName.substring(index + 1) : (referenceMap.contains(internalClassName) ? internalClassName.substring(index + 1) : internalClassName.replace('/', '.'));
        }
        return internalClassName.replace('$', '.');
    }

    private static boolean IsObjectClass(char[] caSignature, int beginIndex, int endIndex) {
        int length = "Ljava/lang/Object;".length();
        if (endIndex - beginIndex == length) {
            return CharArrayUtil.Substring(caSignature, beginIndex, endIndex).equals("Ljava/lang/Object;");
        }
        return false;
    }
}

