/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchFileLanguageProvider;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchFileHook;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isPluggable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectClosed", "", "projectOpened", "ScratchEditorListener", "idea-jvm"})
public final class ScratchFileHook
extends AbstractProjectComponent {
    public void projectOpened() {
        Project project = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
        project.getMessageBus().connect((Disposable)this.myProject).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new ScratchEditorListener());
    }

    public void projectClosed() {
        Project project = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
        Iterable $receiver$iv = ScratchUtilsKt.getAllEditorsWithScratchPanel(project);
        for (Object element$iv : $receiver$iv) {
            Pair $editor_panel = (Pair)element$iv;
            TextEditor editor = (TextEditor)$editor_panel.component1();
            ScratchTopPanel panel = (ScratchTopPanel)$editor_panel.component2();
            ScratchUtilsKt.removeScratchPanel(editor, panel);
        }
    }

    private final boolean isPluggable(VirtualFile file2) {
        if (!file2.isValid()) {
            return false;
        }
        if (!(ScratchFileService.getInstance().getRootType(file2) instanceof ScratchRootType)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiManager.getInstance(m\u2026ile(file) ?: return false");
        PsiFile psiFile2 = psiFile;
        FileType fileType = psiFile2.getFileType();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"psiFile.fileType");
        return ScratchFileLanguageProvider.Companion.get(fileType) != null;
    }

    public ScratchFileHook(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchFileHook$ScratchEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "(Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchFileHook;)V", "fileClosed", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpened", "idea-jvm"})
    private final class ScratchEditorListener
    implements FileEditorManagerListener {
        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            if (!ScratchFileHook.this.isPluggable(file2)) {
                return;
            }
            TextEditor textEditor = ScratchUtilsKt.getEditorWithoutScratchPanel(source, file2);
            if (textEditor == null) {
                return;
            }
            TextEditor editor = textEditor;
            Project project = ScratchFileHook.this.myProject;
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
            ScratchTopPanel.Companion.createPanel(project, file2, editor);
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        }
    }
}

