/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/TextEditor;)V", "getEditor", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getExpressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getModule", "Lcom/intellij/openapi/module/Module;", "getPsiFile", "idea-jvm"})
public abstract class ScratchFile {
    @NotNull
    private final Project project;
    @NotNull
    private final TextEditor editor;

    @NotNull
    public final List<ScratchExpression> getExpressions() {
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile2 = psiFile;
        return this.getExpressions(psiFile2);
    }

    @Nullable
    public final PsiFile getPsiFile() {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        Editor editor = this.editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor.editor");
        return psiDocumentManager.getPsiFile(editor.getDocument());
    }

    @Nullable
    public final Module getModule() {
        ScratchTopPanel scratchTopPanel = ScratchUtilsKt.getScratchPanel(this.editor);
        return scratchTopPanel != null ? scratchTopPanel.getModule() : null;
    }

    @NotNull
    public abstract List<ScratchExpression> getExpressions(@NotNull PsiFile var1);

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TextEditor getEditor() {
        return this.editor;
    }

    public ScratchFile(@NotNull Project project, @NotNull TextEditor editor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.project = project;
        this.editor = editor;
    }
}

