/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run.multiplatform;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.MultipleRunLocationsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.SourceType;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;
import org.jetbrains.kotlin.idea.run.multiplatform.KotlinMultiplatformRunLocationsProviderKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/run/multiplatform/KotlinMultiplatformRunLocationsProvider;", "Lcom/intellij/execution/actions/MultipleRunLocationsProvider;", "()V", "getAlternativeLocations", "", "Lcom/intellij/execution/Location;", "originalLocation", "getLocationDisplayName", "", "locationCreatedFrom", "idea-jvm"})
public final class KotlinMultiplatformRunLocationsProvider
extends MultipleRunLocationsProvider {
    @Nullable
    public String getLocationDisplayName(@NotNull Location<?> locationCreatedFrom, @NotNull Location<?> originalLocation) {
        Intrinsics.checkParameterIsNotNull(locationCreatedFrom, (String)"locationCreatedFrom");
        Intrinsics.checkParameterIsNotNull(originalLocation, (String)"originalLocation");
        Module module = locationCreatedFrom.getModule();
        if (module == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"locationCreatedFrom.module ?: return null");
        Module module2 = module;
        StringBuilder stringBuilder = new StringBuilder().append('[');
        String string = KotlinMultiplatformRunLocationsProviderKt.access$compactedGradleProjectId(module2);
        if (string == null) {
            String string2 = module2.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"module.name");
        }
        return stringBuilder.append(string).append(']').toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location<?>> getAlternativeLocations(@NotNull Location<?> originalLocation) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(originalLocation, (String)"originalLocation");
        Module module = originalLocation.getModule();
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"originalLocation.module ?: return emptyList()");
        Module originalModule = module;
        VirtualFile virtualFile2 = originalLocation.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"originalLocation.virtualFile ?: return emptyList()");
        VirtualFile virtualFile3 = virtualFile2;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)originalModule);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(originalModule)");
        ModuleFileIndex moduleFileIndex = moduleRootManager.getFileIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleFileIndex, (String)"ModuleRootManager.getIns\u2026originalModule).fileIndex");
        SourceType sourceType = FileIndexUtilsKt.getSourceType((FileIndex)((FileIndex)moduleFileIndex), (VirtualFile)virtualFile3);
        if (sourceType == null) {
            return CollectionsKt.emptyList();
        }
        SourceType sourceType2 = sourceType;
        Iterable iterable = $receiver$iv = (Iterable)KotlinMultiplatformRunLocationsProviderKt.access$modulesToRunFrom(originalModule, sourceType2);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Module module2 = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            PsiLocation psiLocation = new PsiLocation(originalLocation.getProject(), (Module)it, originalLocation.getPsiElement());
            collection.add(psiLocation);
        }
        return (List)destination$iv$iv;
    }
}

