/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.run.LocalFileHyperlinkInfo;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinConsoleFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "Companion", "idea-jvm"})
public final class KotlinConsoleFilter
implements Filter {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope scope;
    private static final Regex pattern;
    public static final Companion Companion;

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        MatchResult matchResult = Regex.find$default((Regex)pattern, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult messageSuffix = matchResult;
        MatchGroup matchGroup = messageSuffix.getGroups().get(1);
        if (matchGroup == null) {
            Intrinsics.throwNpe();
        }
        int pathEnd = matchGroup.getRange().getLast() + 1;
        String string = line;
        int n = 0;
        String string2 = string.substring(n, pathEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String pathWithPrefix = string2;
        Integer n2 = StringsKt.indexOf$default((CharSequence)pathWithPrefix, (String)":\\", (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n2).intValue();
        Integer n3 = it >= 0 ? n2 : null;
        Integer n4 = n3 != null ? Integer.valueOf(n3 - 1) : ((it = ((Number)(n2 = Integer.valueOf(StringsKt.indexOf$default((CharSequence)pathWithPrefix, (String)"/", (int)0, (boolean)false, (int)6, null)))).intValue()) >= 0 ? n2 : null);
        if (n4 == null) {
            return null;
        }
        int pathStart = n4;
        String string3 = it = pathWithPrefix;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(pathStart);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String path = string4;
        int lineNumber = Integer.parseInt((String)messageSuffix.getGroupValues().get(2)) - 1;
        int column = Integer.parseInt((String)messageSuffix.getGroupValues().get(3)) - 1;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        TextAttributes attrs = editorColorsManager.getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
        int offset = entireLength - line.length();
        return new Filter.Result(offset + pathStart, offset + messageSuffix.getRange().getLast(), (HyperlinkInfo)new LocalFileHyperlinkInfo(path, lineNumber, column), attrs);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GlobalSearchScope getScope() {
        return this.scope;
    }

    public KotlinConsoleFilter(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
    }

    static {
        Companion = new Companion(null);
        pattern = new Regex("(\\.kts?): \\((\\d+), (\\d+)\\):");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinConsoleFilter$Companion;", "", "()V", "pattern", "Lkotlin/text/Regex;", "idea-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

