/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;

public class PsiExpressionTrimRenderer
extends JavaRecursiveElementWalkingVisitor {
    private final StringBuilder myBuf;

    public PsiExpressionTrimRenderer(StringBuilder buf) {
        this.myBuf = buf;
    }

    @Override
    public void visitExpression(PsiExpression expression) {
        this.myBuf.append(expression.getText());
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        expression.getOperand().accept(this);
        this.myBuf.append(" ").append("instanceof").append(" ");
        PsiTypeElement checkType = expression.getCheckType();
        if (checkType != null) {
            this.myBuf.append(checkType.getText());
        }
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        this.myBuf.append("(");
        PsiExpression expr = expression.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        this.myBuf.append(")");
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        PsiExpression operand;
        PsiTypeElement castType = expression.getCastType();
        if (castType != null) {
            this.myBuf.append("(").append(castType.getText()).append(")");
        }
        if ((operand = expression.getOperand()) != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        expression.getArrayExpression().accept(this);
        this.myBuf.append("[");
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
        }
        this.myBuf.append("]");
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression) {
        this.myBuf.append(expression.getOperationSign().getText());
        PsiExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitPostfixExpression(PsiPostfixExpression expression) {
        expression.getOperand().accept(this);
        this.myBuf.append(expression.getOperationSign().getText());
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        PsiExpression[] operands = expression.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            if (i != 0) {
                PsiJavaToken token = expression.getTokenBeforeOperand(operand);
                this.myBuf.append(" ").append(token.getText()).append(" ");
            }
            operand.accept(this);
        }
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression) {
        PsiParameterList parameterList = expression.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        PsiElement firstChild = parameterList.getFirstChild();
        boolean addParenthesis = PsiUtil.isJavaToken(firstChild, JavaTokenType.LPARENTH);
        if (addParenthesis) {
            this.myBuf.append('(');
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiTypeElement typeElement;
            PsiParameter parameter = parameters[i];
            if (i != 0) {
                this.myBuf.append(", ");
            }
            int formatOptions = 1 | ((typeElement = parameter.getTypeElement()) == null ? 0 : 2);
            this.myBuf.append(PsiFormatUtil.formatVariable(parameter, formatOptions, PsiSubstitutor.EMPTY));
        }
        if (addParenthesis) {
            this.myBuf.append(')');
        }
        this.myBuf.append(" -> {...}");
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression) {
        expression.getCondition().accept(this);
        this.myBuf.append(" ? ");
        PsiExpression thenExpression = expression.getThenExpression();
        if (thenExpression != null) {
            thenExpression.accept(this);
        }
        this.myBuf.append(" : ");
        PsiExpression elseExpression = expression.getElseExpression();
        if (elseExpression != null) {
            elseExpression.accept(this);
        }
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        expression.getLExpression().accept(this);
        this.myBuf.append(expression.getOperationSign().getText());
        PsiExpression rExpression = expression.getRExpression();
        if (rExpression != null) {
            rExpression.accept(this);
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expr) {
        PsiExpression qualifierExpression = expr.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifierExpression.accept(this);
            this.myBuf.append(".");
        }
        this.myBuf.append(expr.getReferenceName());
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expr) {
        expr.getMethodExpression().accept(this);
        expr.getArgumentList().accept(this);
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        PsiElement qualifier = expression.getQualifier();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
        }
        this.myBuf.append("::");
        this.myBuf.append(expression.getReferenceName());
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        this.myBuf.append("{");
        boolean first = true;
        for (PsiExpression expr : expression.getInitializers()) {
            if (!first) {
                this.myBuf.append(", ");
            }
            first = false;
            expr.accept(this);
        }
        this.myBuf.append("}");
    }

    @Override
    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] args = list.getExpressions();
        if (args.length > 0) {
            this.myBuf.append("(...)");
        } else {
            this.myBuf.append("()");
        }
    }

    @Override
    public void visitNewExpression(PsiNewExpression expr) {
        PsiAnonymousClass anonymousClass = expr.getAnonymousClass();
        PsiExpressionList argumentList = expr.getArgumentList();
        if (anonymousClass != null) {
            this.myBuf.append("new").append(" ").append(anonymousClass.getBaseClassType().getPresentableText());
            if (argumentList != null) {
                argumentList.accept(this);
            }
            this.myBuf.append(" {...}");
        } else {
            PsiJavaCodeReferenceElement reference = expr.getClassReference();
            if (reference != null) {
                PsiArrayInitializerExpression arrayInitializer;
                int dimensions;
                this.myBuf.append("new").append(" ").append(reference.getText());
                PsiExpression[] arrayDimensions = expr.getArrayDimensions();
                PsiType type = expr.getType();
                int n = dimensions = type != null ? type.getArrayDimensions() : arrayDimensions.length;
                if (arrayDimensions.length > 0) {
                    this.myBuf.append("[");
                }
                int arrayDimensionsLength = arrayDimensions.length;
                for (int i = 0; i < dimensions; ++i) {
                    PsiExpression dimension;
                    PsiExpression psiExpression = dimension = i < arrayDimensionsLength ? arrayDimensions[i] : null;
                    if (i > 0) {
                        this.myBuf.append("][");
                    }
                    if (dimension == null) continue;
                    dimension.accept(this);
                }
                if (arrayDimensions.length > 0) {
                    this.myBuf.append("]");
                }
                if (argumentList != null) {
                    argumentList.accept(this);
                }
                if ((arrayInitializer = expr.getArrayInitializer()) != null) {
                    arrayInitializer.accept(this);
                }
            } else {
                this.myBuf.append(expr.getText());
            }
        }
    }

    public static String render(PsiExpression expression) {
        return PsiExpressionTrimRenderer.render(expression, 100);
    }

    public static String render(PsiExpression expression, int maxLength) {
        StringBuilder buf = new StringBuilder();
        expression.accept(new PsiExpressionTrimRenderer(buf));
        String text = buf.toString();
        int firstNewLinePos = text.indexOf(10);
        String trimmedText = text.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(maxLength, text.length()));
        if (trimmedText.length() != text.length()) {
            trimmedText = trimmedText + " ...";
        }
        return trimmedText;
    }

    public static class RenderFunction
    implements Function<PsiExpression, String> {
        public String fun(PsiExpression psiExpression) {
            return PsiExpressionTrimRenderer.render(psiExpression);
        }
    }
}

