/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter.java2groovy;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.hash.HashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class OldReferencesResolver {
    private static final Logger LOG = Logger.getInstance(OldReferencesResolver.class);
    private final GrCall myContext;
    private final GrExpression myExpr;
    private final HashMap<GrExpression, String> myTempVars;
    private final GrExpression myInstanceRef;
    private final GrClosureSignatureUtil.ArgInfo<PsiElement>[] myActualArgs;
    private final PsiElement myToReplaceIn;
    private final Project myProject;
    private final int myReplaceFieldsWithGetters;
    private final PsiElement myParameterInitializer;
    private final PsiManager myManager;
    private final PsiParameter[] myParameters;
    private final GrClosureSignature mySignature;
    private final Set<PsiParameter> myParamsToNotInline = new HashSet();

    public OldReferencesResolver(GrCall context, GrExpression expr, PsiElement toReplaceIn, int replaceFieldsWithGetters, PsiElement parameterInitializer, GrClosureSignature signature, GrClosureSignatureUtil.ArgInfo<PsiElement>[] actualArgs, PsiParameter[] parameters) throws IncorrectOperationException {
        GrMethodCallExpression methodCall;
        GrExpression methodExpression;
        this.myContext = context;
        this.myExpr = expr;
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
        this.myParameterInitializer = parameterInitializer;
        this.myParameters = parameters;
        this.myTempVars = new HashMap();
        this.mySignature = signature;
        this.myActualArgs = actualArgs;
        this.myToReplaceIn = toReplaceIn;
        this.myProject = this.myContext.getProject();
        this.myManager = this.myContext.getManager();
        this.myInstanceRef = this.myContext instanceof GrMethodCallExpression ? ((methodExpression = (methodCall = (GrMethodCallExpression)this.myContext).getInvokedExpression()) instanceof GrReferenceExpression ? ((GrReferenceExpression)methodExpression).getQualifierExpression() : (methodExpression instanceof GrMethodCall ? OldReferencesResolver.getQualifierFromGetterCall((GrMethodCall)methodExpression) : null)) : null;
    }

    @Nullable
    private static GrExpression getQualifierFromGetterCall(GrMethodCall methodExpression) {
        GroovyResolveResult result2 = methodExpression.advancedResolve();
        if (!(result2.getElement() instanceof GrAccessorMethod) || result2.isInvokedOnProperty()) {
            return null;
        }
        GrExpression invoked = methodExpression.getInvokedExpression();
        if (invoked instanceof GrReferenceExpression) {
            return (GrExpression)((GrReferenceExpression)invoked).getQualifier();
        }
        return null;
    }

    public void resolve() throws IncorrectOperationException {
        this.resolveOldReferences(this.myExpr, this.myParameterInitializer);
        Set<Map.Entry<GrExpression, String>> mappingsSet = this.myTempVars.entrySet();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        for (Map.Entry<GrExpression, String> entry : mappingsSet) {
            GrExpression oldRef = entry.getKey();
            GrExpression newRef = factory.createExpressionFromText(entry.getValue());
            oldRef.replace(newRef);
        }
    }

    private void resolveOldReferences(PsiElement expr, PsiElement oldExpr) throws IncorrectOperationException {
        block23: {
            PsiElement[] newChildren;
            PsiElement[] oldChildren;
            PsiElement newExpr;
            block22: {
                if (expr == null || !expr.isValid() || oldExpr == null) {
                    return;
                }
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
                newExpr = expr;
                if (oldExpr instanceof GrReferenceExpression) {
                    if (this.isThisReferenceToContainingClass(oldExpr) || OldReferencesResolver.isSimpleSuperReference(oldExpr)) {
                        if (this.myInstanceRef != null) {
                            newExpr.replace((PsiElement)this.getInstanceRef(factory));
                        }
                        return;
                    }
                    GrReferenceExpression oldRef = (GrReferenceExpression)oldExpr;
                    newExpr = newExpr.replace((PsiElement)OldReferencesResolver.decodeReferenceExpression((GrReferenceExpression)newExpr, oldRef));
                    GroovyResolveResult adv = oldRef.advancedResolve();
                    PsiElement scope = OldReferencesResolver.getClassContainingResolve(adv);
                    PsiClass owner = PsiUtil.getContextClass(oldExpr);
                    if (this.myToReplaceIn instanceof GrClosableBlock || owner != null && scope != null && PsiTreeUtil.isContextAncestor((PsiElement)owner, (PsiElement)scope, (boolean)false)) {
                        PsiElement subj = adv.getElement();
                        if (subj instanceof PsiParameter) {
                            int index = ArrayUtil.indexOf((Object[])this.myParameters, (Object)subj);
                            if (index < 0) {
                                return;
                            }
                            if (index < this.myParameters.length) {
                                newExpr = this.inlineParam(newExpr, this.getActualArg(index), (PsiParameter)subj);
                            }
                        } else if ((subj instanceof PsiField || subj instanceof PsiMethod) && oldRef.getQualifierExpression() == null) {
                            PsiElement newResolved;
                            PsiElement psiElement = newResolved = newExpr instanceof GrReferenceExpression ? ((GrReferenceExpression)newExpr).resolve() : null;
                            if (this.myInstanceRef != null || !subj.getManager().areElementsEquivalent(newResolved, subj)) {
                                boolean isStatic = subj instanceof PsiField && ((PsiField)subj).hasModifierProperty("static") || subj instanceof PsiMethod && ((PsiMethod)subj).hasModifierProperty("static");
                                String name = GroovyRefactoringUtil.getNewName((PsiNamedElement)subj, adv.isInvokedOnProperty());
                                boolean shouldBeAt = subj instanceof PsiField && !PsiTreeUtil.isAncestor((PsiElement)((PsiMember)subj).getContainingClass(), (PsiElement)newExpr, (boolean)true) && GroovyPropertyUtils.findGetterForField((PsiField)subj) != null;
                                GrReferenceExpression fromText = factory.createReferenceExpressionFromText("qualifier." + (shouldBeAt ? "@" : "") + name);
                                if (isStatic) {
                                    GrReferenceExpression qualifier = factory.createReferenceElementForClass(((PsiMember)subj).getContainingClass());
                                    newExpr = newExpr.replace((PsiElement)fromText);
                                    ((GrReferenceExpression)newExpr).setQualifier(qualifier);
                                    newExpr = ((GrReferenceExpression)newExpr).getReferenceNameElement();
                                } else if (this.myInstanceRef != null) {
                                    GrExpression instanceRef = this.getInstanceRef(factory);
                                    fromText.setQualifier(instanceRef);
                                    newExpr = newExpr.replace((PsiElement)fromText);
                                    newExpr = ((GrReferenceExpression)newExpr).getReferenceNameElement();
                                }
                            }
                        }
                        if (subj instanceof PsiField && this.myReplaceFieldsWithGetters != 0 && (this.myReplaceFieldsWithGetters == 2 || this.myReplaceFieldsWithGetters == 1 && !JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().isAccessible((PsiMember)subj, newExpr, null))) {
                            newExpr = OldReferencesResolver.replaceFieldWithGetter(newExpr, (PsiField)subj);
                        }
                    }
                } else {
                    GrExpression[] qualifiedName;
                    PsiReference ref;
                    PsiClass refClass = (PsiClass)oldExpr.getCopyableUserData(ChangeContextUtil.REF_CLASS_KEY);
                    if (refClass != null && refClass.isValid() && (ref = newExpr.getReference()) != null && (qualifiedName = refClass.getQualifiedName()) != null && JavaPsiFacade.getInstance((Project)refClass.getProject()).findClass((String)qualifiedName, oldExpr.getResolveScope()) != null) {
                        newExpr = ref.bindToElement((PsiElement)refClass);
                    }
                }
                oldChildren = oldExpr.getChildren();
                newChildren = newExpr.getChildren();
                if (!(oldExpr instanceof GrNewExpression) || !(newExpr instanceof GrNewExpression)) break block22;
                this.resolveOldReferences(((GrNewExpression)newExpr).getReferenceElement(), ((GrNewExpression)oldExpr).getReferenceElement());
                this.resolveOldReferences(((GrNewExpression)newExpr).getArgumentList(), ((GrNewExpression)oldExpr).getArgumentList());
                if (!(newChildren[1] instanceof GrArrayDeclaration)) break block23;
                for (GrExpression expression : ((GrArrayDeclaration)newChildren[1]).getBoundExpressions()) {
                    this.resolveOldReferences(expression, oldChildren[1]);
                }
                break block23;
            }
            if (oldExpr instanceof GrReferenceExpression && newExpr instanceof GrReferenceExpression) {
                GrExpression oldQualifier = ((GrReferenceExpression)oldExpr).getQualifierExpression();
                GrExpression newQualifier = ((GrReferenceExpression)newExpr).getQualifierExpression();
                if (oldQualifier != null && newQualifier != null) {
                    this.resolveOldReferences(newQualifier, oldQualifier);
                    return;
                }
            }
            if (oldChildren.length == newChildren.length) {
                for (int i = 0; i < newChildren.length; ++i) {
                    this.resolveOldReferences(newChildren[i], oldChildren[i]);
                }
            }
        }
    }

    private PsiElement inlineParam(PsiElement newExpr, GrExpression actualArg, PsiParameter parameter) {
        int copyingSafetyLevel;
        if (this.myParamsToNotInline.contains(parameter)) {
            return newExpr;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        if (this.myExpr instanceof GrClosableBlock) {
            int count = 0;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(this.myParameterInitializer))) {
                if (++count <= 1) continue;
                break;
            }
            if (count > 1) {
                this.myParamsToNotInline.add(parameter);
                PsiType type = parameter instanceof GrParameter ? ((GrParameter)parameter).getDeclaredType() : parameter.getType();
                GrVariableDeclaration declaration = factory.createVariableDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, actualArg, type, parameter.getName());
                GrStatement[] statements = ((GrClosableBlock)this.myExpr).getStatements();
                GrStatement anchor = statements.length > 0 ? statements[0] : null;
                return ((GrClosableBlock)this.myExpr).addStatementBefore(declaration, anchor);
            }
        }
        if ((copyingSafetyLevel = GroovyRefactoringUtil.verifySafeCopyExpression(actualArg)) == 2) {
            actualArg = factory.createExpressionFromText(this.getTempVar(actualArg));
        }
        newExpr = newExpr.replace((PsiElement)actualArg);
        return newExpr;
    }

    private static boolean isSimpleSuperReference(PsiElement oldExpr) {
        PsiElement nameElement;
        GrReferenceExpression ref;
        if (oldExpr instanceof GrReferenceExpression && (ref = (GrReferenceExpression)oldExpr).getQualifier() == null && (nameElement = ref.getReferenceNameElement()) != null) {
            return nameElement.getNode().getElementType() == GroovyTokenTypes.kSUPER;
        }
        return false;
    }

    private boolean isThisReferenceToContainingClass(PsiElement oldExpr) {
        if (!(oldExpr instanceof GrReferenceExpression) || !PsiUtil.isThisReference(oldExpr)) {
            return false;
        }
        GrReferenceExpression qualifier = (GrReferenceExpression)((GrReferenceExpression)oldExpr).getQualifier();
        if (qualifier == null) {
            return true;
        }
        PsiClass contextClass = PsiUtil.getContextClass(this.myToReplaceIn);
        PsiElement resolved = qualifier.resolve();
        return this.myManager.areElementsEquivalent(resolved, (PsiElement)contextClass);
    }

    @NotNull
    private GrExpression getActualArg(int index) {
        if (this.myActualArgs == null || this.myActualArgs[index] == null) {
            GrExpression[] arguments = this.myContext.getArgumentList().getExpressionArguments();
            if (index < arguments.length) {
                GrExpression grExpression = arguments[index];
                if (grExpression == null) {
                    OldReferencesResolver.$$$reportNull$$$0(0);
                }
                return grExpression;
            }
            GrClosableBlock[] closureArguments = this.myContext.getClosureArguments();
            if ((index -= arguments.length) < closureArguments.length) {
                GrClosableBlock grClosableBlock = closureArguments[index];
                if (grClosableBlock == null) {
                    OldReferencesResolver.$$$reportNull$$$0(1);
                }
                return grClosableBlock;
            }
            throw new IncorrectOperationException("fail :(");
        }
        GrClosureSignatureUtil.ArgInfo<PsiElement> argInfo = this.myActualArgs[index];
        List args = argInfo.args;
        if (argInfo.isMultiArg) {
            GrExpression grExpression = GroovyRefactoringUtil.generateArgFromMultiArg(this.mySignature.getSubstitutor(), args, this.myParameters[index].getType(), this.myContext.getProject());
            if (grExpression == null) {
                OldReferencesResolver.$$$reportNull$$$0(2);
            }
            return grExpression;
        }
        if (args.isEmpty()) {
            PsiParameter parameter = this.myParameters[index];
            LOG.assertTrue(parameter instanceof GrParameter);
            GrExpression initializer = ((GrParameter)parameter).getInitializerGroovy();
            LOG.assertTrue(initializer != null);
            GrExpression grExpression = (GrExpression)initializer.copy();
            if (grExpression == null) {
                OldReferencesResolver.$$$reportNull$$$0(3);
            }
            return grExpression;
        }
        GrExpression grExpression = (GrExpression)args.get(0);
        if (grExpression == null) {
            OldReferencesResolver.$$$reportNull$$$0(4);
        }
        return grExpression;
    }

    private GrExpression getInstanceRef(GroovyPsiElementFactory factory) throws IncorrectOperationException {
        int copyingSafetyLevel = GroovyRefactoringUtil.verifySafeCopyExpression(this.myInstanceRef);
        GrExpression instanceRef = this.myInstanceRef;
        if (copyingSafetyLevel == 2) {
            instanceRef = factory.createExpressionFromText(this.getTempVar(this.myInstanceRef));
        }
        return instanceRef;
    }

    private String getTempVar(GrExpression expr) throws IncorrectOperationException {
        String id = this.myTempVars.get(expr);
        if (id == null) {
            id = GroovyRefactoringUtil.createTempVar(expr, this.myContext, true);
            this.myTempVars.put(expr, id);
        }
        return id;
    }

    private static PsiElement replaceFieldWithGetter(PsiElement expr, PsiField psiField) throws IncorrectOperationException {
        if (RefactoringUtil.isAssignmentLHS((PsiElement)expr)) {
            return expr;
        }
        PsiElement newExpr = expr;
        PsiMethod getter = GroovyPropertyUtils.findGetterForField(psiField);
        if (getter != null && JavaPsiFacade.getInstance((Project)psiField.getProject()).getResolveHelper().isAccessible((PsiMember)getter, newExpr, null)) {
            GrExpression qualifierExpression;
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(newExpr.getProject());
            String id = getter.getName();
            PsiElement parent = newExpr.getParent();
            String qualifier = null;
            if (parent instanceof GrReferenceExpression && (qualifierExpression = ((GrReferenceExpression)parent).getQualifierExpression()) != null) {
                qualifier = qualifierExpression.getText();
            }
            GrExpression getterCall = PsiTreeUtil.isAncestor((PsiElement)psiField.getContainingClass(), (PsiElement)expr, (boolean)true) ? factory.createExpressionFromText((qualifier != null ? qualifier + "." : "") + id + "()") : factory.createExpressionFromText((qualifier != null ? qualifier + "." : "") + psiField.getName());
            newExpr = parent != null ? parent.replace((PsiElement)getterCall) : expr.replace((PsiElement)getterCall);
        }
        return newExpr;
    }

    @Nullable
    private static PsiElement getClassContainingResolve(GroovyResolveResult result2) {
        PsiElement elem = result2.getElement();
        if (elem != null) {
            if (elem instanceof PsiMember) {
                return ((PsiMember)elem).getContainingClass();
            }
            return PsiUtil.getContextClass(elem);
        }
        return null;
    }

    private static GrReferenceExpression decodeReferenceExpression(GrReferenceExpression newExpr, GrReferenceExpression refExpr) throws IncorrectOperationException {
        PsiManager manager = refExpr.getManager();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(manager.getProject());
        GrExpression qualifier = (GrExpression)refExpr.getQualifier();
        if (qualifier == null) {
            PsiMember refMember = (PsiMember)refExpr.getCopyableUserData(ChangeContextUtil.REF_MEMBER_KEY);
            refExpr.putCopyableUserData(ChangeContextUtil.REF_MEMBER_KEY, null);
            if (refMember != null && refMember.isValid()) {
                PsiElement refElement;
                PsiClass containingClass = refMember.getContainingClass();
                if (refMember.hasModifierProperty("static") && !manager.areElementsEquivalent((PsiElement)refMember, refElement = newExpr.resolve())) {
                    newExpr.setQualifier(factory.createReferenceExpressionFromText("" + containingClass.getQualifiedName()));
                }
            } else {
                PsiClass refClass = (PsiClass)refExpr.getCopyableUserData(ChangeContextUtil.REF_CLASS_KEY);
                refExpr.putCopyableUserData(ChangeContextUtil.REF_CLASS_KEY, null);
                if (refClass != null && refClass.isValid()) {
                    newExpr = (GrReferenceExpression)newExpr.bindToElement((PsiElement)refClass);
                }
            }
        } else {
            Boolean couldRemove = (Boolean)refExpr.getCopyableUserData(ChangeContextUtil.CAN_REMOVE_QUALIFIER_KEY);
            refExpr.putCopyableUserData(ChangeContextUtil.CAN_REMOVE_QUALIFIER_KEY, null);
            if (couldRemove == Boolean.FALSE && OldReferencesResolver.canRemoveQualifier(refExpr)) {
                GrReferenceExpression newRefExpr = (GrReferenceExpression)factory.createExpressionFromText(refExpr.getReferenceName());
                newExpr = (GrReferenceExpression)newExpr.replace(newRefExpr);
            }
        }
        return newExpr;
    }

    private static boolean canRemoveQualifier(GrReferenceExpression refExpr) {
        try {
            GrExpression qualifier = (GrExpression)refExpr.getQualifier();
            if (!(qualifier instanceof GrReferenceExpression)) {
                return false;
            }
            PsiElement qualifierRefElement = ((GrReferenceExpression)qualifier).resolve();
            if (!(qualifierRefElement instanceof PsiClass)) {
                return false;
            }
            PsiElement refElement = refExpr.resolve();
            if (refElement == null) {
                return false;
            }
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(refExpr.getProject());
            if (refExpr.getParent() instanceof GrMethodCallExpression) {
                GrMethodCallExpression methodCall = (GrMethodCallExpression)refExpr.getParent();
                GrMethodCallExpression newMethodCall = (GrMethodCallExpression)factory.createExpressionFromText(refExpr.getReferenceName() + "()", refExpr);
                newMethodCall.getArgumentList().replace(methodCall.getArgumentList());
                PsiElement newRefElement = ((GrReferenceExpression)newMethodCall.getInvokedExpression()).resolve();
                return refElement.equals(newRefElement);
            }
            GrReferenceExpression newRefExpr = (GrReferenceExpression)factory.createExpressionFromText(refExpr.getReferenceName(), refExpr);
            PsiElement newRefElement = newRefExpr.resolve();
            return refElement.equals(newRefElement);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/java2groovy/OldReferencesResolver", "getActualArg"));
    }
}

