/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public class GrFieldNameSuggester {
    private final GrIntroduceContext myContext;
    private final NameValidator myValidator;
    private final boolean myForStatic;

    public GrFieldNameSuggester(GrIntroduceContext context, NameValidator validator, boolean forStatic) {
        this.myContext = context;
        this.myValidator = validator;
        this.myForStatic = forStatic;
    }

    @NotNull
    public LinkedHashSet<String> suggestNames() {
        GrExpression expression = this.myContext.getExpression();
        GrVariable var = this.myContext.getVar();
        StringPartInfo stringPart = this.myContext.getStringPart();
        if (expression != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(GroovyNameSuggestionUtil.suggestVariableNames(expression, this.myValidator, this.myForStatic)));
            if (linkedHashSet == null) {
                GrFieldNameSuggester.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }
        if (stringPart != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(GroovyNameSuggestionUtil.suggestVariableNames(stringPart.getLiteral(), this.myValidator, this.myForStatic)));
            if (linkedHashSet == null) {
                GrFieldNameSuggester.$$$reportNull$$$0(1);
            }
            return linkedHashSet;
        }
        assert (var != null);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(GroovyNameSuggestionUtil.suggestVariableNameByType(var.getType(), this.myValidator)));
        if (linkedHashSet == null) {
            GrFieldNameSuggester.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrFieldNameSuggester", "suggestNames"));
    }
}

