/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.constant;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceFieldHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrInplaceConstantIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantSettings;

public class GrIntroduceConstantHandler
extends GrIntroduceFieldHandlerBase<GrIntroduceConstantSettings> {
    public static final String REFACTORING_NAME = "Introduce Constant";

    @Override
    @NotNull
    protected String getRefactoringName() {
        if (REFACTORING_NAME == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(0);
        }
        return REFACTORING_NAME;
    }

    @Override
    @NotNull
    protected String getHelpID() {
        if ("refactoring.introduceConstant" == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        return "refactoring.introduceConstant";
    }

    @Override
    protected void checkExpression(@NotNull GrExpression selectedExpr) {
        GrVariable variable;
        if (selectedExpr == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(2);
        }
        if ((variable = GrIntroduceHandlerBase.resolveLocalVar(selectedExpr)) != null) {
            this.checkVariable(variable);
        } else {
            selectedExpr.accept(new ConstantChecker(selectedExpr, selectedExpr));
        }
    }

    @Override
    protected void checkVariable(@NotNull GrVariable variable) throws GrRefactoringError {
        GrExpression initializer;
        if (variable == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(3);
        }
        if ((initializer = variable.getInitializerGroovy()) == null) {
            throw new GrRefactoringError(RefactoringBundle.message((String)"variable.does.not.have.an.initializer", (Object[])new Object[]{variable.getName()}));
        }
        this.checkExpression(initializer);
    }

    @Override
    protected void checkStringLiteral(@NotNull StringPartInfo info) throws GrRefactoringError {
        if (info == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(4);
        }
    }

    @Override
    protected void checkOccurrences(@NotNull PsiElement[] occurrences) {
        if (occurrences == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(5);
        }
        if (GrIntroduceConstantHandler.hasLhs(occurrences)) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("selected.variable.is.used.for.write", new Object[0]));
        }
    }

    @Nullable
    public static PsiClass findContainingClass(GrIntroduceContext context) {
        return (PsiClass)context.getScope();
    }

    @Override
    @NotNull
    protected GrIntroduceDialog<GrIntroduceConstantSettings> getDialog(@NotNull GrIntroduceContext context) {
        if (context == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(6);
        }
        GrIntroduceConstantDialog grIntroduceConstantDialog = new GrIntroduceConstantDialog(context, GrIntroduceConstantHandler.findContainingClass(context));
        if (grIntroduceConstantDialog == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(7);
        }
        return grIntroduceConstantDialog;
    }

    public GrField runRefactoring(@NotNull GrIntroduceContext context, @NotNull GrIntroduceConstantSettings settings) {
        if (context == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(9);
        }
        return new GrIntroduceConstantProcessor(context, settings).run();
    }

    @Override
    protected GrAbstractInplaceIntroducer<GrIntroduceConstantSettings> getIntroducer(@NotNull GrIntroduceContext context, @NotNull OccurrencesChooser.ReplaceChoice choice) {
        if (context == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(10);
        }
        if (choice == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(11);
        }
        Ref contextRef = Ref.create((Object)context);
        if (context.getStringPart() != null) {
            this.extractStringPart((Ref<GrIntroduceContext>)contextRef);
        }
        return new GrInplaceConstantIntroducer((GrIntroduceContext)contextRef.get(), choice);
    }

    @Override
    @NotNull
    protected Map<OccurrencesChooser.ReplaceChoice, List<Object>> getOccurrenceOptions(@NotNull GrIntroduceContext context) {
        if (context == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(12);
        }
        LinkedHashMap map2 = ContainerUtil.newLinkedHashMap();
        GrVariable localVar = GrIntroduceConstantHandler.resolveLocalVar(context);
        if (localVar != null) {
            map2.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(context.getOccurrences()));
            LinkedHashMap linkedHashMap = map2;
            if (linkedHashMap == null) {
                GrIntroduceConstantHandler.$$$reportNull$$$0(13);
            }
            return linkedHashMap;
        }
        if (context.getExpression() != null) {
            map2.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(context.getExpression()));
        } else if (context.getStringPart() != null) {
            map2.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(context.getStringPart()));
        }
        PsiElement[] occurrences = context.getOccurrences();
        if (occurrences.length > 1) {
            map2.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(occurrences));
        }
        LinkedHashMap linkedHashMap = map2;
        if (linkedHashMap == null) {
            GrIntroduceConstantHandler.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/constant/GrIntroduceConstantHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedExpr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpID";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/constant/GrIntroduceConstantHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialog";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrenceOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkStringLiteral";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkOccurrences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runRefactoring";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIntroducer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstantChecker
    extends GroovyRecursiveElementVisitor {
        private final PsiElement scope;
        private final GrExpression expr;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
            GrExpression qualifier;
            PsiElement resolved;
            if (referenceExpression == null) {
                ConstantChecker.$$$reportNull$$$0(0);
            }
            if ((resolved = referenceExpression.resolve()) instanceof PsiVariable) {
                if (ConstantChecker.isStaticFinalField((PsiVariable)resolved)) return;
                if (!(this.expr instanceof GrClosableBlock)) throw new GrRefactoringError(RefactoringBundle.message((String)"selected.expression.cannot.be.a.constant.initializer"));
                if (PsiTreeUtil.isContextAncestor((PsiElement)this.scope, (PsiElement)resolved, (boolean)true)) return;
                throw new GrRefactoringError(GroovyRefactoringBundle.message("closure.uses.external.variables", new Object[0]));
            }
            if (!(resolved instanceof PsiMethod) || ((PsiMethod)resolved).getContainingClass() == null || (qualifier = referenceExpression.getQualifierExpression()) != null && (!(qualifier instanceof GrReferenceExpression) || !(((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) || ((PsiMethod)resolved).hasModifierProperty("static")) return;
            throw new GrRefactoringError(RefactoringBundle.message((String)"selected.expression.cannot.be.a.constant.initializer"));
        }

        private static boolean isStaticFinalField(PsiVariable var) {
            return var instanceof PsiField && var.hasModifierProperty("final") && var.hasModifierProperty("static");
        }

        @Override
        public void visitClosure(@NotNull GrClosableBlock closure) {
            if (closure == null) {
                ConstantChecker.$$$reportNull$$$0(1);
            }
            if (closure == this.expr) {
                super.visitClosure(closure);
            } else {
                closure.accept(new ConstantChecker(closure, this.scope));
            }
        }

        private ConstantChecker(GrExpression expr, PsiElement expressionScope) {
            this.scope = expressionScope;
            this.expr = expr;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closure";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/constant/GrIntroduceConstantHandler$ConstantChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClosure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

