/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.surroundWith.TryCatchSurrounder;

public class TryCatchFinallySurrounder
extends TryCatchSurrounder {
    @Override
    public String getTemplateDescription() {
        return super.getTemplateDescription() + " / finally";
    }

    @Override
    protected GroovyPsiElement doSurroundElements(PsiElement[] elements, PsiElement context) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(elements[0].getProject());
        GrTryCatchStatement tryStatement = (GrTryCatchStatement)factory.createStatementFromText("try {\n} catch(exception e){\n} finally{\n}", context);
        GrOpenBlock block = tryStatement.getTryBlock();
        assert (block != null);
        TryCatchFinallySurrounder.addStatements(block, elements);
        return tryStatement;
    }
}

