/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GroovyManyStatementsSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            GroovyManyStatementsSurrounder.$$$reportNull$$$0(0);
        }
        if (elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            if (GroovyManyStatementsSurrounder.isStatement(element)) continue;
            return false;
        }
        return !(elements[0] instanceof GrBlockStatement);
    }

    public static boolean isStatement(@NotNull PsiElement element) {
        if (element == null) {
            GroovyManyStatementsSurrounder.$$$reportNull$$$0(1);
        }
        return ";".equals(element.getText()) || element instanceof PsiComment || StringUtil.isEmptyOrSpaces((String)element.getText()) || PsiUtil.isExpressionStatement(element);
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            GroovyManyStatementsSurrounder.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GroovyManyStatementsSurrounder.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            GroovyManyStatementsSurrounder.$$$reportNull$$$0(4);
        }
        if (elements.length == 0) {
            return null;
        }
        PsiElement element1 = elements[0];
        GroovyPsiElement newStmt = this.doSurroundElements(elements, element1.getParent());
        assert (newStmt != null);
        ASTNode parentNode = element1.getParent().getNode();
        if (elements.length > 1) {
            parentNode.removeRange(element1.getNode().getTreeNext(), elements[elements.length - 1].getNode().getTreeNext());
        }
        parentNode.replaceChild(element1.getNode(), newStmt.getNode());
        return this.getSurroundSelectionRange(newStmt);
    }

    protected static void addStatements(GrCodeBlock block, PsiElement[] elements) throws IncorrectOperationException {
        block.addRangeBefore(elements[0], elements[elements.length - 1], block.getRBrace());
    }

    protected abstract GroovyPsiElement doSurroundElements(PsiElement[] var1, PsiElement var2) throws IncorrectOperationException;

    protected abstract TextRange getSurroundSelectionRange(GroovyPsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/surroundWith/GroovyManyStatementsSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isStatement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

