/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ExpressionConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCallConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.TypeConstraint;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0000J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bJ\u0019\u0010\u0015\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\tH\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\tH\u0002J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSessionBuilder;", "", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "candidate", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/MethodCandidate;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/MethodCandidate;)V", "closureSkipList", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "left", "Lcom/intellij/psi/PsiType;", "siteTypeParams", "", "Lcom/intellij/psi/PsiTypeParameter;", "[Lcom/intellij/psi/PsiTypeParameter;", "skipClosureBlock", "", "startFromTop", "addReturnConstraint", "returnType", "addTypeParams", "typeParams", "([Lcom/intellij/psi/PsiTypeParameter;)Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSessionBuilder;", "build", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "canBeExitPoint", "element", "Lcom/intellij/psi/PsiElement;", "collectExitPoints", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "place", "getMostTopLevelCall", "call", "getReturnConstraintType", "isExitPoint", "resolveMode", "skipClosureIn", "intellij.groovy.psi"})
public final class GroovyInferenceSessionBuilder {
    private List<GrMethodCall> closureSkipList;
    private PsiType left;
    private boolean skipClosureBlock;
    private boolean startFromTop;
    private PsiTypeParameter[] siteTypeParams;
    private final GrReferenceExpression ref;
    private final MethodCandidate candidate;

    @NotNull
    public final GroovyInferenceSessionBuilder resolveMode(boolean skipClosureBlock) {
        this.skipClosureBlock = skipClosureBlock;
        return this;
    }

    @NotNull
    public final GroovyInferenceSessionBuilder startFromTop(boolean startFromTop) {
        this.startFromTop = startFromTop;
        return this;
    }

    @NotNull
    public final GroovyInferenceSessionBuilder skipClosureIn(@NotNull GrMethodCall call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        this.closureSkipList.add(call);
        return this;
    }

    @NotNull
    public final GroovyInferenceSessionBuilder addReturnConstraint(@Nullable PsiType returnType) {
        this.left = returnType;
        return this;
    }

    @NotNull
    public final GroovyInferenceSessionBuilder addReturnConstraint() {
        PsiElement psiElement = this.ref.getParent();
        if (!(psiElement instanceof GrMethodCall)) {
            psiElement = null;
        }
        GrMethodCall grMethodCall = (GrMethodCall)psiElement;
        if (grMethodCall == null) {
            return this;
        }
        GrMethodCall methodCall = grMethodCall;
        this.left = this.getReturnConstraintType(this.getMostTopLevelCall(methodCall));
        return this;
    }

    @NotNull
    public final GroovyInferenceSessionBuilder addTypeParams(@NotNull PsiTypeParameter[] typeParams) {
        Intrinsics.checkParameterIsNotNull((Object)typeParams, (String)"typeParams");
        Object[] objectArray = ArrayUtil.mergeArrays((Object[])this.siteTypeParams, (Object[])typeParams);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ArrayUtil.mergeArrays(siteTypeParams, typeParams)");
        this.siteTypeParams = (PsiTypeParameter[])objectArray;
        return this;
    }

    @NotNull
    public final GroovyInferenceSession build() {
        if (!this.startFromTop) {
            Object[] objectArray = ArrayUtil.mergeArrays((Object[])this.siteTypeParams, (Object[])this.candidate.getMethod().getTypeParameters());
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ArrayUtil.mergeArrays(si\u2026te.method.typeParameters)");
            PsiTypeParameter[] typeParameters = (PsiTypeParameter[])objectArray;
            GroovyInferenceSession session = new GroovyInferenceSession(typeParameters, this.candidate.getSiteSubstitutor(), this.ref, this.closureSkipList, this.skipClosureBlock);
            session.addConstraint(new MethodCallConstraint(this.ref, this.candidate));
            PsiType psiType = this.left;
            if (psiType == null) {
                return session;
            }
            PsiType left = psiType;
            PsiType returnType = PsiUtil.getSmartReturnType(this.candidate.getMethod());
            if (returnType == null || Intrinsics.areEqual((Object)PsiType.VOID, (Object)returnType)) {
                return session;
            }
            session.repeatInferencePhases();
            session.addConstraint(new TypeConstraint(left, returnType, this.ref));
            return session;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        GroovyInferenceSession session = new GroovyInferenceSession(this.siteTypeParams, psiSubstitutor, this.ref, this.closureSkipList, this.skipClosureBlock);
        PsiElement psiElement = this.ref.getParent();
        if (!(psiElement instanceof GrMethodCall)) {
            psiElement = null;
        }
        GrMethodCall grMethodCall = (GrMethodCall)psiElement;
        if (grMethodCall == null) {
            return session;
        }
        GrMethodCall methodCall = grMethodCall;
        session.addConstraint(new ExpressionConstraint(this.getMostTopLevelCall(methodCall), this.left));
        return session;
    }

    private final GrMethodCall getMostTopLevelCall(GrMethodCall call) {
        GrMethodCall topLevel = call;
        while (true) {
            GrMethodCall grMethodCall;
            PsiElement gparent;
            PsiElement parent;
            PsiElement psiElement = parent = topLevel.getParent();
            Object object = gparent = psiElement != null ? psiElement.getParent() : null;
            if (parent instanceof GrMethodCall) {
                grMethodCall = (GrMethodCall)parent;
            } else if (parent instanceof GrArgumentList && gparent instanceof GrMethodCall) {
                grMethodCall = (GrMethodCall)gparent;
            } else {
                return topLevel;
            }
            topLevel = grMethodCall;
        }
    }

    private final PsiType getReturnConstraintType(GrMethodCall call) {
        PsiElement parent;
        PsiElement psiElement = parent = call.getParent();
        PsiElement gparent = psiElement != null ? psiElement.getParent() : null;
        GrMethod parentMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, GrMethod.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class});
        if (parent instanceof GrReturnStatement && parentMethod != null) {
            return parentMethod.getReturnType();
        }
        if (this.isExitPoint(call) && parentMethod != null) {
            PsiType returnType = parentMethod.getReturnType();
            if (TypeConversionUtil.isVoidType((PsiType)returnType)) {
                return null;
            }
            return returnType;
        }
        if (parent instanceof GrAssignmentExpression && Intrinsics.areEqual((Object)call, (Object)((GrAssignmentExpression)parent).getRValue())) {
            PsiElement lValue = PsiUtil.skipParentheses(((GrAssignmentExpression)parent).getLValue(), false);
            return lValue instanceof GrExpression && !(lValue instanceof GrIndexProperty) ? ((GrExpression)lValue).getNominalType() : null;
        }
        if (parent instanceof GrArgumentList && gparent instanceof GrNewExpression) {
            GrNewExpression $receiver = (GrNewExpression)gparent;
            GroovyResolveResult groovyResolveResult = $receiver.advancedResolve();
            Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"advancedResolve()");
            GroovyResolveResult resolveResult = groovyResolveResult;
            if (resolveResult instanceof GroovyMethodResult) {
                PsiMethod psiMethod = ((GroovyMethodResult)resolveResult).getElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"resolveResult.element");
                PsiSubstitutor psiSubstitutor = ((GroovyMethodResult)resolveResult).getPartialSubstitutor();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"resolveResult.getPartialSubstitutor()");
                GrCodeReferenceElement grCodeReferenceElement = $receiver.getReferenceElement();
                if (grCodeReferenceElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)grCodeReferenceElement, (String)"referenceElement!!");
                MethodCandidate methodCandidate2 = new MethodCandidate(psiMethod, psiSubstitutor, InferenceKt.buildArguments(grCodeReferenceElement), call);
                Pair<PsiParameter, PsiType> pair = methodCandidate2.getArgumentMapping().get(new Argument(null, call));
                return pair != null ? (PsiType)pair.second : null;
            }
            return null;
        }
        if (parent instanceof GrVariable) {
            return ((GrVariable)parent).getDeclaredType();
        }
        return null;
    }

    private final boolean isExitPoint(GrMethodCall place) {
        return this.collectExitPoints(place).contains(place);
    }

    private final List<GrStatement> collectExitPoints(GrMethodCall place) {
        List<GrStatement> list;
        if (this.canBeExitPoint(place)) {
            GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(place);
            List<GrStatement> list2 = ControlFlowUtils.collectReturns(flowOwner);
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ControlFlowUtils.collectReturns(flowOwner)");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final boolean canBeExitPoint(PsiElement element) {
        for (PsiElement place = element; place != null; place = place.getParent()) {
            if (place instanceof GrMethod || place instanceof GrClosableBlock || place instanceof GrClassInitializer) {
                return true;
            }
            if (!(place instanceof GrThrowStatement) && !(place instanceof GrTypeDefinitionBody) && !(place instanceof GroovyFile)) continue;
            return false;
        }
        return false;
    }

    public GroovyInferenceSessionBuilder(@NotNull GrReferenceExpression ref, @NotNull MethodCandidate candidate) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
        this.ref = ref;
        this.candidate = candidate;
        GroovyInferenceSessionBuilder groovyInferenceSessionBuilder = this;
        groovyInferenceSessionBuilder.closureSkipList = list = (List)new ArrayList();
        this.skipClosureBlock = true;
        Intrinsics.checkExpressionValueIsNotNull((Object)PsiTypeParameter.EMPTY_ARRAY, (String)"PsiTypeParameter.EMPTY_ARRAY");
        this.siteTypeParams = PsiTypeParameter.EMPTY_ARRAY;
    }
}

