/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public class GrTypeParameterListImpl
extends GrStubElementBase<EmptyStub>
implements GrTypeParameterList,
StubBasedPsiElement<EmptyStub> {
    public GrTypeParameterListImpl(EmptyStub stub) {
        super(stub, (IStubElementType)GroovyElementTypes.TYPE_PARAMETER_LIST);
    }

    public GrTypeParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "Type parameter list";
    }

    @Override
    @NotNull
    public GrTypeParameter[] getTypeParameters() {
        GrTypeParameter[] grTypeParameterArray = (GrTypeParameter[])this.getStubOrPsiChildren(GroovyElementTypes.TYPE_PARAMETER, GrTypeParameter.ARRAY_FACTORY);
        if (grTypeParameterArray == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(1);
        }
        return grTypeParameterArray;
    }

    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        GrTypeParameter[] typeParameters = this.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameters[i].equals(typeParameter)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(2);
        }
        visitor2.visitTypeParameterList(this);
    }

    public PsiElement add(@NotNull PsiElement element) {
        if (element == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiTypeParameter)) {
            return super.add(element);
        }
        return this.addInternal(element.getNode(), element.getNode(), null, true).getPsi();
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        this.appendParenthesesIfNeeded();
        if (first == last && first.getPsi() instanceof PsiTypeParameter) {
            boolean hasParams;
            boolean bl = hasParams = this.getTypeParameters().length > 0;
            ASTNode _anchor = anchor == null ? (before.booleanValue() ? this.getLastChild().getNode() : this.getFirstChild().getNode()) : anchor;
            ASTNode node = super.addInternal(first, last, _anchor, before);
            if (hasParams) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor != null ? anchor : node);
            }
            return node;
        }
        return super.addInternal(first, last, anchor, before);
    }

    private void appendParenthesesIfNeeded() {
        GrModifierList list;
        PsiElement[] modifiers;
        PsiElement parent;
        PsiElement last;
        PsiElement first = this.getFirstChild();
        if (first == null) {
            this.getNode().addLeaf(GroovyTokenTypes.mLT, (CharSequence)"<", null);
        }
        if ((last = this.getLastChild()).getNode().getElementType() != GroovyTokenTypes.mGT) {
            this.getNode().addLeaf(GroovyTokenTypes.mGT, (CharSequence)">", null);
        }
        if ((parent = this.getParent()) instanceof GrMethod && (modifiers = (list = ((GrMethod)parent).getModifierList()).getModifiers()).length == 0) {
            list.setModifierProperty("def", true);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(4);
        }
        if (state == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(6);
        }
        if (!ResolveUtilKt.shouldProcessTypeParameters(processor)) {
            return true;
        }
        for (GrTypeParameter typeParameter : this.getTypeParameters()) {
            if (ResolveUtil.processElement(processor, (PsiNamedElement)typeParameter, state)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrTypeParameterListImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrTypeParameterListImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

