/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators;

import com.intellij.psi.PsiType;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrNumericBinaryExpressionTypeCalculator
implements NullableFunction<GrOperatorExpression, PsiType> {
    public static final GrNumericBinaryExpressionTypeCalculator INSTANCE = new GrNumericBinaryExpressionTypeCalculator();

    @Nullable
    public PsiType fun(GrOperatorExpression e) {
        GroovyResolveResult resolveResult = PsiImplUtil.extractUniqueResult(e.multiResolve(false));
        if (resolveResult.isApplicable() && !PsiUtil.isDGMMethod(resolveResult.getElement())) {
            return ResolveUtil.extractReturnTypeFromCandidate(resolveResult, e, new PsiType[]{e.getRightType()});
        }
        PsiType lType = e.getLeftType();
        PsiType rType = e.getRightType();
        if (TypesUtil.isNumericType(lType) && TypesUtil.isNumericType(rType)) {
            return this.inferNumericType(lType, rType, e);
        }
        return ResolveUtil.extractReturnTypeFromCandidate(resolveResult, e, new PsiType[]{rType});
    }

    @Nullable
    protected PsiType inferNumericType(@NotNull PsiType ltype, @NotNull PsiType rtype, GrOperatorExpression e) {
        if (ltype == null) {
            GrNumericBinaryExpressionTypeCalculator.$$$reportNull$$$0(0);
        }
        if (rtype == null) {
            GrNumericBinaryExpressionTypeCalculator.$$$reportNull$$$0(1);
        }
        return GrBinaryExpressionUtil.getDefaultNumericResultType(ltype, rtype, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ltype";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rtype";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/binaryCalculators/GrNumericBinaryExpressionTypeCalculator";
        objectArray[2] = "inferNumericType";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

