/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrLabeledStatementImpl
extends GroovyPsiElementImpl
implements GrLabeledStatement {
    public GrLabeledStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitLabeledStatement(this);
    }

    public String toString() {
        return "Labeled statement";
    }

    @NotNull
    public String getLabelName() {
        String string = this.getName();
        if (string == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement getLabel() {
        PsiElement label = this.findChildByType(GroovyTokenTypes.mIDENT);
        assert (label != null);
        PsiElement psiElement = label;
        if (psiElement == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @Override
    @Nullable
    public GrStatement getStatement() {
        return (GrStatement)this.findChildByClass(GrStatement.class);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        GrStatement statement;
        if (processor == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(4);
        }
        if (state == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(6);
        }
        return (statement = this.getStatement()) == null || statement == lastParent || statement.processDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this);
        if (localSearchScope == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(7);
        }
        return localSearchScope;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(8);
        }
        PsiElement labelElement = this.getLabel();
        PsiElement newLabel = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(name);
        labelElement.replace(newLabel);
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement label = this.getLabel();
        String string = label.getText();
        if (string == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.getLabel();
        if (psiElement == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameIdentifierGroovy();
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        GrStatement statement;
        if (child == null) {
            GrLabeledStatementImpl.$$$reportNull$$$0(11);
        }
        if ((statement = this.getStatement()) != null && child == statement.getNode()) {
            this.delete();
        } else {
            super.deleteChildInternal(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifierGroovy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

