/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureParameterInfo;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.template.expressions.StringParameterNameExpression;

public abstract class ClosureCompleter {
    private static final ExtensionPointName<ClosureCompleter> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.closureCompleter");

    @Nullable
    protected abstract List<ClosureParameterInfo> getParameterInfos(InsertionContext var1, PsiMethod var2, PsiSubstitutor var3, PsiElement var4);

    public static boolean runClosureCompletion(InsertionContext context, PsiMethod method, PsiSubstitutor substitutor, Document document, int offset, PsiElement parent) {
        for (ClosureCompleter completer : (ClosureCompleter[])EP_NAME.getExtensions()) {
            List<ClosureParameterInfo> parameterInfos = completer.getParameterInfos(context, method, substitutor, parent);
            if (parameterInfos == null) continue;
            ClosureCompleter.runClosureTemplate(context, document, offset, substitutor, method, parameterInfos);
            return true;
        }
        return false;
    }

    private static boolean runClosureTemplate(InsertionContext context, Document document, int offset, PsiSubstitutor substitutor, PsiMethod method, List<? extends ClosureParameterInfo> parameters) {
        document.insertString(offset, (CharSequence)"{\n}");
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
        GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)(offset + 1), GrClosableBlock.class, (boolean)false);
        if (closure == null) {
            return false;
        }
        ClosureCompleter.runTemplate(parameters, closure, substitutor, method, context.getProject(), context.getEditor());
        return true;
    }

    public static void runTemplate(List<? extends ClosureParameterInfo> parameters, GrClosableBlock block, PsiSubstitutor substitutor, PsiMethod method, final Project project, final Editor editor) {
        if (method instanceof ClsMethodImpl) {
            method = ((ClsMethodImpl)method).getSourceMirrorMethod();
        }
        assert (block.getArrow() == null);
        if (parameters.isEmpty()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        ArrayList paramTypes = ContainerUtil.newArrayList();
        for (ClosureParameterInfo closureParameterInfo : parameters) {
            String type = closureParameterInfo.getType();
            String name = closureParameterInfo.getName();
            if (type != null) {
                PsiType fromText = JavaPsiFacade.getElementFactory((Project)project).createTypeFromText(type, (PsiElement)method);
                PsiType substituted = substitutor.substitute(fromText);
                paramTypes.add(substituted);
                buffer.append(substituted.getCanonicalText()).append(" ");
            } else {
                buffer.append("def ");
            }
            buffer.append(name);
            buffer.append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length(), " ->}");
        final Document document = editor.getDocument();
        final PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        assert (psiFile != null);
        GrClosableBlock closure = GroovyPsiElementFactory.getInstance(project).createClosureFromText(buffer.toString());
        GrClosableBlock templateClosure = (GrClosableBlock)block.replaceWithExpression(closure, false);
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)templateClosure);
        int i = 0;
        for (GrParameter p : templateClosure.getParameters()) {
            GrTypeElement typeElement = p.getTypeElementGroovy();
            PsiElement nameIdentifier = p.getNameIdentifierGroovy();
            if (typeElement != null) {
                TypeConstraint[] typeConstraints = new TypeConstraint[]{SupertypeConstraint.create((PsiType)paramTypes.get(i++))};
                ChooseTypeExpression expression = new ChooseTypeExpression(typeConstraints, PsiManager.getInstance((Project)project), nameIdentifier.getResolveScope());
                builder.replaceElement((PsiElement)typeElement, (Expression)expression);
            } else {
                ChooseTypeExpression expression = new ChooseTypeExpression(TypeConstraint.EMPTY_ARRAY, PsiManager.getInstance((Project)project), nameIdentifier.getResolveScope());
                builder.replaceElement((PsiElement)p.getModifierList(), (Expression)expression);
            }
            builder.replaceElement(nameIdentifier, (Expression)new StringParameterNameExpression(nameIdentifier.getText()));
        }
        GrClosableBlock afterPostprocess = (GrClosableBlock)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)templateClosure);
        Template template = builder.buildTemplate();
        TextRange range = afterPostprocess.getTextRange();
        document.deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateEditingAdapter templateListener = new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    CaretModel caretModel = editor.getCaretModel();
                    int offset = caretModel.getOffset();
                    GrClosableBlock block1 = (GrClosableBlock)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)(offset - 1), GrClosableBlock.class, (boolean)false);
                    if (block1 != null) {
                        PsiElement arrow = block1.getArrow();
                        if (arrow != null) {
                            caretModel.moveToOffset(arrow.getTextRange().getEndOffset());
                        }
                        TextRange range1 = block1.getTextRange();
                        CodeStyleManager.getInstance((Project)project).reformatRange(block1.getParent(), range1.getStartOffset() - 1, range1.getEndOffset(), true);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/plugins/groovy/lang/completion/ClosureCompleter$1", "templateFinished"));
            }
        };
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(editor, template, (TemplateEditingListener)templateListener);
    }
}

