/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrRegex;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ConvertConcatenationToGstringIntention
extends Intention {
    private static final String END_BRACE = "}";
    private static final String START_BRACE = "${";

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPredicate myPredicate = new MyPredicate();
        if (myPredicate == null) {
            ConvertConcatenationToGstringIntention.$$$reportNull$$$0(0);
        }
        return myPredicate;
    }

    private static List<GrExpression> collectExpressions(PsiFile file, int offset) {
        ArrayList<GrExpression> expressions = new ArrayList<GrExpression>();
        ConvertConcatenationToGstringIntention._collect(file, offset, expressions);
        if (expressions.isEmpty()) {
            ConvertConcatenationToGstringIntention._collect(file, offset, expressions);
        }
        return expressions;
    }

    private static void _collect(PsiFile file, int offset, List<GrExpression> expressions) {
        PsiElement elementAtCaret = file.findElementAt(offset);
        GrExpression expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, GrExpression.class);
        while (expression != null) {
            if (MyPredicate.satisfied(expression)) {
                expressions.add(expression);
            } else if (!expressions.isEmpty()) break;
            expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, GrExpression.class);
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            ConvertConcatenationToGstringIntention.$$$reportNull$$$0(1);
        }
        return file;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            ConvertConcatenationToGstringIntention.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ConvertConcatenationToGstringIntention.$$$reportNull$$$0(3);
        }
        PsiFile file = element.getContainingFile();
        int offset = editor.getCaretModel().getOffset();
        List expressions = (List)ReadAction.compute(() -> ConvertConcatenationToGstringIntention.collectExpressions(file, offset));
        final Document document = editor.getDocument();
        if (expressions.size() == 1) {
            ConvertConcatenationToGstringIntention.invokeImpl((PsiElement)expressions.get(0), document);
        } else if (!expressions.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ConvertConcatenationToGstringIntention.invokeImpl((PsiElement)expressions.get(expressions.size() - 1), document);
                return;
            }
            IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)new Pass<GrExpression>(){

                public void pass(GrExpression selectedValue) {
                    ConvertConcatenationToGstringIntention.invokeImpl(selectedValue, document);
                }
            }, grExpression -> grExpression.getText());
        }
    }

    private static void invokeImpl(PsiElement element, Document document) {
        boolean isMultiline = ConvertConcatenationToGstringIntention.containsMultilineStrings((GrExpression)element);
        StringBuilder builder = new StringBuilder(element.getTextLength());
        if (element instanceof GrBinaryExpression) {
            ConvertConcatenationToGstringIntention.performIntention((GrBinaryExpression)element, builder, isMultiline);
        } else if (element instanceof GrLiteral) {
            ConvertConcatenationToGstringIntention.getOperandText((GrExpression)element, builder, isMultiline);
        } else {
            return;
        }
        String text = builder.toString();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
        GrExpression newExpr = factory.createExpressionFromText(GrStringUtil.addQuotes(text, true));
        CommandProcessor.getInstance().executeCommand(element.getProject(), () -> WriteAction.run(() -> {
            GrExpression expression = ((GrExpression)element).replaceWithExpression(newExpr, true);
            if (expression instanceof GrString) {
                GrStringUtil.removeUnnecessaryBracesInGString((GrString)expression);
            }
        }), null, null, document);
    }

    private static boolean containsMultilineStrings(GrExpression expr) {
        final Ref result2 = Ref.create((Object)false);
        expr.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitLiteralExpression(@NotNull GrLiteral literal) {
                if (literal == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (GrStringUtil.isMultilineStringLiteral(literal) && literal.getText().contains("\n")) {
                    result2.set((Object)true);
                }
            }

            @Override
            public void visitElement(@NotNull GroovyPsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!((Boolean)result2.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literal";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertConcatenationToGstringIntention$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)result2.get();
    }

    private static void performIntention(GrBinaryExpression expr, StringBuilder builder, boolean multiline) {
        GrExpression left = (GrExpression)PsiUtil.skipParentheses(expr.getLeftOperand(), false);
        GrExpression right = (GrExpression)PsiUtil.skipParentheses(expr.getRightOperand(), false);
        ConvertConcatenationToGstringIntention.getOperandText(left, builder, multiline);
        ConvertConcatenationToGstringIntention.getOperandText(right, builder, multiline);
    }

    private static void getOperandText(@Nullable GrExpression operand, StringBuilder builder, boolean multiline) {
        if (operand instanceof GrRegex) {
            for (GroovyPsiElement element : ((GrRegex)operand).getAllContentParts()) {
                if (element instanceof GrStringInjection) {
                    builder.append(element.getText());
                    continue;
                }
                if (!(element instanceof GrStringContent)) continue;
                if (GrStringUtil.isDollarSlashyString((GrLiteral)operand)) {
                    ConvertConcatenationToGstringIntention.processDollarSlashyContent(builder, multiline, element.getText());
                    continue;
                }
                ConvertConcatenationToGstringIntention.processSlashyContent(builder, multiline, element.getText());
            }
        } else if (operand instanceof GrString) {
            boolean isMultiline = GrStringUtil.isMultilineStringLiteral((GrLiteral)operand);
            for (GroovyPsiElement element : ((GrString)operand).getAllContentParts()) {
                if (element instanceof GrStringInjection) {
                    builder.append(element.getText());
                    continue;
                }
                if (!(element instanceof GrStringContent)) continue;
                if (isMultiline) {
                    ConvertConcatenationToGstringIntention.processMultilineGString(builder, element.getText());
                    continue;
                }
                ConvertConcatenationToGstringIntention.processSinglelineGString(builder, element.getText());
            }
        } else if (operand instanceof GrLiteral) {
            String text = GrStringUtil.removeQuotes(operand.getText());
            GrLiteral literal = (GrLiteral)operand;
            if (GrStringUtil.isSingleQuoteString(literal)) {
                ConvertConcatenationToGstringIntention.processSinglelineString(builder, text);
            } else if (GrStringUtil.isTripleQuoteString(literal)) {
                ConvertConcatenationToGstringIntention.processMultilineString(builder, text);
            } else if (GrStringUtil.isDoubleQuoteString(literal)) {
                ConvertConcatenationToGstringIntention.processSinglelineGString(builder, text);
            } else if (GrStringUtil.isTripleDoubleQuoteString(literal)) {
                ConvertConcatenationToGstringIntention.processMultilineGString(builder, text);
            } else if (GrStringUtil.isSlashyString(literal)) {
                ConvertConcatenationToGstringIntention.processSlashyContent(builder, multiline, text);
            } else if (GrStringUtil.isDollarSlashyString(literal)) {
                ConvertConcatenationToGstringIntention.processDollarSlashyContent(builder, multiline, text);
            }
        } else if (MyPredicate.satisfied(operand)) {
            ConvertConcatenationToGstringIntention.performIntention((GrBinaryExpression)operand, builder, multiline);
        } else if (!ConvertConcatenationToGstringIntention.isToStringMethod(operand, builder)) {
            builder.append(START_BRACE).append(operand == null ? "" : operand.getText()).append(END_BRACE);
        }
    }

    private static void processMultilineString(StringBuilder builder, String text) {
        int position = builder.length();
        GrStringUtil.escapeAndUnescapeSymbols(text, "$", "'\"", builder);
        GrStringUtil.fixAllTripleDoubleQuotes(builder, position);
    }

    private static void processSinglelineString(StringBuilder builder, String text) {
        GrStringUtil.escapeAndUnescapeSymbols(text, "$\"", "'", builder);
    }

    private static StringBuilder processSinglelineGString(StringBuilder builder, String text) {
        return builder.append(text);
    }

    private static void processMultilineGString(StringBuilder builder, String text) {
        StringBuilder raw = new StringBuilder(text);
        GrStringUtil.unescapeCharacters(raw, "\"", true);
        builder.append((CharSequence)raw);
    }

    private static void processDollarSlashyContent(StringBuilder builder, boolean multiline, String text) {
        GrStringUtil.escapeSymbolsForGString(text, !multiline, false, builder);
    }

    private static void processSlashyContent(StringBuilder builder, boolean multiline, String text) {
        String unescaped = GrStringUtil.unescapeSlashyString(text);
        GrStringUtil.escapeSymbolsForGString(unescaped, !multiline, false, builder);
    }

    private static boolean isToStringMethod(GrExpression operand, StringBuilder builder) {
        if (!(operand instanceof GrMethodCallExpression)) {
            return false;
        }
        GrExpression expression = ((GrMethodCallExpression)operand).getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)expression;
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        GroovyResolveResult[] results = refExpr.multiResolve(false);
        if (results.length != 1) {
            return false;
        }
        PsiElement element = results[0].getElement();
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiClass objectClass = JavaPsiFacade.getInstance((Project)operand.getProject()).findClass("java.lang.Object", operand.getResolveScope());
        if (objectClass == null) {
            return false;
        }
        PsiMethod[] toStringMethod = objectClass.findMethodsByName("toString", true);
        if (MethodSignatureUtil.isSubsignature((MethodSignature)toStringMethod[0].getHierarchicalMethodSignature(), (MethodSignature)method.getHierarchicalMethodSignature())) {
            builder.append(START_BRACE).append(qualifier.getText()).append(END_BRACE);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertConcatenationToGstringIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertConcatenationToGstringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPredicate
    implements PsiElementPredicate {
        private MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                MyPredicate.$$$reportNull$$$0(0);
            }
            return MyPredicate.satisfied(element);
        }

        public static boolean satisfied(PsiElement element) {
            if (MyPredicate.isApplicableLiteral(element)) {
                return true;
            }
            if (!(element instanceof GrBinaryExpression)) {
                return false;
            }
            GrBinaryExpression binaryExpression = (GrBinaryExpression)element;
            if (!GroovyTokenTypes.mPLUS.equals(binaryExpression.getOperationTokenType())) {
                return false;
            }
            if (ErrorUtil.containsError(element)) {
                return false;
            }
            PsiType type = binaryExpression.getType();
            if (type == null) {
                return false;
            }
            PsiClassType stringType = TypesUtil.createType("java.lang.String", element);
            PsiClassType gstringType = TypesUtil.createType("groovy.lang.GString", element);
            return TypeConversionUtil.isAssignable((PsiType)stringType, (PsiType)type) || TypeConversionUtil.isAssignable((PsiType)gstringType, (PsiType)type);
        }

        private static boolean isApplicableLiteral(PsiElement element) {
            if (!(element instanceof GrLiteral)) {
                return false;
            }
            GrLiteral literal = (GrLiteral)element;
            if (!(literal.getValue() instanceof String)) {
                return false;
            }
            IElementType literalType = GrLiteralImpl.getLiteralType(literal);
            return literalType != GroovyElementTypes.STRING_DQ && literalType != GroovyElementTypes.STRING_TDQ;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertConcatenationToGstringIntention$MyPredicate", "satisfiedBy"));
        }
    }
}

