/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.google.common.collect.Lists;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.JavaThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureProcessor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class CreateParameterForFieldIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.intentions.control.CreateParameterForFieldIntention");
    private static final Key<CachedValue<List<GrField>>> FIELD_CANDIDATES = Key.create((String)"Fields.candidates");

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        List<GrField> candidates;
        if (element == null) {
            CreateParameterForFieldIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CreateParameterForFieldIntention.$$$reportNull$$$0(1);
        }
        if ((candidates = CreateParameterForFieldIntention.findFieldCandidates(element)) != null) {
            CreateParameterForFieldIntention.performForConstructor(element, project, editor, candidates);
        } else {
            List<GrMethod> constructors = CreateParameterForFieldIntention.findConstructorCandidates(element);
            CreateParameterForFieldIntention.performForField(element, project, editor, constructors);
        }
    }

    private static void performForField(PsiElement element, Project project, Editor editor, List<GrMethod> constructors) {
        GrField field = (GrField)PsiTreeUtil.getParentOfType((PsiElement)element, GrField.class);
        if (constructors.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (GrMethod constructor : constructors) {
                CreateParameterForFieldIntention.addParameter(field, constructor, project);
            }
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(constructors).setRenderer((ListCellRenderer)new MethodCellRenderer(true)).setTitle(GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0])).setMovable(true).setItemsChosenCallback(values -> {
            ArrayList selectedValues = Lists.newArrayList((Iterable)values);
            selectedValues.sort((o1, o2) -> o2.getParameterList().getParametersCount() - o1.getParameterList().getParametersCount());
            CommandProcessor.getInstance().executeCommand(project, () -> {
                for (GrMethod selectedValue : selectedValues) {
                    LOG.assertTrue(selectedValue.isValid());
                    CreateParameterForFieldIntention.addParameter(field, selectedValue, project);
                }
            }, GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0]), null);
        }).createPopup().showInBestPositionFor(editor);
    }

    private static void performForConstructor(PsiElement element, Project project, Editor editor, List<GrField> candidates) {
        GrMethod constructor = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
        if (candidates.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (GrField candidate : candidates) {
                CreateParameterForFieldIntention.addParameter(candidate, constructor, project);
            }
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(candidates).setRenderer((ListCellRenderer)new DefaultPsiElementCellRenderer()).setTitle(GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0])).setMovable(true).setItemsChosenCallback(selectedValues -> CommandProcessor.getInstance().executeCommand(project, () -> {
            for (GrField selectedValue : selectedValues) {
                LOG.assertTrue(selectedValue.isValid());
                CreateParameterForFieldIntention.addParameter(selectedValue, constructor, project);
            }
        }, GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0]), null)).createPopup().showInBestPositionFor(editor);
    }

    private static void addParameter(final GrField selectedValue, final GrMethod constructor, final Project project) {
        ArrayList<GrParameterInfo> parameters = new ArrayList<GrParameterInfo>();
        GrParameter[] constructorParameters = constructor.getParameters();
        for (int i = 0; i < constructorParameters.length; ++i) {
            parameters.add(new GrParameterInfo(constructorParameters[i], i));
        }
        Object[] suggestedNames = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName((VariableKind)VariableKind.PARAMETER, (String)selectedValue.getName(), null, null).names;
        DefaultGroovyVariableNameValidator nameValidator = new DefaultGroovyVariableNameValidator(constructor, Collections.emptyList(), false);
        String parameterName = (String)ContainerUtil.find((Object[])suggestedNames, name -> !nameValidator.validateName((String)name, false).isEmpty());
        if (parameterName == null) {
            parameterName = nameValidator.validateName((String)suggestedNames[0], true);
        }
        parameters.add(new GrParameterInfo(parameterName, "null", "", selectedValue.getTypeGroovy(), -1, false));
        PsiClassType[] exceptionTypes = constructor.getThrowsList().getReferencedTypes();
        ThrownExceptionInfo[] thrownExceptionInfos = new ThrownExceptionInfo[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            new JavaThrownExceptionInfo(i, exceptionTypes[i]);
        }
        GrChangeInfoImpl grChangeInfo = new GrChangeInfoImpl(constructor, null, null, constructor.getName(), parameters, thrownExceptionInfos, false);
        final String finalParameterName = parameterName;
        GrChangeSignatureProcessor processor = new GrChangeSignatureProcessor(project, grChangeInfo){

            protected void performRefactoring(@NotNull UsageInfo[] usages) {
                if (usages == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.performRefactoring(usages);
                GrOpenBlock block = constructor.getBlock();
                LOG.assertTrue(block != null);
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
                String text = StringUtil.equals((CharSequence)selectedValue.getName(), (CharSequence)finalParameterName) ? "this." + selectedValue.getName() + " = " + finalParameterName : selectedValue.getName() + " = " + finalParameterName;
                GrStatement assignment = factory.createStatementFromText(text);
                GrStatement statement = block.addStatementBefore(assignment, null);
                GrReferenceExpression ref = (GrReferenceExpression)((GrAssignmentExpression)statement).getLValue();
                if (!PsiManager.getInstance((Project)project).areElementsEquivalent(ref.resolve(), (PsiElement)selectedValue)) {
                    PsiUtil.qualifyMemberReference(ref, selectedValue, selectedValue.getName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/plugins/groovy/intentions/control/CreateParameterForFieldIntention$1", "performRefactoring"));
            }
        };
        processor.run();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPredicate myPredicate = new MyPredicate();
        if (myPredicate == null) {
            CreateParameterForFieldIntention.$$$reportNull$$$0(2);
        }
        return myPredicate;
    }

    @Nullable
    private static List<GrField> findFieldCandidates(PsiElement element) {
        GrMethod constructor = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
        if (constructor == null || !constructor.isConstructor()) {
            return null;
        }
        if (constructor.getBlock() == null) {
            return null;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)constructor.getBlock(), (PsiElement)element, (boolean)false)) {
            return null;
        }
        PsiClass clazz = constructor.getContainingClass();
        if (!(clazz instanceof GrTypeDefinition)) {
            return null;
        }
        return CreateParameterForFieldIntention.findCandidatesCached(constructor, (GrTypeDefinition)clazz);
    }

    private static List<GrField> findCandidates(PsiMethod constructor, final GrTypeDefinition clazz) {
        GrOpenBlock block;
        final ArrayList<GrField> usedFields = new ArrayList<GrField>();
        GrOpenBlock grOpenBlock = block = constructor instanceof GrMethod ? ((GrMethod)constructor).getBlock() : null;
        if (block == null) {
            return usedFields;
        }
        final PsiManager manager = clazz.getManager();
        block.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof GrField && manager.areElementsEquivalent((PsiElement)((GrField)resolved).getContainingClass(), (PsiElement)clazz) && PsiUtil.isAccessedForWriting(referenceExpression)) {
                    usedFields.add((GrField)resolved);
                }
            }

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                if (typeDefinition == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                if (closure == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeDefinition";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "closure";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/CreateParameterForFieldIntention$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeDefinition";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClosure";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<GrField> fields = new ArrayList<GrField>();
        for (GrField field : clazz.getFields()) {
            if (field.getInitializerGroovy() != null || ContainerUtil.find(usedFields, o -> manager.areElementsEquivalent((PsiElement)o, (PsiElement)field)) != null) continue;
            fields.add(field);
        }
        return fields;
    }

    private static List<GrField> findCandidatesCached(PsiMethod constructor, GrTypeDefinition clazz) {
        CachedValue value = (CachedValue)constructor.getUserData(FIELD_CANDIDATES);
        if (value != null && value.getValue() != null) {
            return (List)value.getValue();
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)constructor.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(CreateParameterForFieldIntention.findCandidates(constructor, clazz), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}), false);
        constructor.putUserData(FIELD_CANDIDATES, (Object)cachedValue);
        return (List)cachedValue.getValue();
    }

    @Nullable
    private static List<GrMethod> findConstructorCandidates(PsiElement element) {
        GrField field = (GrField)PsiTreeUtil.getParentOfType((PsiElement)element, GrField.class);
        if (field == null) {
            return null;
        }
        return CreateParameterForFieldIntention.findConstructorCandidates(field, (GrTypeDefinition)field.getContainingClass());
    }

    private static List<GrMethod> findConstructorCandidates(GrField field, GrTypeDefinition psiClass) {
        ArrayList<GrMethod> result2 = new ArrayList<GrMethod>();
        PsiMethod[] constructors = psiClass.getConstructors();
        PsiManager manager = field.getManager();
        for (PsiMethod constructor : constructors) {
            List<GrField> fields = CreateParameterForFieldIntention.findCandidatesCached(constructor, psiClass);
            if (ContainerUtil.find(fields, grField -> manager.areElementsEquivalent((PsiElement)grField, (PsiElement)field)) == null) continue;
            result2.add((GrMethod)constructor);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/CreateParameterForFieldIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/CreateParameterForFieldIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyPredicate
    implements PsiElementPredicate {
        MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            List candidates;
            if (element == null) {
                MyPredicate.$$$reportNull$$$0(0);
            }
            if ((candidates = CreateParameterForFieldIntention.findFieldCandidates(element)) != null && !candidates.isEmpty()) {
                return true;
            }
            List constructors = CreateParameterForFieldIntention.findConstructorCandidates(element);
            return constructors != null && !constructors.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/CreateParameterForFieldIntention$MyPredicate", "satisfiedBy"));
        }
    }
}

