/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.aliasImport;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/aliasImport/AliasImportIntentionPredicate;", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "()V", "satisfiedBy", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.groovy"})
public final class AliasImportIntentionPredicate
implements PsiElementPredicate {
    public static final AliasImportIntentionPredicate INSTANCE;

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof GrReferenceExpression) {
            GroovyResolveResult groovyResolveResult = ((GrReferenceExpression)element).advancedResolve();
            Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"element.advancedResolve()");
            GroovyResolveResult result2 = groovyResolveResult;
            PsiElement psiElement = result2.getCurrentFileResolveContext();
            if (!(psiElement instanceof GrImportStatement)) {
                psiElement = null;
            }
            GrImportStatement grImportStatement = (GrImportStatement)psiElement;
            if (grImportStatement == null) {
                return false;
            }
            GrImportStatement context = grImportStatement;
            return context.isStatic() && !context.isAliasedImport();
        }
        if (element instanceof GrImportStatement) {
            if (!((GrImportStatement)element).isStatic() || ((GrImportStatement)element).isAliasedImport() || ((GrImportStatement)element).isOnDemand()) {
                return false;
            }
            GrCodeReferenceElement grCodeReferenceElement = ((GrImportStatement)element).getImportReference();
            if (grCodeReferenceElement == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)grCodeReferenceElement, (String)"element.importReference ?: return false");
            GrCodeReferenceElement reference = grCodeReferenceElement;
            return reference.resolve() instanceof PsiMember;
        }
        return false;
    }

    private AliasImportIntentionPredicate() {
    }

    static {
        AliasImportIntentionPredicate aliasImportIntentionPredicate;
        INSTANCE = aliasImportIntentionPredicate = new AliasImportIntentionPredicate();
    }
}

