/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.console.GroovyConsole;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class GrExecuteCommandAction
extends AnAction {
    public GrExecuteCommandAction() {
        super(AllIcons.Toolwindows.ToolWindowRun);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String command;
        if (e == null) {
            GrExecuteCommandAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (project == null || editor == null || virtualFile == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Document document = editor.getDocument();
        TextRange selectedRange = EditorUtil.getSelectionInAnyMode((Editor)editor);
        if (selectedRange.isEmpty()) {
            command = document.getText();
        } else {
            StringBuilder commandBuilder = new StringBuilder();
            PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (file instanceof GroovyFile) {
                GrImportStatement[] statements;
                for (GrImportStatement statement : statements = ((GroovyFile)file).getImportStatements()) {
                    if (selectedRange.contains(statement.getTextRange())) continue;
                    commandBuilder.append(statement.getText()).append("\n");
                }
            }
            commandBuilder.append(document.getText(selectedRange));
            command = commandBuilder.toString();
        }
        GroovyConsole existingConsole = (GroovyConsole)virtualFile.getUserData(GroovyConsole.GROOVY_CONSOLE);
        if (existingConsole == null) {
            GroovyConsole.getOrCreateConsole(project, virtualFile, (Consumer<? super GroovyConsole>)((Consumer)console -> console.execute(command)));
        } else {
            existingConsole.execute(command);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/console/actions/GrExecuteCommandAction", "actionPerformed"));
    }
}

