/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.style.JavaStylePropertiesInvocationFixer;
import org.jetbrains.plugins.groovy.codeInspection.utils.JavaStylePropertiesUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class JavaStylePropertiesInvocationInspection
extends BaseInspection {
    private static final LocalQuickFix[] myFixes = new LocalQuickFix[]{new JavaStylePropertiesInvocationFixer()};

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitMethodCall(@NotNull GrMethodCall methodCall) {
                if (methodCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JavaStylePropertiesUtil.isPropertyAccessor(methodCall)) {
                    String message = GroovyInspectionBundle.message("java.style.property.access", new Object[0]);
                    GrExpression expression = methodCall.getInvokedExpression();
                    if (expression instanceof GrReferenceExpression) {
                        PsiElement referenceNameElement = ((GrReferenceExpression)expression).getReferenceNameElement();
                        this.registerError(referenceNameElement, message, myFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/style/JavaStylePropertiesInvocationInspection$1", "visitMethodCall"));
            }
        };
        if (baseInspectionVisitor == null) {
            JavaStylePropertiesInvocationInspection.$$$reportNull$$$0(0);
        }
        return baseInspectionVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/style/JavaStylePropertiesInvocationInspection", "buildVisitor"));
    }
}

