/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrEqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        MyVisitor myVisitor = new MyVisitor();
        if (myVisitor == null) {
            GrEqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(0);
        }
        return myVisitor;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = GroovyInspectionBundle.message("equals.between.inconvertible.types.tooltip", args[0], args[1], args[2]);
        if (string == null) {
            GrEqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GrEqualsBetweenInconvertibleTypesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            IElementType tokenType;
            if (expression == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (!GroovyTokenSets.EQUALITY_OPERATORS.contains(tokenType = expression.getOperationTokenType())) {
                return;
            }
            PsiType leftType = expression.getLeftType();
            if (leftType == null) {
                return;
            }
            PsiType rightType = expression.getRightType();
            if (rightType == null) {
                return;
            }
            if (TypeUtils.areConvertible((PsiType)rightType, (PsiType)leftType)) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)leftType, (String)"java.lang.Number")) {
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Number")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Character")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.String")) {
                    return;
                }
            } else if (InheritanceUtil.isInheritor((PsiType)leftType, (String)"java.lang.Character")) {
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Number")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.String")) {
                    return;
                }
            } else if (InheritanceUtil.isInheritor((PsiType)leftType, (String)"java.lang.String")) {
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Number")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.Character")) {
                    return;
                }
                if (InheritanceUtil.isInheritor((PsiType)rightType, (String)"groovy.lang.GString")) {
                    return;
                }
            } else if (InheritanceUtil.isInheritor((PsiType)leftType, (String)"groovy.lang.GString") && InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.String")) {
                return;
            }
            this.registerError(expression.getOperationToken(), tokenType, leftType.getPresentableText(), rightType.getPresentableText());
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.processMethodCall(methodCallExpression);
        }

        @Override
        public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
            if (applicationStatement == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.processMethodCall(applicationStatement);
        }

        private void processMethodCall(GrMethodCall methodCall) {
            GrExpression invokedExpression = methodCall.getInvokedExpression();
            if (!(invokedExpression instanceof GrReferenceExpression)) {
                return;
            }
            String name = ((GrReferenceExpression)invokedExpression).getReferenceName();
            if (!"equals".equals(name)) {
                return;
            }
            PsiType leftType = PsiImplUtil.getQualifierType((GrReferenceExpression)invokedExpression);
            if (leftType == null) {
                return;
            }
            PsiType[] argumentTypes = PsiUtil.getArgumentTypes(methodCall.getArgumentList());
            if (argumentTypes == null || argumentTypes.length != 1) {
                return;
            }
            PsiType rightType = argumentTypes[0];
            if (rightType == null) {
                return;
            }
            PsiMethod method = methodCall.resolveMethod();
            if (!MethodUtils.isEquals((PsiMethod)method)) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            if (TypeUtils.areConvertible((PsiType)rightType, (PsiType)leftType)) {
                return;
            }
            this.registerMethodCallError(methodCall, "equals()", leftType.getPresentableText(), rightType.getPresentableText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCallExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applicationStatement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GrEqualsBetweenInconvertibleTypesInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitApplicationStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

