/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrCastFix
extends GroovyFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(GrCastFix.class);
    private final PsiType myExpectedType;
    private final boolean mySafe;

    public GrCastFix(PsiType expectedType, GrExpression expression) {
        this(expectedType, expression, true);
    }

    public GrCastFix(PsiType expectedType, GrExpression expression, boolean safe) {
        this.mySafe = safe;
        this.myExpectedType = PsiImplUtil.normalizeWildcardTypeByPosition(expectedType, expression);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        GrExpression cast;
        if (project == null) {
            GrCastFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            GrCastFix.$$$reportNull$$$0(1);
        }
        if ((cast = GrCastFix.findExpressionToCast(descriptor2)) == null) {
            return;
        }
        if (this.mySafe) {
            GrCastFix.doSafeCast(project, this.myExpectedType, cast);
        } else {
            GrCastFix.doCast(project, this.myExpectedType, cast);
        }
    }

    private static void doCast(Project project, PsiType type, GrExpression expr) {
        if (!type.isValid()) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrTypeCastExpression cast = (GrTypeCastExpression)factory.createExpressionFromText("(String)foo");
        GrTypeElement typeElement = factory.createTypeElement(type);
        GrExpression operand = cast.getOperand();
        if (operand == null) {
            return;
        }
        operand.replaceWithExpression(expr, true);
        cast.getCastTypeElement().replace(typeElement);
        GrExpression replaced = expr.replaceWithExpression(cast, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
    }

    private static GrExpression findExpressionToCast(ProblemDescriptor descriptor2) {
        PsiElement element = descriptor2.getPsiElement();
        PsiElement parent = element.getParent();
        if (parent instanceof GrVariable) {
            return ((GrVariable)parent).getInitializerGroovy();
        }
        if (parent instanceof GrAssignmentExpression) {
            return ((GrAssignmentExpression)parent).getRValue();
        }
        if (parent instanceof GrThrowStatement) {
            return ((GrThrowStatement)parent).getException();
        }
        if (parent instanceof GrReturnStatement) {
            return ((GrReturnStatement)parent).getReturnValue();
        }
        if (element instanceof GrExpression) {
            return (GrExpression)element;
        }
        if (parent instanceof GrForInClause) {
            return ((GrForInClause)parent).getIteratedExpression();
        }
        PsiFile file = element.getContainingFile();
        VirtualFile virtualFile = file.getVirtualFile();
        String url = virtualFile == null ? "" : virtualFile.getPresentableUrl();
        LOG.error("can't find expression to cast at position " + element.getTextRange(), new Attachment[]{new Attachment(url, file.getText())});
        return null;
    }

    static void doSafeCast(@NotNull Project project, @NotNull PsiType type, @NotNull GrExpression expr) {
        if (project == null) {
            GrCastFix.$$$reportNull$$$0(2);
        }
        if (type == null) {
            GrCastFix.$$$reportNull$$$0(3);
        }
        if (expr == null) {
            GrCastFix.$$$reportNull$$$0(4);
        }
        if (!type.isValid()) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrSafeCastExpression cast = (GrSafeCastExpression)factory.createExpressionFromText("foo as String");
        GrTypeElement typeElement = factory.createTypeElement(type);
        cast.getOperand().replaceWithExpression(expr, true);
        cast.getCastTypeElement().replace(typeElement);
        GrExpression replaced = expr.replaceWithExpression(cast, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
    }

    @NotNull
    public String getName() {
        String string = "Cast to " + this.myExpectedType.getPresentableText();
        if (string == null) {
            GrCastFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Add cast" == null) {
            GrCastFix.$$$reportNull$$$0(6);
        }
        return "Add cast";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doSafeCast";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

