/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.intellij.lang.annotations.JdkConstants;

public class TitledBorderWithMnemonic
extends TitledBorder {
    private final String myOriginalTitle;

    public TitledBorderWithMnemonic(String title) {
        this(null, title, 4, 0, null, null);
    }

    public TitledBorderWithMnemonic(Border border) {
        this(border, "", 4, 0, null, null);
    }

    public TitledBorderWithMnemonic(Border border, String title) {
        this(border, title, 4, 0, null, null);
    }

    public TitledBorderWithMnemonic(Border border, String title, @JdkConstants.TitledBorderJustification int titleJustification, @JdkConstants.TitledBorderTitlePosition int titlePosition) {
        this(border, title, titleJustification, titlePosition, null, null);
    }

    public TitledBorderWithMnemonic(Border border, String title, @JdkConstants.TitledBorderJustification int titleJustification, @JdkConstants.TitledBorderTitlePosition int titlePosition, Font titleFont) {
        this(border, title, titleJustification, titlePosition, titleFont, null);
    }

    public TitledBorderWithMnemonic(Border border, String title, @JdkConstants.TitledBorderJustification int titleJustification, @JdkConstants.TitledBorderTitlePosition int titlePosition, Font titleFont, Color titleColor) {
        super(border, title.replaceAll("&", ""), titleJustification, titlePosition, titleFont, titleColor);
        this.myOriginalTitle = title;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Point textLoc = new Point();
        Border border = this.getBorder();
        if (this.getTitle() == null || this.getTitle().length() == 0) {
            if (border != null) {
                border.paintBorder(c, g, x, y, width, height);
            }
            return;
        }
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        g.setFont(this.getFont(c));
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int stringWidth = fm.stringWidth(this.getTitle());
        Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        int titlePos = this.getTitlePosition();
        switch (titlePos) {
            case 1: {
                int diff = ascent + descent + (Math.max(2, 4) - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                textLoc.y = grooveRect.y - (descent + 2);
                break;
            }
            case 0: 
            case 2: {
                int diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
                break;
            }
            case 3: {
                textLoc.y = grooveRect.y + insets.top + ascent + 2;
                break;
            }
            case 4: {
                textLoc.y = grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
                break;
            }
            case 5: {
                grooveRect.height -= fontHeight / 2;
                textLoc.y = grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
                break;
            }
            case 6: {
                grooveRect.height -= fontHeight;
                textLoc.y = grooveRect.y + grooveRect.height + ascent + 2;
            }
        }
        int justification = this.getTitleJustification();
        if (c.getComponentOrientation().isLeftToRight()) {
            if (justification == 4 || justification == 0) {
                justification = 1;
            } else if (justification == 5) {
                justification = 3;
            }
        } else if (justification == 4 || justification == 0) {
            justification = 3;
        } else if (justification == 5) {
            justification = 1;
        }
        switch (justification) {
            case 1: {
                textLoc.x = grooveRect.x + 5 + insets.left;
                break;
            }
            case 3: {
                textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 5 + insets.right);
                break;
            }
            case 2: {
                textLoc.x = grooveRect.x + (grooveRect.width - stringWidth) / 2;
            }
        }
        if (border != null) {
            if ((titlePos == 2 || titlePos == 0) && grooveRect.y > textLoc.y - ascent || titlePos == 5 && grooveRect.y + grooveRect.height < textLoc.y + descent) {
                Rectangle clipRect = new Rectangle();
                Rectangle saveClip = g.getClipBounds();
                clipRect.setBounds(saveClip);
                if (TitledBorderWithMnemonic.computeIntersection2(clipRect, x, y, textLoc.x - 1 - x, height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                clipRect.setBounds(saveClip);
                if (TitledBorderWithMnemonic.computeIntersection2(clipRect, textLoc.x + stringWidth + 1, y, x + width - (textLoc.x + stringWidth + 1), height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                if (titlePos == 2 || titlePos == 0) {
                    clipRect.setBounds(saveClip);
                    if (TitledBorderWithMnemonic.computeIntersection2(clipRect, textLoc.x - 1, textLoc.y + descent, stringWidth + 2, y + height - textLoc.y - descent)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                } else {
                    clipRect.setBounds(saveClip);
                    if (TitledBorderWithMnemonic.computeIntersection2(clipRect, textLoc.x - 1, y, stringWidth + 2, textLoc.y - ascent - y)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                }
                g.setClip(saveClip);
            } else {
                border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
        }
        g.setColor(this.getTitleColor());
        g.drawString(this.getTitle(), textLoc.x, textLoc.y);
        int index2 = this.myOriginalTitle.indexOf(38);
        if (index2 != -1 && index2 != this.myOriginalTitle.length() - 1 && index2 == this.myOriginalTitle.lastIndexOf(38) && g instanceof Graphics2D) {
            int x0 = fm.stringWidth(this.getTitle().substring(0, index2));
            int x1 = fm.stringWidth(this.getTitle().substring(0, index2 + 1));
            ((Graphics2D)g).setPaint(this.getTitleColor());
            g.drawLine(textLoc.x + x0 - 1, textLoc.y + 1, textLoc.x + x1 - 1, textLoc.y + 1);
            ((Graphics2D)g).setPaint(color);
        }
        g.setFont(font);
        g.setColor(color);
    }

    private static boolean computeIntersection2(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }
}

