/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell.protocol;

import com.intellij.execution.jshell.protocol.Endpoint;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Base64;
import java.util.function.Consumer;

public class MessageReader<T>
extends Endpoint {
    private final BufferedReader myIn;
    private final Class<T> myMsgType;

    public MessageReader(InputStream input, Class<T> msgType) {
        this.myIn = new BufferedReader(new InputStreamReader(input));
        this.myMsgType = msgType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T receive(Consumer<? super String> unparsedOutputSink) throws IOException {
        String line;
        while ((line = this.myIn.readLine()) != null) {
            if ("__#begin#__".equals(line)) {
                StringBuilder buf = new StringBuilder();
                String body = this.myIn.readLine();
                while (!"__#end#__".equals(body.trim())) {
                    buf.append(body);
                    body = this.myIn.readLine();
                }
                byte[] bytes = Base64.getDecoder().decode(buf.toString());
                try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                    T t = this.myMsgType.cast(ois.readObject());
                    return t;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
            unparsedOutputSink.accept(line + "\n");
        }
        return null;
    }
}

