/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.FileUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.nativeintegration.EnvironmentModificationResult;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;

public class EstablishBuildEnvironment
extends BuildCommandOnly {
    private static final Logger LOGGER = Logging.getLogger(EstablishBuildEnvironment.class);
    private final ProcessEnvironment processEnvironment;

    public EstablishBuildEnvironment(ProcessEnvironment processEnvironment) {
        this.processEnvironment = processEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBuild(DaemonCommandExecution execution, Build build) {
        Properties originalSystemProperties = new Properties();
        originalSystemProperties.putAll((Map<?, ?>)System.getProperties());
        HashMap<String, String> originalEnv = new HashMap<String, String>(System.getenv());
        File originalProcessDir = FileUtils.canonicalize((File)new File("."));
        for (Map.Entry<String, String> entry : build.getParameters().getSystemProperties().entrySet()) {
            if (SystemProperties.getInstance().getStandardProperties().contains(entry.getKey()) || SystemProperties.getInstance().getNonStandardImportantProperties().contains(entry.getKey()) || entry.getKey().startsWith("sun.") || entry.getKey().startsWith("awt.") || entry.getKey().contains(".awt.")) continue;
            System.setProperty(entry.getKey(), entry.getValue());
        }
        LOGGER.debug("Configuring env variables: {}", build.getParameters().getEnvVariables());
        EnvironmentModificationResult setEnvironmentResult = this.processEnvironment.maybeSetEnvironment(build.getParameters().getEnvVariables());
        if (!setEnvironmentResult.isSuccess()) {
            LOGGER.warn("Warning: Unable able to set daemon's environment variables to match the client because: " + System.getProperty("line.separator") + "  " + setEnvironmentResult + System.getProperty("line.separator") + "  " + "If the daemon was started with a significantly different environment from the client, and your build " + System.getProperty("line.separator") + "  " + "relies on environment variables, you may experience unexpected behavior.");
        }
        this.processEnvironment.maybeSetProcessDir(build.getParameters().getCurrentDir());
        Locale locale = Locale.getDefault();
        try {
            execution.proceed();
        }
        finally {
            System.setProperties(originalSystemProperties);
            this.processEnvironment.maybeSetEnvironment(originalEnv);
            this.processEnvironment.maybeSetProcessDir(originalProcessDir);
            Locale.setDefault(locale);
        }
    }
}

