/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.ComponentItemDragObject;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.designSurface.VertInsertFeedbackPainter;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.ITabbedPane;
import com.intellij.uiDesigner.lw.IconDescriptor;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.LwTabbedPane;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.ReadOnlyProperty;
import com.intellij.uiDesigner.propertyInspector.editors.IconEditor;
import com.intellij.uiDesigner.propertyInspector.editors.string.StringEditor;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractBooleanProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroIconProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.IconRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.StringRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadComponentFactory;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RadTabbedPane
extends RadContainer
implements ITabbedPane {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.radComponents.RadTabbedPane");
    @NonNls
    private static final String CLIENT_PROP_ID_2_CONSTRAINTS = "index2descriptor";
    private int mySelectedIndex;
    private IntrospectedProperty mySelectedIndexProperty;

    public RadTabbedPane(ModuleProvider module, Class componentClass, String id) {
        super(module, componentClass, id);
        this.mySelectedIndex = -1;
        this.mySelectedIndexProperty = null;
    }

    public RadTabbedPane(Class componentClass, @NotNull String id, Palette palette) {
        if (id == null) {
            RadTabbedPane.$$$reportNull$$$0(0);
        }
        super(componentClass, id, palette);
        this.mySelectedIndex = -1;
        this.mySelectedIndexProperty = null;
    }

    @Override
    protected RadLayoutManager createInitialLayoutManager() {
        return new RadTabbedPaneLayoutManager();
    }

    @Override
    public RadComponent getComponentToDrag(Point pnt) {
        RadComponent c;
        int i = this.getTabbedPane().getUI().tabForCoordinate(this.getTabbedPane(), pnt.x, pnt.y);
        if (i >= 0 && (c = this.getRadComponent(i)) != null) {
            return c;
        }
        return this;
    }

    private RadComponent getRadComponent(int i) {
        RadComponent c = null;
        Component component = this.getTabbedPane().getComponentAt(i);
        if (component instanceof JComponent) {
            JComponent jc = (JComponent)component;
            c = (RadComponent)jc.getClientProperty("radComponent");
        }
        return c;
    }

    @Override
    public void init(GuiEditor editor, @NotNull ComponentItem item) {
        if (item == null) {
            RadTabbedPane.$$$reportNull$$$0(1);
        }
        super.init(editor, item);
        this.addComponent(InsertComponentProcessor.createPanelComponent(editor));
    }

    @NotNull
    private JTabbedPane getTabbedPane() {
        JTabbedPane jTabbedPane = (JTabbedPane)this.getDelegee();
        if (jTabbedPane == null) {
            RadTabbedPane.$$$reportNull$$$0(2);
        }
        return jTabbedPane;
    }

    private String calcTabName(StringDescriptor titleDescriptor) {
        if (titleDescriptor == null) {
            return UIDesignerBundle.message("tab.untitled", new Object[0]);
        }
        return this.getDescriptorText(titleDescriptor);
    }

    @Nullable
    private String getDescriptorText(@Nullable StringDescriptor titleDescriptor) {
        if (titleDescriptor == null) {
            return null;
        }
        String value = titleDescriptor.getValue();
        if (value == null) {
            String resolvedValue = StringDescriptorManager.getInstance(this.getModule()).resolve(this, titleDescriptor);
            titleDescriptor.setResolvedValue(resolvedValue);
            return resolvedValue;
        }
        return value;
    }

    @Override
    public Property getInplaceProperty(int x, int y) {
        JTabbedPane tabbedPane = this.getTabbedPane();
        TabbedPaneUI ui = tabbedPane.getUI();
        LOG.assertTrue(ui != null);
        int index = ui.tabForCoordinate(tabbedPane, x, y);
        return index != -1 ? new MyTitleProperty(null, index) : null;
    }

    @Override
    @Nullable
    public Property getDefaultInplaceProperty() {
        int index = this.getTabbedPane().getSelectedIndex();
        if (index >= 0) {
            return new MyTitleProperty(null, index);
        }
        return null;
    }

    @Override
    public Rectangle getInplaceEditorBounds(Property property, int x, int y) {
        JTabbedPane tabbedPane = this.getTabbedPane();
        TabbedPaneUI ui = tabbedPane.getUI();
        LOG.assertTrue(ui != null);
        int index = ui.tabForCoordinate(tabbedPane, x, y);
        LOG.assertTrue(index != -1);
        return ui.getTabBounds(tabbedPane, index);
    }

    @Override
    @Nullable
    public Rectangle getDefaultInplaceEditorBounds() {
        JTabbedPane tabbedPane = this.getTabbedPane();
        int index = tabbedPane.getSelectedIndex();
        if (index >= 0) {
            return tabbedPane.getUI().getTabBounds(tabbedPane, index);
        }
        return null;
    }

    @Nullable
    public StringDescriptor getChildTitle(RadComponent component) {
        HashMap<String, LwTabbedPane.Constraints> id2Constraints = RadTabbedPane.getId2Constraints(this);
        LwTabbedPane.Constraints constraints = id2Constraints.get(component.getId());
        return constraints == null ? null : constraints.myTitle;
    }

    public void setTabProperty(RadComponent component, String propName, StringDescriptor title) throws Exception {
        JComponent delegee = component.getDelegee();
        JTabbedPane tabbedPane = this.getTabbedPane();
        int index = tabbedPane.indexOfComponent(delegee);
        if (index >= 0) {
            if (propName.equals("Tab Title")) {
                new MyTitleProperty(null, index).setValue(component, title);
            } else if (propName.equals("Tab Tooltip")) {
                new MyToolTipProperty(null, index).setValue(component, title);
            } else {
                throw new IllegalArgumentException("Invalid property name " + propName);
            }
        }
    }

    @Override
    public void processMouseEvent(MouseEvent event) {
        event.getComponent().dispatchEvent(event);
    }

    @Override
    public void write(XmlWriter writer) {
        writer.startElement("tabbedpane");
        try {
            this.writeId(writer);
            this.writeClassIfDifferent(writer, JTabbedPane.class.getName());
            this.writeBinding(writer);
            this.writeConstraints(writer);
            this.writeProperties(writer);
            this.writeBorder(writer);
            this.writeChildren(writer);
        }
        finally {
            writer.endElement();
        }
    }

    @NotNull
    private static HashMap<String, LwTabbedPane.Constraints> getId2Constraints(RadComponent component) {
        HashMap<String, LwTabbedPane.Constraints> id2Constraints = (HashMap<String, LwTabbedPane.Constraints>)component.getClientProperty(CLIENT_PROP_ID_2_CONSTRAINTS);
        if (id2Constraints == null) {
            id2Constraints = new HashMap<String, LwTabbedPane.Constraints>();
            component.putClientProperty(CLIENT_PROP_ID_2_CONSTRAINTS, id2Constraints);
        }
        HashMap<String, LwTabbedPane.Constraints> hashMap = id2Constraints;
        if (hashMap == null) {
            RadTabbedPane.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @Nullable
    public RadComponent getSelectedTab() {
        int index = this.getTabbedPane().getSelectedIndex();
        return index < 0 ? null : this.getComponent(index);
    }

    public void selectTab(RadComponent component) {
        JTabbedPane tabbedPane = this.getTabbedPane();
        int index = tabbedPane.indexOfComponent(component.getDelegee());
        if (index >= 0) {
            tabbedPane.setSelectedIndex(index);
        }
    }

    public StringDescriptor getTabProperty(IComponent component, String propName) {
        HashMap<String, LwTabbedPane.Constraints> id2Constraints = RadTabbedPane.getId2Constraints(this);
        LwTabbedPane.Constraints constraints = id2Constraints.get(component.getId());
        return constraints == null ? null : constraints.getProperty(propName);
    }

    public boolean refreshChildTitle(RadComponent radComponent) {
        StringDescriptor childTitle = this.getChildTitle(radComponent);
        if (childTitle == null) {
            return false;
        }
        String oldTitle = childTitle.getResolvedValue();
        childTitle.setResolvedValue(null);
        try {
            this.setTabProperty(radComponent, "Tab Title", childTitle);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return !Comparing.equal((String)oldTitle, (String)childTitle.getResolvedValue());
    }

    @Override
    public void loadLwProperty(LwComponent lwComponent, LwIntrospectedProperty lwProperty, IntrospectedProperty property) {
        if (lwProperty.getName().equals("selectedIndex")) {
            this.mySelectedIndexProperty = property;
            this.mySelectedIndex = (Integer)lwProperty.getPropertyValue((IComponent)lwComponent);
        } else {
            super.loadLwProperty(lwComponent, lwProperty, property);
        }
    }

    @Override
    public void doneLoadingFromLw() {
        if (this.mySelectedIndex >= 0) {
            this.getTabbedPane().setSelectedIndex(this.mySelectedIndex);
            this.markPropertyAsModified(this.mySelectedIndexProperty);
        }
    }

    @Override
    protected void importSnapshotComponent(SnapshotContext context, JComponent component) {
        JTabbedPane tabbedPane = (JTabbedPane)component;
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            RadComponent childComponent;
            String title = tabbedPane.getTitleAt(i);
            Component child = tabbedPane.getComponentAt(i);
            if (!(child instanceof JComponent) || (childComponent = RadTabbedPane.createSnapshotComponent(context, (JComponent)child)) == null) continue;
            childComponent.setCustomLayoutConstraints(new LwTabbedPane.Constraints(StringDescriptor.create((String)title)));
            this.addComponent(childComponent);
        }
    }

    @NotNull
    private LwTabbedPane.Constraints getConstraintsForComponent(RadComponent tabComponent) {
        HashMap<String, LwTabbedPane.Constraints> id2Constraints = RadTabbedPane.getId2Constraints(this);
        LwTabbedPane.Constraints constraints = id2Constraints.get(tabComponent.getId());
        if (constraints == null) {
            int index = this.indexOfComponent(tabComponent);
            constraints = new LwTabbedPane.Constraints(StringDescriptor.create((String)this.getTabbedPane().getTitleAt(index)));
            id2Constraints.put(tabComponent.getId(), constraints);
        }
        LwTabbedPane.Constraints constraints2 = constraints;
        if (constraints2 == null) {
            RadTabbedPane.$$$reportNull$$$0(4);
        }
        return constraints2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/radComponents/RadTabbedPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/radComponents/RadTabbedPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabbedPane";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId2Constraints";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraintsForComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class InsertTabDropLocation
    implements ComponentDropLocation {
        private int myInsertIndex;
        private String myInsertBeforeId;
        private final Rectangle myFeedbackRect;

        InsertTabDropLocation(int insertIndex, Rectangle feedbackRect) {
            this.myInsertIndex = insertIndex;
            if (this.myInsertIndex < RadTabbedPane.this.getTabbedPane().getTabCount()) {
                this.myInsertBeforeId = RadTabbedPane.this.getRadComponent(this.myInsertIndex).getId();
            }
            this.myFeedbackRect = feedbackRect;
        }

        @Override
        public RadContainer getContainer() {
            return RadTabbedPane.this;
        }

        @Override
        public boolean canDrop(ComponentDragObject dragObject) {
            return dragObject.getComponentCount() == 1;
        }

        @Override
        public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
            String tooltipText = UIDesignerBundle.message("insert.feedback.add.tab", RadTabbedPane.this.getDisplayName(), this.myInsertIndex);
            if (this.myInsertIndex < RadTabbedPane.this.getTabbedPane().getTabCount()) {
                feedbackLayer.putFeedback(RadTabbedPane.this.getDelegee(), this.myFeedbackRect, VertInsertFeedbackPainter.INSTANCE, tooltipText);
            } else {
                Rectangle rcFeedback;
                JTabbedPane tabbedPane = RadTabbedPane.this.getTabbedPane();
                TabbedPaneUI ui = tabbedPane.getUI();
                if (tabbedPane.getTabCount() > 0) {
                    Rectangle rc = ui.getTabBounds(tabbedPane, tabbedPane.getTabCount() - 1);
                    rcFeedback = new Rectangle(rc.x + rc.width, rc.y, 50, rc.height);
                } else {
                    rcFeedback = new Rectangle(0, 0, 50, tabbedPane.getFontMetrics(tabbedPane.getFont()).getHeight() + 8);
                }
                feedbackLayer.putFeedback(RadTabbedPane.this.getDelegee(), rcFeedback, tooltipText);
            }
        }

        @Override
        public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
            RadComponent componentToAdd;
            if (this.myInsertBeforeId != null) {
                for (int i = 0; i < RadTabbedPane.this.getTabbedPane().getTabCount(); ++i) {
                    if (!RadTabbedPane.this.getRadComponent(i).getId().equals(this.myInsertBeforeId)) continue;
                    this.myInsertIndex = i;
                    break;
                }
            }
            if (this.myInsertIndex > RadTabbedPane.this.getTabbedPane().getTabCount()) {
                this.myInsertIndex = RadTabbedPane.this.getTabbedPane().getTabCount();
            }
            if ((componentToAdd = components[0]) instanceof RadContainer) {
                RadTabbedPane.this.addComponent(componentToAdd, this.myInsertIndex);
            } else {
                Palette palette = Palette.getInstance(editor.getProject());
                RadContainer panel = InsertComponentProcessor.createPanelComponent(editor);
                RadTabbedPane.this.addComponent(panel);
                panel.getDropLocation(null).processDrop(editor, new RadComponent[]{componentToAdd}, null, new ComponentItemDragObject(palette.getPanelItem()));
            }
            RadTabbedPane.this.getTabbedPane().setSelectedIndex(this.myInsertIndex);
        }

        @Override
        @Nullable
        public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
            return null;
        }
    }

    private class RadTabbedPaneLayoutManager
    extends RadLayoutManager {
        private RadTabbedPaneLayoutManager() {
        }

        @Override
        @Nullable
        public String getName() {
            return null;
        }

        @Override
        @NotNull
        public ComponentDropLocation getDropLocation(RadContainer container, @Nullable Point location) {
            JTabbedPane tabbedPane = RadTabbedPane.this.getTabbedPane();
            TabbedPaneUI ui = tabbedPane.getUI();
            if (location != null && tabbedPane.getTabCount() > 0) {
                for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                    Rectangle rc = ui.getTabBounds(tabbedPane, i);
                    if (!((double)location.x < rc.getCenterX())) continue;
                    InsertTabDropLocation insertTabDropLocation = new InsertTabDropLocation(i, new Rectangle(rc.x - 4, rc.y, 8, rc.height));
                    if (insertTabDropLocation == null) {
                        RadTabbedPaneLayoutManager.$$$reportNull$$$0(0);
                    }
                    return insertTabDropLocation;
                }
            }
            InsertTabDropLocation insertTabDropLocation = new InsertTabDropLocation(tabbedPane.getTabCount(), null);
            if (insertTabDropLocation == null) {
                RadTabbedPaneLayoutManager.$$$reportNull$$$0(1);
            }
            return insertTabDropLocation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeChildConstraints(XmlWriter writer, RadComponent child) {
            writer.startElement("tabbedpane");
            try {
                JComponent delegee = child.getDelegee();
                JTabbedPane tabbedPane = RadTabbedPane.this.getTabbedPane();
                int i = tabbedPane.indexOfComponent(delegee);
                if (i == -1) {
                    throw new IllegalArgumentException("cannot find tab for " + child);
                }
                HashMap id2Constraints = RadTabbedPane.getId2Constraints(RadTabbedPane.this);
                LwTabbedPane.Constraints tabTitleConstraints = (LwTabbedPane.Constraints)id2Constraints.get(child.getId());
                if (tabTitleConstraints != null) {
                    writer.writeStringDescriptor(tabTitleConstraints.myTitle, "title", "title-resource-bundle", "title-key");
                    if (tabTitleConstraints.myIcon != null) {
                        writer.addAttribute("icon", tabTitleConstraints.myIcon.getIconPath());
                    }
                    if (tabTitleConstraints.myDisabledIcon != null) {
                        writer.addAttribute("disabled-icon", tabTitleConstraints.myDisabledIcon.getIconPath());
                    }
                    if (!tabTitleConstraints.myEnabled) {
                        writer.addAttribute("enabled", false);
                    }
                    if (tabTitleConstraints.myToolTip != null) {
                        writer.startElement("tooltip");
                        writer.writeStringDescriptor(tabTitleConstraints.myToolTip, "value", "resource-bundle", "key");
                        writer.endElement();
                    }
                } else {
                    String title = tabbedPane.getTitleAt(i);
                    writer.addAttribute("title", title != null ? title : "");
                }
            }
            finally {
                writer.endElement();
            }
        }

        @Override
        public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
            JTabbedPane tabbedPane = RadTabbedPane.this.getTabbedPane();
            LwTabbedPane.Constraints constraints = null;
            if (component.getCustomLayoutConstraints() instanceof LwTabbedPane.Constraints) {
                constraints = (LwTabbedPane.Constraints)component.getCustomLayoutConstraints();
            }
            component.setCustomLayoutConstraints(null);
            HashMap id2Constraints = RadTabbedPane.getId2Constraints(RadTabbedPane.this);
            id2Constraints.put(component.getId(), constraints);
            String tabName = RadTabbedPane.this.calcTabName(constraints == null ? null : constraints.myTitle);
            String toolTip = null;
            Icon icon = null;
            if (constraints != null) {
                toolTip = RadTabbedPane.this.getDescriptorText(constraints.myToolTip);
                if (constraints.myIcon != null) {
                    IntroIconProperty.ensureIconLoaded(RadTabbedPane.this.getModule(), constraints.myIcon);
                    icon = constraints.myIcon.getIcon();
                }
            }
            tabbedPane.insertTab(tabName, icon, component.getDelegee(), toolTip, index);
            if (constraints != null) {
                if (constraints.myDisabledIcon != null) {
                    IntroIconProperty.ensureIconLoaded(RadTabbedPane.this.getModule(), constraints.myDisabledIcon);
                    tabbedPane.setDisabledIconAt(index, constraints.myDisabledIcon.getIcon());
                }
                tabbedPane.setEnabledAt(index, constraints.myEnabled);
            }
        }

        @Override
        public void removeComponentFromContainer(RadContainer container, RadComponent component) {
            LOG.debug("Removing component with ID " + component.getId());
            JTabbedPane tabbedPane = RadTabbedPane.this.getTabbedPane();
            JComponent delegee = component.getDelegee();
            int i = tabbedPane.indexOfComponent(delegee);
            if (i == -1) {
                throw new IllegalArgumentException("cannot find tab for " + component);
            }
            HashMap id2Constraints = RadTabbedPane.getId2Constraints(RadTabbedPane.this);
            LwTabbedPane.Constraints constraints = (LwTabbedPane.Constraints)id2Constraints.get(component.getId());
            if (constraints == null) {
                LOG.debug("title of removed component is null");
                constraints = new LwTabbedPane.Constraints(StringDescriptor.create((String)tabbedPane.getTitleAt(i)));
            } else {
                LOG.debug("title of removed component is " + constraints.myTitle.toString());
            }
            component.setCustomLayoutConstraints(constraints);
            id2Constraints.remove(component.getId());
            tabbedPane.removeTabAt(i);
        }

        @Override
        public Property[] getComponentProperties(Project project, RadComponent component) {
            JComponent delegee = component.getDelegee();
            JTabbedPane tabbedPane = RadTabbedPane.this.getTabbedPane();
            int index = tabbedPane.indexOfComponent(delegee);
            if (index >= 0) {
                return new Property[]{new MyTabGroupProperty(index)};
            }
            return Property.EMPTY_ARRAY;
        }

        @Override
        public boolean isSwitchedToChild(RadContainer container, RadComponent child) {
            return child == RadTabbedPane.this.getSelectedTab();
        }

        @Override
        public boolean switchContainerToChild(RadContainer container, RadComponent child) {
            RadTabbedPane.this.selectTab(child);
            return true;
        }

        @Override
        public boolean areChildrenExclusive() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadTabbedPane$RadTabbedPaneLayoutManager", "getDropLocation"));
        }
    }

    private class MyEnabledProperty
    extends AbstractBooleanProperty<RadComponent> {
        private final int myIndex;

        MyEnabledProperty(Property parent, int index) {
            super(parent, "Tab Enabled", true);
            this.myIndex = index;
        }

        @Override
        public Boolean getValue(RadComponent component) {
            LwTabbedPane.Constraints constraints = RadTabbedPane.this.getConstraintsForComponent(component);
            return constraints.myEnabled;
        }

        @Override
        protected void setValueImpl(RadComponent component, Boolean value) throws Exception {
            LwTabbedPane.Constraints constraints = RadTabbedPane.this.getConstraintsForComponent(component);
            constraints.myEnabled = value;
            RadTabbedPane.this.getTabbedPane().setEnabledAt(this.myIndex, value);
        }
    }

    private class MyIconProperty
    extends Property<RadComponent, IconDescriptor> {
        private final int myIndex;
        private final boolean myDisabledIcon;
        private final IconRenderer myRenderer;
        private final IconEditor myEditor;

        MyIconProperty(Property parent, int index, boolean disabledIcon) {
            super(parent, disabledIcon ? "Tab Disabled Icon" : "Tab Icon");
            this.myRenderer = new IconRenderer();
            this.myEditor = new IconEditor();
            this.myIndex = index;
            this.myDisabledIcon = disabledIcon;
        }

        @Override
        public IconDescriptor getValue(RadComponent component) {
            LwTabbedPane.Constraints constraints = RadTabbedPane.this.getConstraintsForComponent(component);
            return this.myDisabledIcon ? constraints.myDisabledIcon : constraints.myIcon;
        }

        @Override
        protected void setValueImpl(RadComponent component, IconDescriptor value) throws Exception {
            Icon icon = value != null ? value.getIcon() : null;
            LwTabbedPane.Constraints constraints = RadTabbedPane.this.getConstraintsForComponent(component);
            if (this.myDisabledIcon) {
                constraints.myDisabledIcon = value;
                RadTabbedPane.this.getTabbedPane().setDisabledIconAt(this.myIndex, icon);
            } else {
                constraints.myIcon = value;
                RadTabbedPane.this.getTabbedPane().setIconAt(this.myIndex, icon);
            }
        }

        @Override
        @NotNull
        public PropertyRenderer<IconDescriptor> getRenderer() {
            IconRenderer iconRenderer = this.myRenderer;
            if (iconRenderer == null) {
                MyIconProperty.$$$reportNull$$$0(0);
            }
            return iconRenderer;
        }

        @Override
        public PropertyEditor<IconDescriptor> getEditor() {
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadComponent radComponent) {
            return this.getValue(radComponent) != null;
        }

        @Override
        public void resetValue(RadComponent radComponent) throws Exception {
            this.setValue(radComponent, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadTabbedPane$MyIconProperty", "getRenderer"));
        }
    }

    private class MyToolTipProperty
    extends MyTitleProperty {
        protected MyToolTipProperty(Property parent, int index) {
            super(parent, "Tab Tooltip", index);
        }

        @Override
        protected String getValueFromTabbedPane() {
            return RadTabbedPane.this.getTabbedPane().getToolTipTextAt(this.myIndex);
        }

        @Override
        protected StringDescriptor getValueFromConstraints(LwTabbedPane.Constraints constraints) {
            return constraints.myToolTip;
        }

        @Override
        protected void putValueToTabbedPane(String text) {
            RadTabbedPane.this.getTabbedPane().setToolTipTextAt(this.myIndex, text);
        }

        @Override
        protected void putValueToConstraints(StringDescriptor value, LwTabbedPane.Constraints constraints) {
            constraints.myToolTip = value;
        }

        @Override
        public boolean isModified(RadComponent component) {
            String toolTipText = RadTabbedPane.this.getTabbedPane().getToolTipTextAt(this.myIndex);
            return !StringUtil.isEmpty((String)toolTipText);
        }

        @Override
        public void resetValue(RadComponent component) throws Exception {
            this.setValue(component, StringDescriptor.create((String)""));
        }
    }

    private class MyTitleProperty
    extends Property<RadComponent, StringDescriptor> {
        protected final int myIndex;
        private final StringEditor myEditor;
        private final StringRenderer myRenderer;

        MyTitleProperty(Property parent, int index) {
            super(parent, "Tab Title");
            this.myEditor = new StringEditor(RadTabbedPane.this.getProject());
            this.myRenderer = new StringRenderer();
            this.myIndex = index;
        }

        protected MyTitleProperty(@NonNls Property parent, String name, int index) {
            super(parent, name);
            this.myEditor = new StringEditor(RadTabbedPane.this.getProject());
            this.myRenderer = new StringRenderer();
            this.myIndex = index;
        }

        @Override
        public StringDescriptor getValue(RadComponent component) {
            StringDescriptor descriptor;
            RadComponent tabComponent = RadTabbedPane.this.getRadComponent(this.myIndex);
            LwTabbedPane.Constraints constraints = (LwTabbedPane.Constraints)RadTabbedPane.getId2Constraints(RadTabbedPane.this).get(tabComponent.getId());
            StringDescriptor stringDescriptor = descriptor = constraints == null ? null : this.getValueFromConstraints(constraints);
            if (descriptor != null) {
                return descriptor;
            }
            return StringDescriptor.create((String)this.getValueFromTabbedPane());
        }

        @Override
        protected void setValueImpl(RadComponent component, StringDescriptor value) throws Exception {
            RadComponent tabComponent = RadTabbedPane.this.getRadComponent(this.myIndex);
            if (value == null) {
                value = StringDescriptor.create((String)"");
            }
            LwTabbedPane.Constraints constraints = RadTabbedPane.this.getConstraintsForComponent(tabComponent);
            this.putValueToConstraints(value, constraints);
            String text = StringDescriptorManager.getInstance(RadTabbedPane.this.getModule()).resolve(RadTabbedPane.this, value);
            if (value.getValue() == null) {
                value.setResolvedValue(text);
            }
            this.putValueToTabbedPane(text);
        }

        protected String getValueFromTabbedPane() {
            return RadTabbedPane.this.getTabbedPane().getTitleAt(this.myIndex);
        }

        protected StringDescriptor getValueFromConstraints(LwTabbedPane.Constraints constraints) {
            return constraints.myTitle;
        }

        protected void putValueToTabbedPane(String text) {
            RadTabbedPane.this.getTabbedPane().setTitleAt(this.myIndex, text);
        }

        protected void putValueToConstraints(StringDescriptor value, LwTabbedPane.Constraints constraints) {
            constraints.myTitle = value;
        }

        @Override
        @NotNull
        public PropertyRenderer<StringDescriptor> getRenderer() {
            StringRenderer stringRenderer = this.myRenderer;
            if (stringRenderer == null) {
                MyTitleProperty.$$$reportNull$$$0(0);
            }
            return stringRenderer;
        }

        @Override
        public PropertyEditor<StringDescriptor> getEditor() {
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadComponent component) {
            return !RadTabbedPane.this.getTabbedPane().getTitleAt(this.myIndex).equals(UIDesignerBundle.message("tab.untitled", new Object[0]));
        }

        @Override
        public void resetValue(RadComponent component) throws Exception {
            this.setValue(component, StringDescriptor.create((String)UIDesignerBundle.message("tab.untitled", new Object[0])));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadTabbedPane$MyTitleProperty", "getRenderer"));
        }
    }

    private final class MyTabGroupProperty
    extends ReadOnlyProperty {
        private final int myIndex;
        private final LabelPropertyRenderer myRenderer;

        MyTabGroupProperty(int index) {
            super(null, "Tab");
            this.myRenderer = new LabelPropertyRenderer("");
            this.myIndex = index;
        }

        @NotNull
        public PropertyRenderer getRenderer() {
            LabelPropertyRenderer labelPropertyRenderer = this.myRenderer;
            if (labelPropertyRenderer == null) {
                MyTabGroupProperty.$$$reportNull$$$0(0);
            }
            return labelPropertyRenderer;
        }

        @Override
        @NotNull
        public Property[] getChildren(RadComponent component) {
            Property[] propertyArray = new Property[]{new MyTitleProperty(this, this.myIndex), new MyToolTipProperty(this, this.myIndex), new MyIconProperty(this, this.myIndex, false), new MyIconProperty(this, this.myIndex, true), new MyEnabledProperty(this, this.myIndex)};
            if (propertyArray == null) {
                MyTabGroupProperty.$$$reportNull$$$0(1);
            }
            return propertyArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/uiDesigner/radComponents/RadTabbedPane$MyTabGroupProperty";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Factory
    extends RadComponentFactory {
        @Override
        public RadComponent newInstance(ModuleProvider module, Class aClass, String id) {
            return new RadTabbedPane(module, aClass, id);
        }

        @Override
        public RadComponent newInstance(Class componentClass, String id, Palette palette) {
            return new RadTabbedPane(componentClass, id, palette);
        }
    }
}

