/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.renderers;

import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentRenderer
extends ColoredListCellRenderer
implements PropertyRenderer<String> {
    @Override
    public JComponent getComponent(RadRootContainer rootContainer, String value, boolean selected, boolean hasFocus) {
        this.clear();
        this.setBackground(selected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground());
        if (value != null && value.length() > 0) {
            RadComponent target = (RadComponent)FormEditingUtil.findComponent(rootContainer, value);
            if (target != null) {
                this.renderComponent(target, selected);
            } else {
                this.append(UIDesignerBundle.message("component.not.found", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }
        return this;
    }

    private void renderComponent(@Nullable RadComponent target, boolean selected) {
        SimpleTextAttributes baseAttributes;
        this.clear();
        SimpleTextAttributes simpleTextAttributes = baseAttributes = selected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
        if (target == null) {
            this.append(UIDesignerBundle.message("component.none", new Object[0]), baseAttributes);
            return;
        }
        this.setIcon(ComponentTree.getComponentIcon(target));
        String binding = target.getBinding();
        if (binding != null) {
            this.append(binding, baseAttributes);
        } else {
            String componentTitle = target.getComponentTitle();
            if (componentTitle != null && componentTitle.length() > "\"\"".length()) {
                this.append(componentTitle, baseAttributes);
            } else {
                this.append(target.getComponentClass().getSimpleName(), selected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }

    protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (list == null) {
            ComponentRenderer.$$$reportNull$$$0(0);
        }
        this.renderComponent((RadComponent)value, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/uiDesigner/propertyInspector/renderers/ComponentRenderer", "customizeCellRenderer"));
    }
}

