/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.propertyInspector.editors.AbstractTextFieldEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;

public class IntRegexEditor<T>
extends AbstractTextFieldEditor<T> {
    @NonNls
    private final Pattern myPattern;
    private final Class<T> myValueClass;
    private final LabelPropertyRenderer<T> myRenderer;
    private final int[] myMinValues;

    public IntRegexEditor(Class<T> valueClass, LabelPropertyRenderer<T> renderer, int[] minValues) {
        this.myMinValues = minValues;
        this.myValueClass = valueClass;
        this.myRenderer = renderer;
        StringBuilder regexBuilder = new StringBuilder("\\[?(-?\\d+)");
        for (int i = 1; i < this.myMinValues.length; ++i) {
            regexBuilder.append(",\\s*(-?\\d+)");
        }
        regexBuilder.append("\\]?");
        this.myPattern = Pattern.compile(regexBuilder.toString());
    }

    @Override
    protected void setValueFromComponent(RadComponent component, T value) {
        RadRootContainer root = (RadRootContainer)FormEditingUtil.getRoot(component);
        JComponent label = this.myRenderer.getComponent(root, (Object)value, false, false);
        this.myTf.setText(((JLabel)label).getText());
    }

    @Override
    public T getValue() throws Exception {
        Matcher matcher = this.myPattern.matcher(this.myTf.getText());
        if (!matcher.matches()) {
            throw new Exception("Incorrect dimension format");
        }
        Class[] paramTypes = new Class[this.myMinValues.length];
        Integer[] params = new Integer[this.myMinValues.length];
        for (int i = 0; i < this.myMinValues.length; ++i) {
            paramTypes[i] = Integer.TYPE;
            int value = Integer.parseInt(matcher.group(i + 1));
            if (value < this.myMinValues[i]) {
                throw new RuntimeException(UIDesignerBundle.message("error.value.should.not.be.less", this.myMinValues[i]));
            }
            params[i] = value;
        }
        return this.myValueClass.getConstructor(paramTypes).newInstance(params);
    }
}

