/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.palette.UIDesignerPaletteProvider;
import org.jetbrains.annotations.NotNull;

public class PaletteRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    private final UIDesignerPaletteProvider myUiDesignerPaletteProvider;

    public PaletteRefactoringListenerProvider(UIDesignerPaletteProvider uiDesignerPaletteProvider) {
        this.myUiDesignerPaletteProvider = uiDesignerPaletteProvider;
    }

    public RefactoringElementListener getListener(PsiElement element) {
        ComponentItem item;
        PsiClass psiClass;
        String oldName;
        if (element instanceof PsiClass && (oldName = ClassUtil.getJVMClassName((PsiClass)(psiClass = (PsiClass)element))) != null && (item = Palette.getInstance(element.getProject()).getItem(oldName)) != null) {
            return new MyRefactoringElementListener(item);
        }
        return null;
    }

    private class MyRefactoringElementListener
    extends RefactoringElementAdapter {
        private final ComponentItem myItem;

        MyRefactoringElementListener(ComponentItem item) {
            this.myItem = item;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            PsiClass psiClass;
            String qName;
            if (newElement == null) {
                MyRefactoringElementListener.$$$reportNull$$$0(0);
            }
            if ((qName = ClassUtil.getJVMClassName((PsiClass)(psiClass = (PsiClass)newElement))) != null) {
                this.myItem.setClassName(qName);
                PaletteRefactoringListenerProvider.this.myUiDesignerPaletteProvider.fireGroupsChanged();
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                MyRefactoringElementListener.$$$reportNull$$$0(1);
            }
            if (oldQualifiedName == null) {
                MyRefactoringElementListener.$$$reportNull$$$0(2);
            }
            this.myItem.setClassName(oldQualifiedName);
            PaletteRefactoringListenerProvider.this.myUiDesignerPaletteProvider.fireGroupsChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldQualifiedName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uiDesigner/palette/PaletteRefactoringListenerProvider$MyRefactoringElementListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementRenamedOrMoved";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "undoElementMovedOrRenamed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

