/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GeneratedCodeFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            GeneratedCodeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            GeneratedCodeFoldingBuilder.$$$reportNull$$$0(1);
        }
        MyFoldingVisitor visitor = new MyFoldingVisitor();
        root.accept((PsiElementVisitor)visitor);
        FoldingDescriptor[] foldingDescriptorArray = visitor.myFoldingData.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            GeneratedCodeFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            GeneratedCodeFoldingBuilder.$$$reportNull$$$0(3);
        }
        return UIDesignerBundle.message("uidesigner.generated.code.folding.placeholder.text", new Object[0]);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            GeneratedCodeFoldingBuilder.$$$reportNull$$$0(4);
        }
        return true;
    }

    private static boolean isGeneratedUIInitializer(PsiClassInitializer initializer) {
        PsiCodeBlock body = initializer.getBody();
        if (body.getStatementCount() != 1) {
            return false;
        }
        PsiStatement statement = body.getStatements()[0];
        if (!(statement instanceof PsiExpressionStatement) || !(((PsiExpressionStatement)statement).getExpression() instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)((PsiExpressionStatement)statement).getExpression();
        return "$$$setupUI$$$".equals(call.getMethodExpression().getReferenceName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/binding/GeneratedCodeFoldingBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/binding/GeneratedCodeFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFoldingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private PsiElement myLastElement;
        private final List<FoldingDescriptor> myFoldingData = new ArrayList<FoldingDescriptor>();

        private MyFoldingVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            if ("$$$setupUI$$$".equals(method.getName()) || "$$$getRootComponent$$$".equals(method.getName()) || "$$$loadButtonText$$$".equals(method.getName()) || "$$$loadLabelText$$$".equals(method.getName()) || "$$$getFont$$$".equals(method.getName())) {
                this.addFoldingData((PsiElement)method);
            }
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            if (GeneratedCodeFoldingBuilder.isGeneratedUIInitializer(initializer)) {
                this.addFoldingData((PsiElement)initializer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFoldingData(PsiElement element) {
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
            List<FoldingDescriptor> list = this.myFoldingData;
            synchronized (list) {
                if (this.myLastElement == null || prevSibling != this.myLastElement) {
                    this.myFoldingData.add(new FoldingDescriptor(element, element.getTextRange()));
                } else {
                    FoldingDescriptor lastDescriptor = this.myFoldingData.get(this.myFoldingData.size() - 1);
                    TextRange range = new TextRange(lastDescriptor.getRange().getStartOffset(), element.getTextRange().getEndOffset());
                    this.myFoldingData.set(this.myFoldingData.size() - 1, new FoldingDescriptor(lastDescriptor.getElement(), range));
                }
            }
            this.myLastElement = element;
        }
    }
}

