/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyInspector;
import com.intellij.uiDesigner.propertyInspector.PropertyInspectorTable;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.List;

public class ResetValueAction
extends AbstractGuiEditorAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.actions.ResetValueAction");

    @Override
    protected void actionPerformed(GuiEditor editor, List<? extends RadComponent> selection, AnActionEvent e) {
        PropertyInspectorTable inspector = (PropertyInspectorTable)((Object)PropertyInspectorTable.DATA_KEY.getData(e.getDataContext()));
        assert (inspector != null);
        Property property = inspector.getSelectedProperty();
        assert (property != null);
        ResetValueAction.doResetValue(selection, property, editor);
    }

    public static void doResetValue(List<? extends RadComponent> selection, Property property, GuiEditor editor) {
        try {
            if (!editor.ensureEditable()) {
                return;
            }
            PropertyInspector propertyInspector = DesignerToolWindowManager.getInstance(editor).getPropertyInspector();
            if (propertyInspector.isEditing()) {
                propertyInspector.stopEditing();
            }
            for (RadComponent radComponent : selection) {
                if (!property.isModified(radComponent)) continue;
                property.resetValue(radComponent);
                radComponent.getDelegee().invalidate();
            }
            editor.refreshAndSave(false);
            propertyInspector.repaint();
        }
        catch (Exception e1) {
            LOG.error((Throwable)e1);
        }
    }

    @Override
    protected void update(GuiEditor editor, ArrayList<? extends RadComponent> selection, AnActionEvent e) {
        PropertyInspectorTable inspector = (PropertyInspectorTable)((Object)PropertyInspectorTable.DATA_KEY.getData(e.getDataContext()));
        if (inspector != null) {
            Property selectedProperty = inspector.getSelectedProperty();
            e.getPresentation().setEnabled(selectedProperty != null && selection.size() > 0 && inspector.isModifiedForSelection(selectedProperty));
        } else {
            e.getPresentation().setEnabled(false);
        }
    }
}

