/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.palette.impl;

import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.palette.impl.PaletteWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.uiDesigner.AbstractToolWindowManager;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteToolWindowManager
extends AbstractToolWindowManager {
    private final PaletteWindow myToolWindowPanel;

    public PaletteToolWindowManager(Project project, FileEditorManager fileEditorManager) {
        super(project, fileEditorManager);
        PaletteWindow paletteWindow = this.myToolWindowPanel = ApplicationManager.getApplication().isHeadlessEnvironment() ? null : new PaletteWindow(project);
        if (this.myToolWindowPanel != null) {
            Disposer.register((Disposable)this, () -> this.myToolWindowPanel.dispose());
        }
    }

    public static PaletteWindow getInstance(GuiEditor designer) {
        PaletteToolWindowManager manager = PaletteToolWindowManager.getInstance(designer.getProject());
        if (manager.isEditorMode()) {
            return (PaletteWindow)manager.getContent(designer);
        }
        return manager.myToolWindowPanel;
    }

    public static PaletteToolWindowManager getInstance(Project project) {
        return (PaletteToolWindowManager)((Object)project.getComponent(PaletteToolWindowManager.class));
    }

    protected void initToolWindow() {
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(IdeBundle.message((String)"toolwindow.palette", (Object[])new Object[0]), false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowPalette);
        this.initGearActions();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)this.myToolWindowPanel, null, false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)this.myToolWindowPanel);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false, null);
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myToolWindowPanel.refreshPaletteIfChanged((GuiEditor)designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
        } else {
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    protected ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.RIGHT;
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            PaletteToolWindowManager.$$$reportNull$$$0(0);
        }
        PaletteWindow palettePanel = new PaletteWindow(this.myProject);
        palettePanel.refreshPaletteIfChanged((GuiEditor)designer);
        return this.createContent(designer, palettePanel, IdeBundle.message((String)"toolwindow.palette", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowPalette, palettePanel, palettePanel, 180, null);
    }

    @NotNull
    public String getComponentName() {
        if ("PaletteManager" == null) {
            PaletteToolWindowManager.$$$reportNull$$$0(1);
        }
        return "PaletteManager";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/palette/impl/PaletteToolWindowManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/palette/impl/PaletteToolWindowManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

